﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Product;
using Base;
using Corporation.Product;
using System.Text.RegularExpressions;

public partial class member_Trade_SupplyEdit : nspBase.MemberBasePge
{
    RProType ProType = new RProType();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckCookies())
        {
            Response.Redirect("../ErrorPage.aspx?Err=0");
            return;
        }
        else
        {
            if (!IsPostBack)
            {
                ProTypeBind();
                UnitBind();
                PersonInfoBind();
                Bind();
                aload();
            }
        }
    }
    private void ProTypeBind()
    {
        dropProType.Items.Add(new ListItem("--+所有类别+--", ""));
        TProType TPro = new TProType();
        TPro.UserID = Convert.ToInt32(GetCookie("UserID").ToString());
        DataTable dt = ProType.GetDataTable(TPro);
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {

                dropProType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));

            }
        }
    }
    private void UnitBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/UnitPrice.xml"));
        dropUnit.DataSource = ds.Tables[0];
        dropUnit.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropUnit.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropUnit.DataBind();
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISupply RSupp = new RSupply();
        TSupply TSupp = RSupp.GateItem(id);
        if (TSupp != null)
        {
            this.txtName.Text =Server.HtmlDecode(TSupp.Name);
            this.txtKey.Text = Server.HtmlDecode(TSupp.Key);
            if (TSupp.Picture_1 == "")
            {
                this.ImgUrl1.Value = "../../Images/System/wutu.gif";
                this.ImgUrl.Src = "../../Images/System/wutu.gif";
            }
            else
            {
                this.ImgUrl1.Value = TSupp.Thumbnail;
                this.ImgUrl.Src = TSupp.Thumbnail;
            }
            this.dropProType.SelectedValue = TSupp.ProType.ToString();
            this.txtPlace.Text =Server.HtmlDecode(TSupp.Place);
            this.txtBrand.Text = Server.HtmlDecode(TSupp.Brand);
            this.txtModel.Text = Server.HtmlDecode(TSupp.Model);
            this.txtPrice.Text = TSupp.Price.ToString();
            this.txtQuantity.Text = TSupp.Quantity.ToString();
            this.dropUnit.SelectedValue = TSupp.Units;
            this.txtMinimum.Text = TSupp.Minimum.ToString();
            this.radlDeadline.SelectedValue = TSupp.Deadline.ToString();
            this.txtContent.Value = TSupp.Info;
            TimeSpan time = new TimeSpan(TSupp.EndDate.Ticks - TSupp.StartDate.Ticks);
            this.RadioTime.SelectedValue = time.Days.ToString();
            //this.txtRemark.Text = TSupp.Remark;
            //this.txtDocument.Text = TSupp.Document;
        }


        if (TSupp.IndType != null)
        {
            string[] str = TSupp.IndType.Split(new char[] { ',' });
            for (int i = 0; i < str.Length; i++)
            {
                if (i == 0)
                    this.txtSortB.Value = str[i];
                else if (i == 1)
                    this.txtSortM.Value = str[i];
                else
                    this.txtSortS.Value = str[i];
            }
        }

    }
    private void PersonInfoBind()
    {
        DataTable tbuserinfo = ProType.GetPersonInfoById(Convert.ToInt32(GetCookie("UserID").ToString()));
        if (tbuserinfo.Rows.Count != 0)
        {
            this.UserName.Text = tbuserinfo.Rows[0]["LinkName"].ToString() + "(" + tbuserinfo.Rows[0]["sex"].ToString() + ")";
            this.UserTelephone.Text = tbuserinfo.Rows[0]["Tel_International"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_DistrictNumber"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_Telephone"].ToString();
            this.UserChuanzhen.Text = tbuserinfo.Rows[0]["qq"].ToString();
            this.CompanyName.Text = tbuserinfo.Rows[0]["CompanyName"].ToString();
            this.Email.Text = tbuserinfo.Rows[0]["Email"].ToString();
        }
    }
    private void aload()
    {
        this.danwei.InnerHtml = "元/" + this.dropUnit.SelectedItem.ToString();
        this.gonghuo.InnerHtml = this.dropUnit.SelectedItem.ToString();
        this.zuixiaoqi.InnerHtml = this.dropUnit.SelectedItem.ToString();
    }
    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        String error = "";
        Base.Common comon = new Common();
        try
        {
            string myValue = "";
            if (Request.Form["ctl00$ContInfo$SortB"] != null && Request.Form["ctl00$ContInfo$SortB"] != "")
                myValue += Request.Form["ctl00$ContInfo$SortB"];
            if (Request.Form["ctl00$ContInfo$SortM"] != null && Request.Form["ctl00$ContInfo$SortM"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortM"];
            if (Request.Form["ctl00$ContInfo$SortS"] != null && Request.Form["ctl00$ContInfo$SortS"] != "")
                myValue += "," + Request.Form["ctl00$ContInfo$SortS"];
            TSupply TSup = new TSupply();
            int id = int.Parse(Request.QueryString["ID"].ToString());
            TSup.ID = id;
            if (String.IsNullOrEmpty(txtName.Text))
            {
                error += "产品名称不能为空<br/>";
            }
            else
            {

                TSup.Name = Server.HtmlEncode(Base.Common.RemoveHTML(this.txtName.Text)); //过滤字符串
            }
            if (string.IsNullOrEmpty(txtKey.Text))
            {
                error += "关键字不能为空<br/>";
            }
            else
            {
                    ArrayList array = new ArrayList();
                    String newvalue = this.txtKey.Text;
                    String oldvalue = newvalue.Replace("，", ",");
                    String[] arry = oldvalue.Split(',');//拿逗号隔开后的字符串
                    for (int i = 0; i < arry.Length; i++)
                    {
                        if (array.Contains(arry[i]) == false)//判断 要拆分的字符串 中是否已经存在于这个ArrayList中   
                        {
                            array.Add(arry[i]);//不存在则添加进ArrayList   
                        }
                    }
                    TSup.Key =Server.HtmlEncode(String.Join(",", (string[])array.ToArray(typeof(string))));//在指定 String 数组的每个元素之间串联指定的分隔符 String，从而产生单个串联的字符串
            }

            if (string.IsNullOrEmpty(myValue))
            {
                error += "产品所属类目不能为空<br/>";
            }
            else
            {
                TSup.IndType = myValue;
            }
            TSup.AddDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TSup.StartDate =Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TSup.EndDate = DateTime.Now.AddDays(Convert.ToDouble(this.RadioTime.SelectedValue));
            TSup.Picture_1 = this.ImgUrl1.Value;
            TSup.Thumbnail = this.ImgUrl1.Value;
            if (dropProType.SelectedValue != "")
                TSup.ProType = int.Parse(dropProType.SelectedValue);
            TSup.Place = Server.HtmlEncode(this.txtPlace.Text);
            TSup.Brand = Server.HtmlEncode(this.txtBrand.Text);
            TSup.Model =Server.HtmlEncode( this.txtModel.Text);
            if (!String.IsNullOrEmpty(txtPrice.Text))
            {
                if (comon.IsValidPrice(txtPrice.Text))
                {
                    TSup.Price = Convert.ToDouble(this.txtPrice.Text);
                }
                else
                {
                    error += "价格格式不正确<br/>";
                }
            }
            else
            {
                TSup.Price = 1;
            }
            if (!String.IsNullOrEmpty(txtQuantity.Text))
            {
                if (Base.Common.CheckNum(txtQuantity.Text))
                {
                    if (Convert.ToInt32(txtQuantity.Text) > 1000000)
                    {
                        error += "供货总量最大值不能大于1000000<br/>";
                    }
                    else
                    {
                        TSup.Quantity = int.Parse(this.txtQuantity.Text);
                    }
                }
                else
                {
                    TSup.Quantity = 1;
                }
            }

            TSup.Units = this.dropUnit.SelectedValue;
            if (!String.IsNullOrEmpty(txtMinimum.Text))
            {
                if (Base.Common.CheckNum(txtMinimum.Text))
                {
                    if (Convert.ToInt32(txtMinimum.Text) > TSup.Quantity)
                    {
                        error += "最小起定量不能大于供货总量<br/>";
                    }
                    else
                    {
                        TSup.Minimum = int.Parse(this.txtMinimum.Text);
                    }
                }
                else
                {
                    TSup.Minimum = 1;
                }
            }
            int num = 0;
            TSup.Deadline = int.Parse(this.radlDeadline.SelectedValue);
            string strContent = Base.GetRequest.RemoveHTMLForEditor(this.txtContent.Value);
            TSup.Info = Base.GetRequest.WipeScript(strContent);
            ISupply RSup = new RSupply();
            if (error != "")
            {
                this.lblMessage.Text = "<font color='red'>" + error + "</font>";
                return;
            }
            num = RSup.Update(TSup);
            if (num > 0)
            {
                ShowMessage("恭喜您，供应信息修改成功！", "Trade/SupplyManage.aspx?class=MenuLiCheck");
            }

        }
        catch (Exception ex)
        {

            this.lblMessage.Text = "<font color='red'>服务器繁忙,请稍后再试！</font>";
        }

    }
}
