﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Product;
using Base;
using Solely;
using SqlOperate;

public partial class Purchase_PurchaseAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            UnitBind();
            if (Request.QueryString["Title"] != "" && Request.QueryString["Title"] != null)
            {
                string strName = Base.GetRequest.Filter(Request.QueryString["Title"].ToString().Trim());
                txtName.Text =Base.GetRequest.WipeScript(strName);
            }
            this.bt.Text = Common.GetBottom(bt.Text);
			this.dl.Text = Base.Common.GetBottom(this.dl.Text);
        }
    }

    private void UnitBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/UnitPrice.xml"));
        dropUnit.DataSource = ds.Tables[0];
        dropUnit.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropUnit.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropUnit.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            string myValue = "";
            if (Request.Form["SortB"] != null && Request.Form["SortB"] != "")
                myValue += Request.Form["SortB"];
            if (Request.Form["SortM"] != null && Request.Form["SortM"] != "")
                myValue += "," + Request.Form["SortM"];
            if (Request.Form["SortS"] != null && Request.Form["SortS"] != "")
                myValue += "," + Request.Form["SortS"];
            int id = 0;
            TPurchase TPur = new TPurchase();
            if (Request.QueryString["ID"] != null)
            {
                id = int.Parse(Request.QueryString["ID"]);
                TPur.IsUser = "1";
            }
            if (Request.QueryString["VisitorID"] != null)
            {
                id = int.Parse(Request.QueryString["VisitorID"]);
                TPur.IsUser = "0";
            }
            TPur.UserID = id;
            TPur.IndType = myValue;
            if (txtName.Text.Trim().Equals(string.Empty))
                Restr += "产品名称，";
            else
                TPur.Name = this.txtName.Text;
            if (txtKey.Text.Trim().Equals(string.Empty))
            {
                Restr += "关键字，";
            }
            else
            {
                ArrayList array = new ArrayList();
                String newvalue = this.txtKey.Text;
                String oldvalue = newvalue.Replace("，", ",");
                String[] arry = oldvalue.Split(',');//拿逗号隔开后的字符串
                for (int i = 0; i < arry.Length; i++)
                {
                    if (array.Contains(arry[i]) == false)//判断 要拆分的字符串 中是否已经存在于这个ArrayList中   
                    {
                        array.Add(arry[i]);//不存在则添加进ArrayList   
                    }
                }
                TPur.Key = Server.HtmlEncode(String.Join(",", (string[])array.ToArray(typeof(string))));//在指定 String 数组的每个元素之间串联指定的分隔符 String，从而产生单个串联的字符串
            }
            TPur.Info = this.txtContent.Value;
            TPur.Picture_1 = this.ImgUrl1.Value;
            //TPur.Picture_1 = this.ImgLogo.Value;
            TPur.AddDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TPur.StartDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TPur.EndDate = DateTime.Now.AddDays(Convert.ToDouble(this.RadioTime.SelectedValue));
            TPur.Brand = this.txtBrand.Text;
            TPur.Model = this.txtModel.Text;
            TPur.Unit = dropUnit.SelectedValue;
            TPur.Count = int.Parse(txtCount.Text);
			TPur.Price = Convert.ToDouble(txtPrice.Text);
            IPurchase Rpur = new RPurchase();
            if (!Restr.Trim().Equals(string.Empty))
                Restr = Restr.Substring(0, Restr.Length - 1);
            if (Restr.Trim().Equals(string.Empty))
            {
                int isEmail = 0;
                Rpur.Insert(TPur, out isEmail);
                ShowMessage("发布成功!等待审核!", "../Default.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }

    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("PurchaseManage.aspx");
    }
}
