﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

public partial class Search_Enquiry : Base.BasePage
{
    string str = "", ThisUrl = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        ThisUrl = Request.Url.ToString();
        if (CheckCookies())
        {
            if (Request.QueryString["cpid"] != null)
            {
                string str = Request.QueryString["cpid"].ToString();
                if (str == "" || str == null)
                    Base.BasePage.ShowMessage("至少选择一条信息", "");
                else
                    BuildTable(GetTable(str), str.Split(',').Length);
            }

        }
        else
        {
            Response.Redirect("" + Base.BasePage.Config.WebURL + "/login/login.aspx?done=" + ThisUrl);
        }
        if (!IsPostBack)
        {
            this.bt.Text = Base.Common.GetBottom(this.bt.Text);
            this.dl.Text = Base.Common.GetBottom(this.dl.Text);
        }

    }

    /// <summary>
    /// 取得比较数据
    /// </summary>
    /// <returns></returns>
    private DataTable GetTable(string CompareID)
    {
        string strType = Request.QueryString["type"].ToString();
        if (strType.ToUpper() == "SUPPLY")
        {
            strType = "[C_Supply]";
        }
        else
        {
            strType = "W_WillAgent";
        }
        string str = "where ID in (" + CompareID.ToString() + ") ";
        SqlParameter[] param = new SqlParameter[] 
        {
            new SqlParameter("@strwhere", str),
            new SqlParameter("@strtableName", strType), 
            new SqlParameter("@strOrder", " order by AddDate  desc,ID desc") 
        };
        return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

    }


    /// <summary>
    /// 创建目录列表 
    /// </summary>
    private void BuildTable(DataTable ReTable, int len)
    {

        string strTypeID = "";
        // 清除原有的行
        this.TblDirList.Rows.Clear();
        TableRow Top = new TableRow();
        TblDirList.Rows.Add(Top);
        TableCell tcell = new TableCell();
        tcell.Text = "接 收 方:";
        Top.Cells.Add(tcell);
        this.strTypeID.Value = str.ToString();
        TableCell tt = new TableCell();
        tt.Text = "总共 " + len + " 条信息. ";
        Top.Cells.Add(tt);
        for (int j = 0; j < ReTable.Rows.Count; j++)
        {
            strTypeID += ReTable.Rows[j]["UserID"].ToString() + ",";
            // 添加TR
            TableRow tr = new TableRow();
            TblDirList.Rows.Add(tr);
            // 添加TD
            TableCell iCell = new TableCell();
            iCell.Text = "";
            tr.Cells.Add(iCell);
            TableCell iconCell = new TableCell();
            iconCell.Text = (j + 1) + "、<a href='../supply/detail.aspx?id=" + ReTable.Rows[j]["ID"].ToString() + "'>" + ReTable.Rows[j]["Name"].ToString() + "</a>";
            tr.Cells.Add(iconCell);
        }
        this.strTypeID.Value = strTypeID.TrimEnd(',');
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            string strContent = "";
            Message.TMessage tmg = new Message.TMessage();
            if (GetCookie("UserID") != null)
                tmg.SendUserID = Convert.ToInt32(GetCookie("UserID"));   //发送者
            else
                Response.Redirect("" + Base.BasePage.Config.WebURL + "/login/login.aspx?done=" + ThisUrl);
            if (txtTitle.Text.Trim().Equals(string.Empty))
                Restr += "询价标题、";
            else
                tmg.Title = this.txtTitle.Text;                              //留言标题
            if (txtCount.Text.Trim().Equals(string.Empty))
            {
                Restr += "订货总量、";
            }
            else
            {
                if (Base.Common.CheckNum(txtCount.Text.Trim()))
                {
                    strContent += "订货总量：" + txtCount.Text.Trim() + "<br/>";
                }
                else
                {
                    ShowMessage("订货总量为数字");
                    return;
                }
            }
            if (txtPrice.Text.Trim().Equals(string.Empty))
            {
                Restr += "期望价格、";
            }
            else
                strContent += "期望价格：" + txtPrice.Text.Trim() + "<br/>";
            if (txtDetail.Value.Trim().Equals(string.Empty))
                Restr += "补充说明";
            else
                strContent += "补充说明：" + txtDetail.Value.Trim() + "<br/>";
            string strConsult = "";
            foreach (ListItem tt in chkConsult.Items)
            {
                if (tt.Selected)
                    strConsult += tt.Value + ",";
            }
            strConsult = "我需要进一步了解：" + strConsult.TrimEnd(',');
            tmg.Info = strContent + strConsult;                          //留言内容
            tmg.Date = DateTime.Now;                                     //留言时间
            string strParama = "";
            strParama = this.strTypeID.Value.ToString();                 //接收者
            string[] strUserID = strParama.Split(new char[] { ',' });
            for (int i = 0; i < strUserID.Length; i++)
            {
                if (strUserID[i] == GetCookie("UserID"))
                {
                    ShowMessage("对不起，自己不能给自己留言！");
                    return;
                }
            }
            tmg.Nature = "Supply";
            if (Restr != "")
                Restr = Restr.TrimEnd('、');                                   //关于哪方面的留言
            Message.RMessage rmg = new Message.RMessage();
            if (Restr.Equals(string.Empty))
            {
                rmg.Insert(tmg, strParama);
                ShowMessage("发送成功！", "../default.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch
        {
            ShowMessage("发送失败！请重新发送");
        }
    }

}
