﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Search_Online : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Base.BasePage.GetCookie("UserID") == "")
            {
                Response.Redirect("../Login/Login.aspx", true);
                return;
            }
            else
            {
                Bind();
            }
        }
    }

    /// <summary>
    /// 数据绑定
    /// </summary>
    private void Bind()
    {
        string strUserID = Base.BasePage.GetCookie("UserID");
        UserInfo.TUserInfo tu = new UserInfo.TUserInfo();
        UserInfo.IUserInfo ru=new UserInfo.RUserInfo();
        if (string.IsNullOrEmpty( strUserID))
        {
            Response.Redirect("../login/Login.aspx", true);
            return;
        }

        if (!Base.Common.CheckNum(strUserID))
        {
            Response.Redirect("../default.aspx",true);
            return;
        }
        this.ViewState["UserID"] = strUserID;
        tu = ru.GateItem(int.Parse(strUserID));
        this.txtName.Text = tu.LinkName.ToString();
        this.txtTel.Text = tu.Tel_International.ToString() + tu.Tel_DistrictNumber.ToString() + tu.Tel_Telephone.ToString() + tu.Tel_Ext.ToString();
        this.txtPhone.Text = tu.MobilePhone.ToString();
       
    }
    protected void butSave_Click(object sender, EventArgs e)
    {
        try
        {
            Message.TMessage tmg = new Message.TMessage();
            tmg.SendUserID = int.Parse(this.ViewState["UserID"].ToString());
            tmg.Title = this.txtTitle.Text;                                          //留言标题
            tmg.Info =  this.txtInfo.ToString();                                      //留言内容
            tmg.Date = DateTime.Now;                                                 //留言时间
            string strParama = "a";
            strParama = Request.QueryString["id"].ToString();                             //接收者
            if (!Base.Common.CheckNum(strParama))
            {
                Base.BasePage.ShowMessage("该公司不存在！", "../default.aspx");
            }
            tmg.Nature = "Company";                                                   //关于哪方面的留言

            Message.RMessage rmg = new Message.RMessage();
            rmg.Insert(tmg, strParama);
            Base.BasePage.ShowMessage("发送成功！", "../default.aspx");
        }
        catch
        {
            Base.BasePage.ShowMessage("发送失败！请重新发送");
        }
    }
}
