﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;
using System.Data.SqlClient;

public partial class Search_Quotation : Base.BasePage
{
    string ThisUrl = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        ThisUrl = Request.Url.ToString();
        if (CheckCookies())
        {
            int intPurchaseID = 0;
            if (Request.QueryString["id"] != null && Request.QueryString["id"] != "")
            {
                string strPurchaseID = Request.QueryString["id"].ToString();
                if (!Base.Common.CheckNum(strPurchaseID))
                {
                    Base.BasePage.ShowMessage("不存在该求购信息！", "default.aspx");
                    return;
                }
                else
                {
                    intPurchaseID = int.Parse(strPurchaseID);
                }
                bind();
            }
        }
        else
        {
            Response.Redirect("" + Base.BasePage.Config.WebURL + "/login/login.aspx?done=" + ThisUrl);
        }
        if (!IsPostBack)
        {
            this.bt.Text = Base.Common.GetBottom(this.bt.Text);
            this.dl.Text = Base.Common.GetBottom(this.dl.Text);
        }
    }

    /// <summary>
    ///  绑定数据信息
    /// </summary>
    private void bind()
    {
        DataTable dt = GetTable();
        this.xujia_text.InnerHtml = "<a href=\"../Purchase/detail.aspx?id=" + dt.Rows[0]["ID"] + "\" target=\"_blank\">" + dt.Rows[0]["Name"].ToString() + "</a>";
        this.hidUserID.Value = dt.Rows[0]["UserID"].ToString();
    }


    /// <summary>
    /// 取得比较数据
    /// </summary>
    /// <returns></returns>
    private static DataTable GetTable()
    {
        string str = "where ID=" + Base.GetRequest.GetQueryStringValue("id");
        SqlParameter[] param = new SqlParameter[] 
        {
            new SqlParameter("@strwhere", str),
            new SqlParameter("@strtableName", "C_Purchase"), 
            new SqlParameter("@strOrder", " order by AddDate  desc,ID desc") 
        };
        return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            Message.TMessage tmg = new Message.TMessage();
            if (Base.BasePage.GetCookie("UserID") != null)
            {
                tmg.SendUserID = Convert.ToInt32(Base.BasePage.GetCookie("UserID"));   //发送者
            }
            else
            {
                Response.Redirect("login/login.aspx");
            }
            if (txtTitle.Text.Trim().Equals(string.Empty))
                Restr += "询价标题、";
            else
                tmg.Title = this.txtTitle.Text.Trim();                   //留言标题
            if (txtInfo.Value.Trim().Equals(string.Empty))
                Restr += "补充信息、";
            else
                tmg.Info = this.txtInfo.Value.Trim();                   //留言内容
            tmg.Date = DateTime.Now;                                    //留言时间
            string strParama = "";
            strParama = this.hidUserID.Value.ToString();                 //接收者
            if (strParama != "")
            {
                if (strParama == GetCookie("UserID"))
                {
                    ShowMessage("对不起，自己不能给自己留言！");
                    return;
                }
            }
            else
                Response.Redirect("../default.aspx", true);
            tmg.Nature = "Purchase";                                     //关于哪方面的留言

            Message.RMessage rmg = new Message.RMessage();
            if (Restr != "")
                Restr = Restr.TrimEnd('、');                              //关于哪方面的留言
            if (Restr.Equals(string.Empty))
            {
                rmg.Insert(tmg, strParama);
                ShowMessage("发送成功！", "../default.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch
        {
            ShowMessage("发送失败！请重新发送");
        }
    }
}
