﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using UserInfo;
using Area;
using System.Data.SqlClient;

public partial class Search_SearchCompany : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
            AreaBind("");
            this.bt.Text = Common.GetBottom(bt.Text);
            this.lblHead.Text = Common.GetBottom(lblHead.Text);
            this.main_right.Text = Common.GetBottom(this.main_right.Text);
        }
    }

    public string GetVipGrade(string GradeID)
    {
        string str = "";
        SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqldata"].ConnectionString);
        SqlCommand cmd = new SqlCommand("SELECT [Flag] FROM [U_VipGrade] WHERE ID=@ID", con);
        cmd.Parameters.AddWithValue("@ID", GradeID);
        con.Open();
        SqlDataReader sr = cmd.ExecuteReader();
        if (sr.Read())
        {
            str = sr["Flag"].ToString();
        }
        con.Close();

        int k = 0;
        string strc = "";
        for (int i = 0; i < str.Length; i++)
        {
            if (k > 0)
            {
                strc += str[i];
            }
            if (str[i].Equals('/'))
            {
                k++;
            }

        }
        return Base.BasePage.Config.WebURL + strc;
    }
    private void Bind()
    {
        string str = "";
        int page = 1;
        if (Request.QueryString["keyword"] != null && Request.QueryString["keyword"] != "")
        {
            str = Base.GetRequest.GetRequestParameters(Request, "GB2312")["keyword"];
            str = Base.GetRequest.Filter(str);
            lblKey.Text += str;
        }
        if (Request.QueryString["strWhere"] != null && Request.QueryString["strWhere"] != "")
        {
            str = Request.QueryString["strWhere"].ToString();
        }
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            page = int.Parse(Request.QueryString["page"].ToString());
        }

        string strselect = "U_UserInfo.*";
        string table = "U_UserInfo";
        string strWhere = " CompanyName like '%" + str + "%' AND U_UserInfo.Verify=1 ";
        string AreaID = "";
        if (Request.QueryString["AreaID"] != null && Request.QueryString["AreaID"] != "")
        {
            AreaID = Request.QueryString["AreaID"];
            strWhere += " AND U_UserInfo.Province like '%" + Base.GetRequest.Filter(AreaID) + "%'";
        }
        DataTable dt = PageList.GetDataTable(strWhere, table, 0, "UserID", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstCompany.DataSource = dt.DefaultView;
        dlstCompany.DataBind();
        if (AreaID != "")
            lblPagination.Text = PageList.GoToPager(page, 10, "SearchCompany.aspx?AreaID=" + AreaID + "&page", strWhere, table);
        else
            lblPagination.Text = PageList.GoToPager(page, 10, "SearchCompany.aspx?page", strWhere, table);
    }


    /// <summary>
    /// 绑定地区
    /// </summary>
    /// <param name="str"></param>
    private void AreaBind(string str)
    {
        IArea area = new RArea();
        DataTable dt = area.GetDataTable(0);
        DropDownList provinceDL = (DropDownList)dlstCompany.Controls[0].Controls[0].FindControl("dropArea");
        provinceDL.DataSource = dt.DefaultView;
        provinceDL.DataBind();
        provinceDL.DataValueField = "Name";
        provinceDL.DataTextField = "Name";
        provinceDL.DataBind();
        ListItem li = new ListItem("所有地区", "");
        provinceDL.Items.Add(li);
        if (str == "")
            li.Selected = true;
        else
            provinceDL.SelectedValue = str;

    }


    protected void dropArea_SelectedIndexChanged(object sender, EventArgs e)
    {
        string str = "";
        string strWhere = " U_UserInfo.Verify=1 ";
        int page = 1;
        string strselect = " U_UserInfo.*";
        string table = " U_UserInfo";
        if (Request.QueryString["strWhere"] != null && Request.QueryString["strWhere"] != "")
        {
            str = Request.QueryString["strWhere"].ToString();
        }
        string area = ((DropDownList)dlstCompany.Controls[0].FindControl("dropArea")).SelectedValue;

        if (((DropDownList)dlstCompany.Controls[0].FindControl("dropArea")).SelectedValue != "")
        {
            strWhere += " and Province like '%" + area + "%'";

        }
        DataTable dt = PageList.GetDataTable(strWhere, table, 0, "UserID", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstCompany.DataSource = dt.DefaultView;
        dlstCompany.DataBind();
        lblPagination.Text = PageList.GoToPager(page, 10, "SearchCompany.aspx?AreaID=" + area + "&page", strWhere, table);
        AreaBind(area);
    }


}
