﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;

public partial class Search_SearchExpo : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
            this.bt.Text = Common.GetBottom(bt.Text);
            this.lblHead.Text = Common.GetBottom(lblHead.Text);
	    this.main_right.Text = Common.GetBottom(this.main_right.Text);
        }
    }

    private void Bind()
    {
        string Key = "";
        string year = "";
        string month = "";
        string type = "";
        int page = 1;
        if (Request.Form["Key"] != null && Request.Form["Key"] != "")
        {
            Key = Request.Form["Key"];
            Key = Base.GetRequest.Filter(Key);
        }
        if (Request.Form["year"] != null && Request.Form["year"] != "")
        {
            year = Request.Form["year"];
            year = Base.GetRequest.Filter(year);
        }
        if (Request.Form["month"] != null && Request.Form["month"] != "")
        {
            month = Request.Form["month"];
            month = Base.GetRequest.Filter(month);
        }
        if (Request.Form["type"] != null && Request.Form["type"] != "")
        {
            type = Request.Form["type"];
            type = Base.GetRequest.Filter(type);
        }
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            page = int.Parse(Request.QueryString["page"].ToString());
        }

        string strselect = "W_Expo.*";
        string table = "W_Expo";
        string strWhere = " W_Expo.Verify=1 ";
        if (Key != "")
        {
            strWhere += " AND Title like '%" + Key + "%'";
            lblKey.Text += Key;
        }
        if (year != "")
        {
            strWhere += " AND  datepart(year,AddDate)=" + year;
        }
        if (month != "")
        {
            strWhere += " AND  datepart(month,AddDate)=" + month;
        }
        if (type != "")
        {
            strWhere += " AND  ExpoType='" + type + "'";
        }
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "AddDate", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstNews.DataSource = dt.DefaultView;
        dlstNews.DataBind();
        lblPagination.Text = PageList.GoToPager(page, 10, "SearchExpo.aspx?page", strWhere, table);

    }

    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }

    public string ProcessImg(string strImage)
    {
        if (strImage != string.Empty)
        {
            string image = ProcessAbsoluteUrl(strImage);
            string str = "<img src='" + image + "'width='83px' height='83px'>";
            return str;
        }
        else
            return string.Empty;
    }

    protected void dropArea_SelectedIndexChanged(object sender, EventArgs e)
    {
        string Key = "";
        string type = "";
        int page = 1;
        string Date = ((DropDownList)dlstNews.Controls[0].FindControl("dropDate")).SelectedValue;
        if (Request.Form["Key"] != null && Request.Form["Key"] != "")
        {
            Key = Request.Form["Key"];
        }
        if (Request.Form["type"] != null && Request.Form["type"] != "")
        {
            type = Request.Form["type"];
        }
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            page = int.Parse(Request.QueryString["page"].ToString());
        }
        string strselect = "W_Expo.*";
        string table = "W_Expo";
        string strWhere = " W_Expo.Verify=1 ";
        if (Key != "")
        {
            strWhere += " AND Title like '%" + Key + "%'";
        }
        if (type != "")
        {       
            strWhere += " AND  ExpoType='" + type + "'";
        }
        if (Date != "")
        {
            switch (Date.ToString())
            {
                case "最近三天":
                    strWhere = strWhere + " AND datediff(day,AddDate,getdate())<=3";
                    break;
                case "最近一周":
                    strWhere = strWhere + " AND datediff(day,AddDate,getdate())<=7";
                    break;
                case "最近一个月":
                    strWhere = strWhere + " AND datediff(day,AddDate,getdate())<=30";
                    break;
                case "最近三个月":
                    strWhere = strWhere + " AND datediff(m,AddDate,getdate()) <=3";
                    break;
            }
        }
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "AddDate", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstNews.DataSource = dt.DefaultView;
        dlstNews.DataBind();

        lblPagination.Text = PageList.GoToPager(page, 10, "SearchExpo.aspx?page", strWhere, table);
        ((DropDownList)dlstNews.Controls[0].FindControl("dropDate")).SelectedValue = Date;
    }

}
