﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Product;
using Area;
using System.Data.SqlClient;

public partial class Search_SearchSupply : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["AreaID"] != null && Request.QueryString["AreaID"] != "")
            {
                string Area = Request.QueryString["AreaID"];
                string TID = "";
                if (Request.QueryString["TID"] != null && Request.QueryString["TID"] != "")
                {
                    TID = Request.QueryString["TID"];
                }
                Bind();
                AreaBind("");
                BindWhereSupply(Area, TID);
            }
            else
            {
                Bind();
                AreaBind("");
            }
            this.bt.Text = Common.GetBottom(bt.Text);
            this.lblHead.Text = Common.GetBottom(lblHead.Text);
            this.main_right.Text = Common.GetBottom(this.main_right.Text);
        }
    }
    public string GetVipGrade(string GradeID)
    {
        string str = "";
        SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqldata"].ConnectionString);
        SqlCommand cmd = new SqlCommand("SELECT [Flag] FROM [U_VipGrade] WHERE ID=@ID", con);
        cmd.Parameters.AddWithValue("@ID", GradeID);
        con.Open();
        SqlDataReader sr = cmd.ExecuteReader();
        if (sr.Read())
        {
            str = sr["Flag"].ToString();
        }
        con.Close();

        int k = 0;
        string strc = "";
        for (int i = 0; i < str.Length; i++)
        {
            if (k > 0)
            {
                strc += str[i];
            }
            if (str[i].Equals('/'))
            {
                k++;
            }

        }
        return Base.BasePage.Config.WebURL + strc;
    }
    private void Bind()
    {
        string str = "";
        string strUrl = "SearchSupply.aspx?";
        int page = 1;
        if (Request.QueryString["keyword"] != null && Request.QueryString["keyword"] != "")
        {
            str = Base.GetRequest.GetRequestParameters(Request, "GB2312")["keyword"];
            str = Base.GetRequest.Filter(str);
            lblKey.Text += str;
            strUrl += "keyword=" + str + "&";
        }
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            page = int.Parse(Request.QueryString["page"].ToString());
        }
        ISupply RSup = new RSupply();
        string strselect = "U_UserInfo.LoginName,U_UserInfo.CompanyName,U_UserInfo.Country,U_UserInfo.Province,U_UserInfo.City,U_UserInfo.QQ,C_Supply.*";
        string table = "C_Supply left join U_UserInfo ON C_Supply.UserID =U_UserInfo.UserID";
        string strWhere = " C_Supply.Name like '%" + str + "%' AND C_Supply.Verify=1";
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "C_Supply.AddDate", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstSupply.DataSource = dt.DefaultView;
        dlstSupply.DataBind();
        strUrl += "Page";
        lblPagination.Text = PageList.GoToPager(page, 10, strUrl, strWhere, table);
    }

    /// <summary>
    /// 处理图片路径
    /// </summary>
    /// <param name="strImageURL"></param>
    /// <returns></returns>
    public static string ProcessImageUrl(string strImageURL)
    {
        string strURL = Base.BasePage.Config.WebURL;
        if (strImageURL != "")
        {
            strURL = strImageURL.Replace("../../../", strURL).Replace("../../", strURL).Replace("../", strURL);
        }
        return strURL;
    }

    /// <summary>
    /// 绑定地区
    /// </summary>
    /// <param name="str"></param>
    private void AreaBind(string str)
    {
        IArea area = new RArea();
        DataTable dt = area.GetDataTable(0);
        DropDownList provinceDL = (DropDownList)dlstSupply.Controls[0].FindControl("dropArea");
        provinceDL.DataSource = dt;
        provinceDL.DataBind();
        provinceDL.DataTextField = "Name";
        provinceDL.DataValueField = "Name";
        provinceDL.DataBind();
        ListItem li = new ListItem("所有地区", "");
        provinceDL.Items.Add(li);
        if (str == "")
            li.Selected = true;
        else
            provinceDL.SelectedValue = str;

    }

    protected void BindWhereSupply(string Area, string TID)
    {
        int page = 1;
        string strWhere = " C_Supply.Verify=1";
        ISupply RSup = new RSupply();
        string strselect = "U_UserInfo.CompanyName,U_UserInfo.Province,U_UserInfo.QQ,C_Supply.*";
        string table = "C_Supply INNER JOIN U_UserInfo ON C_Supply.UserID =U_UserInfo.UserID";
        if (Area != "")
        {
            Area = Base.GetRequest.Filter(Area);
            strWhere += " and U_UserInfo.Province like '%" + Area + "%'";
        }
        if (TID != "")
        {
            strWhere += " AND C_Supply.IndType like '%" + TID + "%'";
        }
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            page = int.Parse(Request.QueryString["page"].ToString());
        }
        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "C_Supply.AddDate", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstSupply.DataSource = dt.DefaultView;
        dlstSupply.DataBind();
        lblPagination.Text = PageList.GoToPager(page, 10,"SearchSupply.aspx?AreaID="+Area+"&page", strWhere, table);
        AreaBind(Area);
    }

    protected void dropArea_SelectedIndexChanged(object sender, EventArgs e)
    {
        string str = "";
        int page = 1;
        string strWhere = " C_Supply.Verify=1";
        ISupply RSup = new RSupply();
        string strselect = "U_UserInfo.CompanyName,U_UserInfo.Province,U_UserInfo.QQ,C_Supply.*";
        string table = "C_Supply INNER JOIN U_UserInfo ON C_Supply.UserID =U_UserInfo.UserID";

        if (Request.QueryString["strWhere"] != null && Request.QueryString["strWhere"] != "")
        {
            str = Request.QueryString["strWhere"].ToString();
        }
        string area = ((DropDownList)dlstSupply.Controls[0].FindControl("dropArea")).SelectedValue;

        if (((DropDownList)dlstSupply.Controls[0].FindControl("dropArea")).SelectedValue != "")
        {
            strWhere += " and U_UserInfo.Province like '%" + area + "%'";

        }

        DataTable dt = PageList.GetDataTable(strWhere, table, 1, "C_Supply.AddDate", "*", 10, page, 0);
        DataTable dc = PageList.GetDataTable(strWhere, table);
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblCount.Text = "0";
            lblMessage.Text = "<font color='red' size='5pt'>暂无数据</font>";
        }
        else
        {
            lblMessage.Visible = false;
            lblCount.Text = " " + dc.Rows[0][0].ToString() + " ";
        }
        dlstSupply.DataSource = dt.DefaultView;
        dlstSupply.DataBind();
        lblPagination.Text = PageList.GoToPager(page, 10, "SearchSupply.aspx?AreaID=" + area+ "&page", strWhere, table);
        AreaBind(area);
    }

    protected string getArea(string str)
    {
        if (str == "中国")
        {
            return "";
        }
        else
        {
            return str;
        }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ImageButton1_Command(object sender, CommandEventArgs e)
    {
        string str = "";
        str = e.CommandArgument.ToString();
        if (Request.QueryString["type"] == null)
        {
            Response.Redirect("/Search/Inquiry.aspx?cpid=" + e.CommandArgument.ToString());
        }
        else {
            string strType = Request.QueryString["type"].ToString();
            Response.Redirect("/Search/Inquiry.aspx?type="+strType+"&cpid=" + e.CommandArgument.ToString());
        }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ImageButton2_Command(object sender, CommandEventArgs e)
    {
        string str = "";
        str = e.CommandArgument.ToString();
        Response.Redirect("../Shop/Contact/"+str+".aspx");
    }

}
