﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Agent;
using UserInfo;
using System.Data.SqlClient;

public partial class Search_SendMessage : BasePage
{
    private int _ID = 0;
    private TSincereAgent _Tsin;
    private TUserInfo _User;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {

        }
        else
            Response.Redirect("../login/login.aspx");
        if (Request.QueryString["ID"] != "" && Request.QueryString["ID"] != null)
        {
            _ID = int.Parse(Request.QueryString["ID"]);
            _Tsin = new RSincereAgent().GateItem(_ID);
            if (_Tsin != null)
            {
                _User = new RUserInfo().GateItem(_Tsin.UserID);
                Bind(_Tsin, _User);
            }
			if (!IsPostBack)
        	{
            	//this.bt.Text = Common.GetBottom(bt.Text);
                this.lblHead.Text = Common.GetBottom(lblHead.Text);
                //this.main_right.Text = Common.GetBottom(this.main_right.Text);
        	}
        }
		
    }

    private void Bind(TSincereAgent t, TUserInfo u)
    {
        hypTitle.Text = t.Title;
        hypTitle.NavigateUrl = "../Agent/Detail-" + t.ID + BasePage.Config.Rewrite;
        hypUserName.Text = u.LinkName;
        hypUserName.NavigateUrl = "../Shop/Index/" + u.LoginName + BasePage.Config.Rewrite;
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        if (_Tsin.UserID==int.Parse(GetCookie("UserID")))
        {
            ShowMessage("您不能给自己发送信息!");
            return;
        }
        int MyID = 0;
        //判断Cookie是否为空如果为空说明浏览器禁用了Cookie
        if (Request.Cookies["CheckCode"] == null)
        {
            lblMessage.Text = "您的浏览器设置已被禁用Cookies,请设置浏览器允许使用Cookies后使用本系统";
        }
        //判断验证码与用户输入的是否相同
        if (string.Compare(Request.Cookies["CheckCode"].Value.ToLower(), txtCheckCode.Text.ToLower()) != 0)
        {
            lblMessage.Visible = true;
            lblMessage.Text = "验证码错误,请输入正确的验证码";
            return;
        }
        if (GetCookie("UserID") != null)
            MyID = Convert.ToInt32(GetCookie("UserID"));
        else
            Response.Redirect("../login/login.aspx");
        if (txtMessageTitle.Text.Trim() != "")
        {
            if (txtMessageContext.Text.Trim() != "")
            {
                if (MyID != 0)
                {
                    if (SendMessage(MyID.ToString(), txtMessageTitle.Text.Trim(), txtMessageContext.Text.Trim(), _Tsin.UserID.ToString()))
                    {
                        ShowMessage("发送成功!");
                    }
                    else
                    {
                        ShowMessage("发送失败!");
                    }
                }
            }
            else
            {
                ShowMessage("留言内容不能为空!");
            }
        }
        else
        {
            ShowMessage("信息标题不能为空!");
        }
    }

    private bool SendMessage(string SendID, string Title, string Info, string ReceID)
    {
        SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString);
        SqlCommand cmd = new SqlCommand("INSERT INTO [C_Message] ([SendUserID],[Title],[Info],[Date],[Nature],[ReceiveUserID]) VALUES (@SendID,@Title,@Info,@Date,@Nature,@ReceID)", con);
        cmd.Parameters.AddWithValue("@SendID", SendID);
        cmd.Parameters.AddWithValue("@Title", Title);
        cmd.Parameters.AddWithValue("@Info", Info);
        cmd.Parameters.AddWithValue("@Date", DateTime.Now.ToString());
        cmd.Parameters.AddWithValue("@Nature", "SincereAgent");
        cmd.Parameters.AddWithValue("@ReceID", ReceID);
        con.Open();
        if (cmd.ExecuteNonQuery() > 0)
        {
            return true;
        }
        con.Close();
        return false;
    }
}
