﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class install_CheckEnvironment : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CheckFileRights();
            //若能打开安装页面,则IIS版本检测通过
            img_IIS.ImageUrl = "~/install/images/checked.gif";
            lblCheckIIS.Text = "恭喜,IIS 版本信息检查通过!";
            if (CheckFK())
            {
                img_Other.ImageUrl = "~/install/images/checked.gif";
                lblCheckOther.Text = "恭喜,服务器信息检查通过!";
            }
            else
                btn_next.Enabled = false;
        }
    }

    /// <summary>
    /// 检查服务器FK版本
    /// </summary>
    /// <param name="DomainName"></param>
    /// <returns></returns>
    private bool CheckFK()
    {
        float FK = GetFKversion();
        if (FK >= 2.0)
        {
            img_FK.ImageUrl = "~/install/images/checked.gif";
            lblCheckFK.Text = "恭喜,.NET Framework 版本信息检查通过!";
            return true;
        }
        return false;
    }

    /// <summary>
    /// 获取服务器FK版本
    /// </summary>
    /// <param name="DomainName"></param>
    /// <returns></returns>
    public float GetFKversion()
    {
        try
        {
            string ver = System.Environment.Version.ToString();
            string vstr = "";
            for (int i = 0; i < ver.Length; i++)
            {
                vstr += ver[i].ToString();
                if (i == 2)
                {
                    break;
                }
            }
            return float.Parse(vstr);
        }
        catch (Exception ex)
        {
            return 0;
        }
        return 0;
    }

    /// <summary>
    /// 检查关键文件的权限
    /// </summary>
    /// <param name="DomainName"></param>
    /// <returns></returns>
    protected void CheckFileRights()
    {
        string str = "\n";
        string[] fileNames ={ "web.config", "Js/industry.js", "Js/area.js", "Xml/ImageWater.xml" };
        string path = HttpContext.Current.Server.MapPath("~/");
        for (int i = 0; i < fileNames.Length; i++)
        {
            FileInfo fi = new FileInfo(path + fileNames[i]);
            try
            {
                fi.Open(FileMode.Open, FileAccess.ReadWrite);
                str += "<img src=\"images/checked.gif\"> 恭喜," + fi.Name + "&nbsp;检测通过!<br/> ";
            }
            catch (Exception Ex)
            {
                str += "<img src=\"images/cancel.gif\"> " + fi.Name + "&nbsp;检测未通过!请修改文件权限!<br/>";
            }
        }
        DirectoryInfo dc = new DirectoryInfo(path + "js / Advertisement");
        try
        {
            File.Create(path + "js/Advertisement/File");
            str += "<img src=\"images/checked.gif\"> 恭喜,js/Advertisement&nbsp;检测通过!<br/> ";
        }
        catch (Exception Ex)
        {
            str += "<img src=\"images/cancel.gif\"> js/Advertisement&nbsp;检测未通过!请修改文件夹权限!<br/>";
        }
        lblContext.Text = str;
    }
}
