﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspJob;
using System.Data.SqlClient;

public partial class Job_Index : System.Web.UI.Page
{
    protected string LableUrl = "ResumeManager.aspx";
    protected void Page_Load(object sender, EventArgs e)
    {
        //判断是否有权限，以及用户是否登陆如果不是跳转页面
        if (!IsPostBack)
        {
            this.lblHead.Text = Common.GetBottom(lblHead.Text);
            this.bt.Text = Common.GetBottom(bt.Text);
            string strUserName = Request.Form["UserName"];//获取页面传过来的用户名
            string strPass = Request.Form["PassWord"];//获取页面传过来的密码
            if (!string.IsNullOrEmpty(strUserName) && !string.IsNullOrEmpty(strPass))   //如果不为空则是从别的页面登陆
            {
                if (login(strUserName, strPass))
                    ViewPanel();  //用于显示 隐藏发布跟暂停panel
                else
                {
                    divLogin.Visible = true;
                    Resume.Visible = false;
                }
            }
            if (Request.Cookies["uName"] != null)  //如果已经登陆则不需要在登陆  
            {
                if ((GetRequest.CheckQueryStringisInt("jobid")))
                    JobObjective(Convert.ToInt32(Request.QueryString["jobid"].ToString())); //进行职位的应聘操作
                divLogin.Visible = false;
                Resume.Visible = true;
                LoginExists(true);
            }
            else
            {
                if (GetRequest.CheckQueryStringisInt("jobid"))
                    Session["jobid"] = Request.QueryString["jobid"].ToString();
                LoginExists(false);
            }
		
		GetResumeIdByUname();
		ViewPanel();
        }
    }

    /// <summary>
    /// 判断简历是否发布暂停 来动态改变按钮文本
    /// </summary>
    private void ViewPanel()
    {
        Rjob job = new Rjob();
        if (Request.Cookies["Resumeid"] != null)
        {
            if (job.GetStateIsEnable(Convert.ToInt32(Request.Cookies["Resumeid"].Value)) ==true)
                this.reselase.Text = "发布";
            else
                this.reselase.Text = "暂停";
        }
    }

    /// <summary>
    ///会员登陆
    /// </summary>
    /// <returns></returns>
    private bool login(string strUsername, string strPass)
    {
        if (new nspJob.RUser().GetDataExists(strUsername, strPass))
        {

            Response.Cookies["uName"].Value = strUsername;
            Response.Cookies["uName"].Expires = DateTime.Now.AddDays(1);
            Response.Cookies["uPwd"].Value = strPass;
            Response.Cookies["uPwd"].Expires = DateTime.Now.AddDays(1);//如果设置了过期时间并且大于当前时间，则会保存Cookies值。 
            GetResumeIdByUname();
            return true;
        }
        else
            return false;
    }

    /// <summary>
    /// 根据用户名获取简历id
    /// </summary>
    private void GetResumeIdByUname()
    {
        RResume rr = new RResume();
        DataTable tbResume =new DataTable();
        if (Request.Cookies["uName"] != null)
            tbResume = rr.GetDataTableByUname(Request.Cookies["uName"].Value);
        if (tbResume.Rows.Count != 0)
        {
            Response.Cookies["Resumeid"].Value = tbResume.Rows[0]["id"].ToString();
            Response.Cookies["Resumeid"].Expires = DateTime.Now.AddDays(1);
        }
    }

    /// <summary>
    /// 退出
    /// </summary>
    protected void BtnLgout_Click(object sender, EventArgs e)
    {
        DateTime dt = new DateTime();
        dt = DateTime.Now.AddDays(-1);
        Response.Cookies["uName"].Expires = dt;
        divLogin.Visible = true;
        Resume.Visible = false;
        LoginExists(false);
        Alert.Style.Add("display", "none");
    }

    /// <summary>
    /// 注销会员
    /// </summary>
    protected void btnLogout_Click(object sender, EventArgs e)
    {
        int num = 0;
        if (Request.Cookies["uName"] != null)
        {
            RUser user = new RUser();
            string uname = Request.Cookies["uName"].Value.ToString();
            num = user.DeleteUser(uname, Convert.ToInt32(Request.Cookies["Resumeid"].Value));
            DateTime dt = new DateTime();
            dt = DateTime.Now.AddDays(-1);
            Response.Cookies["uName"].Expires = dt;
            LoginExists(false);
        }
        Response.Redirect("~/Default.aspx");
    }

    /// <summary>
    /// 用户登陆
    /// </summary>
    protected void LoginButton_Click(object sender, EventArgs e)
    {
        if (login(this.UserName.Text, this.PassWord.Text))
        {
            FailureText.Text = "";
            divLogin.Visible = false;
            Resume.Visible = true;
            LoginExists(true);
            if (Session["jobid"] != null && Request.Cookies["uName"] != null)  //申请职位后登陆 已经注册为会员的进行应聘职位的操作
                JobObjective(Convert.ToInt32(Session["jobid"].ToString())); 
        }
        else
        {
            FailureText.Text = "用户名或密码不正确";
            divLogin.Visible = true;
            Resume.Visible = false;
            LoginExists(false);
        }
    }

    /// <summary>
    /// 菜单的显示跟隐藏
    /// </summary>
    /// <param name="num">true 或者 false
    /// true：显示菜单 false：隐藏菜单
    ///</param>
    private void LoginExists(bool num)
    {
        if (num)
        {
            btnLogout.Enabled = true;
            reselase.Enabled = true;
            BtnLgout.Enabled = true;
            ckjl.HRef = "ResumeManager.aspx";
            ckmm.HRef = "ChangePwd.aspx";
            ypzw.HRef = "PositionList.aspx";
        }
        else
        {
            btnLogout.Enabled = false;//注销
            reselase.Enabled = false;//发布
            BtnLgout.Enabled = false;//退出
            ckjl.HRef = "";
            ckmm.HRef = "";
            ypzw.HRef = "";
        }
    }

    /// <summary>
    /// 此方法用于应聘职位
    /// </summary>
    /// <param name="jobid"></param>
    private void JobObjective(int jobid)
    {
        int ResumeId = 0;//简历ID;
        int num = 0;
        if (Request.Cookies["Resumeid"] != null)
        {
            ResumeId = Convert.ToInt32(Request.Cookies["Resumeid"].Value);
        }
        try
        {
            RUser ru = new RUser();
            num = ru.InsertJobResume(ResumeId, jobid);
            if (num > 0)
            {
                Message.InnerHtml = "应聘职位成功";
                Alert.Style.Add("display", "block");
                LableUrl = "PositionList.aspx";
            }
        }
        catch (Exception ex)
        {
            if (ex.Message.Equals("此职位已经应聘过了"))
                Message.InnerHtml = ex.Message;
            else
                Message.InnerHtml = "系统繁忙，请稍后再试！";
            Alert.Style.Add("display", "block");
        }
    }

    /// <summary>
    /// 发布暂停简历
    /// </summary>
    protected void reselase_Click(object sender, EventArgs e)
    {
        if (Request.Cookies["Resumeid"] != null)
        {
            if (this.reselase.Text.ToString().Equals("发布"))
            {
                Solely.Other.UpOnlyDate("U_Resume", "isEnable=0", "id =" + Request.Cookies["Resumeid"].Value);
               
            }
            else
            {
                Solely.Other.UpOnlyDate("U_Resume", "isEnable=1", "id =" + Request.Cookies["Resumeid"].Value);
            }
            Alert.Style.Add("display", "none");
            ViewPanel();

        }
    }
}
