﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PositionList.aspx.cs" Inherits="job_PositionList" %>

<%@ Register Src="~/Control/PageNo.ascx" TagName="PageNo" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
<link href="../Css/system/general.css" rel="stylesheet" type="text/css" />
<link href="../Css/job/job.css" rel="stylesheet" type="text/css" />
<title>查看职位</title>
</head>
<body>
    <form id="form1" runat="server">
        <div class="table">
            <div class="top" style="margin-bottom: 10px;">
                所有职位
            </div>
            <asp:GridView ID="grdJob" runat="server" AutoGenerateColumns="False" CellPadding="0"
                Font-Overline="False" CssClass="gridview" GridLines="None">
                <HeaderStyle CssClass="gridheader" />
                <EmptyDataTemplate>
                    <table width="100%">
                        <tr>
                            <td style="text-align: left">
                                <asp:Label ID="Label1" runat="server" ForeColor="red" Text="暂无数据"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </EmptyDataTemplate>
                <Columns>
                    <asp:TemplateField HeaderText="职位名称">
                        <ItemTemplate>
                            <%# Eval("Position")%>
                        </ItemTemplate>
                        <ItemStyle CssClass="gridColumn" Width="200" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="公司名称">
                        <ItemTemplate>
                            <a style="text-decoration: underline; border-bottom-color: Red;" target="_blank" href='../shop/job/<%# Eval("LoginName")%>.aspx'>
                                <%# Eval("CompanyName")%>
                            </a>
                        </ItemTemplate>
                        <ItemStyle CssClass="gridColumn" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="登记时间">
                        <ItemTemplate>
                            <%# GetShortDate(DataBinder.Eval(Container.DataItem, "AddDate").ToString())%>
                        </ItemTemplate>
                        <ItemStyle CssClass="gridColumn" Width="100" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="招聘人数">
                        <ItemTemplate>
                            <%# Eval("Count")%>
                        </ItemTemplate>
                        <ItemStyle CssClass="gridColumn" Width="100" />
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <div style="float:right; margin: 0 auto; width: 350px; margin-top: 20px;">
                <p>
                    <uc1:PageNo ID="PageNo1" runat="server" />
                </p>
            </div>
        </div>
        <br />
    </form>
</body>
</html>
