﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using nspJob;
using Base;

public partial class Job_ResumeManager : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.Cookies["uName"] == null)
            {
                Response.Write("<script>location.assign('Index.aspx');</script>");
            }
            else
            {
                PositionTypeBind();
                Bind();
            }
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：对职位类别绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明></param>
    /// <returns>
    ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
    /// </returns>
    ///Create Date：2009-9-1
    ///**************************************************
    private void PositionTypeBind()
    {

        RResume jobtype = new RResume();
        DataTable dt = jobtype.GetDataTable("C_JobType");
        DrpTypePosition.DataSource = dt.DefaultView;
        DrpTypePosition.DataValueField = "ID";
        DrpTypePosition.DataTextField = "TypeName";
        DrpTypePosition.DataBind();
    }
    public void Bind()
    {
        RResume re = new RResume();
        String uName = "";
        if (Request.Cookies["uName"] != null)
        {
            uName = Server.HtmlEncode(Request.Cookies["uName"].Value);
        }
        DataTable table = re.GetDataTableByUname(uName);
        if (table.Rows.Count != 0)
        {
            ViewState["id"] = table.Rows[0]["ID"];
            this.txtPosition.Text = table.Rows[0]["WantPosition"].ToString();

            if (table.Rows[0]["Photo"].ToString() == "")
            {
                this.ImgUrl1.Value = "../Images/System/wutu.gif";
                this.ImgUrl.Src = "../Images/System/wutu.gif";
            }
            else
            {
                this.ImgUrl1.Value = table.Rows[0]["Photo"].ToString();
                this.ImgUrl.Src = table.Rows[0]["Photo"].ToString();
            }
            this.DrpSex.SelectedValue = table.Rows[0]["Sex"].ToString();
            this.txteducation.SelectedValue = table.Rows[0]["HighestEducation"].ToString();
            this.txtGraduteSchool.Text = table.Rows[0]["GraduateSchool"].ToString();
            this.txtNative.Text = table.Rows[0]["NativePlace"].ToString();
            this.txtWantAddress.Text = table.Rows[0]["WantAddress"].ToString();
            this.DrpTypePosition.SelectedValue = table.Rows[0]["TalentType"].ToString();
            this.txtAge.Text = Convert.ToDateTime(table.Rows[0]["DateofBirth"].ToString()).ToShortDateString();
            this.Radhunyin.SelectedValue = table.Rows[0]["MaritalStatus"].ToString();
            this.dropcomputer.SelectedValue = table.Rows[0]["ComputerRequest"].ToString();
            this.dropEnlish.SelectedValue = table.Rows[0]["EnglishRequest"].ToString();
            this.txtDescription.Text = table.Rows[0]["JobDescription"].ToString();
            this.txtPersonResum.Text = table.Rows[0]["PersResume"].ToString();
            this.dropsalary.SelectedValue = table.Rows[0]["WantSalary"].ToString();
            this.txtName.Text = table.Rows[0]["Name"].ToString();
            this.txtTelphone.Text = table.Rows[0]["Telephone"].ToString();
            this.txtEmail.Text = table.Rows[0]["Email"].ToString();
            this.txtQQ.Text = table.Rows[0]["QQ"].ToString();
            this.txtMobel.Text = table.Rows[0]["Mobile"].ToString();
            this.txtAddress.Text = table.Rows[0]["ContactAddress"].ToString();
            this.txtwork.SelectedValue = table.Rows[0]["txtwork"].ToString();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (!this.IsValid)
        {
            return;
        }
        TResume tr = new TResume();
        RResume re = new RResume();
        try
        {
            tr.ID = Convert.ToInt32(ViewState["id"].ToString());
            tr.WantPosition = this.txtPosition.Text;
            tr.Photo = ImgUrl1.Value;
            tr.DateofBirth = Convert.ToDateTime(this.txtAge.Text.ToString());
            tr.GraduateSchool = this.txtGraduteSchool.Text;
            tr.WantAddress = this.txtWantAddress.Text;
            tr.JobDescription = GetRequest.RemoveHTMLForEditor(this.txtDescription.Text);
            tr.NativePlace = txtNative.Text;
            tr.PersResume = GetRequest.RemoveHTMLForEditor(this.txtPersonResum.Text);
            tr.Name = this.txtName.Text;
            tr.QQ = this.txtQQ.Text;
            tr.Telephone = this.txtTelphone.Text;
            tr.Mobile = this.txtMobel.Text;
            tr.Email = this.txtEmail.Text;
            tr.ContactAddress = this.txtAddress.Text;
            tr.Txtwork = txtwork.SelectedValue;
            tr.MaritalStatus = Radhunyin.SelectedValue;
            tr.Sex = DrpSex.SelectedValue;
            tr.HighestEducation = txteducation.SelectedValue;
            tr.ComputerRequest = dropcomputer.SelectedValue;
            tr.EnglishRequest = dropEnlish.SelectedValue;
            tr.TalentType = DrpTypePosition.SelectedValue;
            tr.WantSalary = dropsalary.SelectedValue;
            int count = re.Update(tr);//修改简历
            this.divMessage.Visible = true;
            if (count > 0)
            {
                this.divMessage.InnerHtml = "修改成功";
            }
            else
            {
                this.divMessage.InnerHtml = "修改失败";
            }
            Bind();
        }
        catch (Exception error)
        {
            this.divMessage.InnerHtml = "系统繁忙，请稍后再试！";
        }

    }
}
