﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;
using Base;
public partial class login_Lonin : Base.BasePage
{
    private string ViewStateUrl = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            Response.Redirect("~/Member/Index.aspx");
        }
        if (Request.QueryString["done"] != null && Request.QueryString["done"] != "")
        {
            this.ViewStateUrl = Request.Url.ToString().Substring(Request.Url.ToString().IndexOf('?') + 1);
            ViewStateUrl = ViewStateUrl.Substring(ViewStateUrl.IndexOf('=') + 1);
        }
        if (Request.Form["done"] != null && Request.Form["done"] != "")
        {
            ViewStateUrl = Request.Form["done"];
        }
        if (Request.Form["UserName"] != "" && Request.Form["UserName"] != null && Request.Form["Password"] != "" && Request.Form["Password"] != null)
        {
            string UserName = Request.Form["UserName"];
            string Password = Request.Form["Password"];
            UserLogin(UserName, Password);
        }
        if (!IsPostBack)
        {

            Solely.UserRegistr set = Solely.UserRegistr.GateItem();
            this.ViewState["isCode"] = set.Code_Login.ToString();
            if (set.Code_Login.ToString().ToLower() == "true")
            {
                this.trCode.Visible = true;
            }
            else
            {
                this.trCode.Visible = false;
            }
            if (Request.QueryString["err"] != null && Request.QueryString["err"].Equals("1"))
            {
                this.divError.Visible = true;
                this.divError.InnerText = "用户名和密码错误！";
                this.txtCode.Text = "";
            }
			this.bt.Text = Common.GetBottom(bt.Text);
            this.dl.Text = Base.Common.GetBottom(this.dl.Text);
        }
    }

    public void UserLogin(string UserName, string Password)
    {
        RUserInfo User = new RUserInfo();
        string Md5Pawd = Common.Encryption(Password);
        DataSet tableset = User.GetDataTable(UserName, Md5Pawd);
        //判断是否存在该会员
        if (tableset.Tables[0].Rows.Count != 0)
        {
           
            if (tableset.Tables[0].Rows[0]["Verify"].ToString().Equals("False"))   //
            {
                Response.Redirect("../Error.aspx?err=3");
            }

            else
            {
                string strIP = Base.GetRequest.GetIP();
                int UserID = int.Parse(tableset.Tables[0].Rows[0]["UserID"].ToString());
                GetRequest.SetCookie("LoginName", tableset.Tables[0].Rows[0]["LoginName"].ToString());
                GetRequest.SetCookie("CheckInfo", tableset.Tables[0].Rows[0]["Password"].ToString());
                GetRequest.SetCookie("UserID", tableset.Tables[0].Rows[0]["UserID"].ToString());
                GetRequest.SetCookie("GradeID", tableset.Tables[0].Rows[0]["GradeID"].ToString());
                GetRequest.SetCookie("CompanyName", tableset.Tables[0].Rows[0]["CompanyName"].ToString());
                if (ViewStateUrl != "")
                {
                    Response.Redirect(ViewStateUrl);
                }
            }
        }
        else
        {
            //Response.Write("<script> window.open(\"login.aspx?err=1\",\"_blank\") </script>  ");
            this.divError.Visible = true;
            this.divError.InnerText = "用户名和密码错误！";
            this.txtCode.Text = "";
            return;
        }
    }

    protected void btnServer_Click(object sender, EventArgs e)
    {

        if (this.ViewState["isCode"].ToString() == "True")
        {
            string code = this.txtCode.Text.ToString();
            if (GetCookie("CheckCode").ToLower() != code.ToLower())
            //if (!CheckCode(code))   //验证码检测
            {
                this.divError.Visible = true;
                this.divError.InnerHtml = "<span style=\" color:red\"> 验证码不正确！</span>";
                this.txtCode.Text = "";
                return;
            }
        }

        string LoginName = Base.GetRequest.Filter(this.txtLoginName.Text.ToString().Trim().Replace("'", ""));
        LoginName = Base.GetRequest.WipeScript(LoginName);
        string Password =Base.GetRequest.Filter(this.txtPassword.Text.ToString().Trim().Replace("'",""));
        Password = Base.GetRequest.Filter(Password);
        if (LoginName != null && Password != null)
        {
            RUserInfo User = new RUserInfo();
            string Md5Pawd = Common.Encryption(Password);
            DataSet tableset = User.GetDataTable(LoginName, Md5Pawd);
            //判断是否存在该会员
            if (tableset.Tables[0].Rows.Count != 0)
            {
                TimeSpan time = new TimeSpan(Convert.ToDateTime(DateTime.Now.ToShortDateString()).Ticks - Convert.ToDateTime(tableset.Tables[0].Rows[0]["EndDate"].ToString()).Ticks);
                if (tableset.Tables[0].Rows[0]["Verify"].ToString().Equals("False"))   //
                {
                    Response.Redirect("../Error.aspx?err=3");
                }
                if (time.TotalDays>0)
                {
                    Response.Redirect("../Error.aspx?err=4");
                }
                else
                {
                    string strIP = Base.GetRequest.GetIP();
                    int UserID = int.Parse(tableset.Tables[0].Rows[0]["UserID"].ToString());
                    if (tableset.Tables[0].Rows[0]["Verify"].ToString() != "" && tableset.Tables[0].Rows[0]["Verify"].ToString() != null)
                    {
                        bool verify = Convert.ToBoolean(tableset.Tables[0].Rows[0]["Verify"].ToString());
                        if (verify == false)
                        {
                            this.divError.InnerText = "您的信息还没有审核，请联系网站管理员！";
                            return;
                        }
                        else
                        {
                            GetRequest.SetCookie("LoginName", tableset.Tables[0].Rows[0]["LoginName"].ToString());
                            GetRequest.SetCookie("CheckInfo", tableset.Tables[0].Rows[0]["Password"].ToString());
                            GetRequest.SetCookie("UserID", tableset.Tables[0].Rows[0]["UserID"].ToString());
                            GetRequest.SetCookie("GradeID", tableset.Tables[0].Rows[0]["GradeID"].ToString());
                            GetRequest.SetCookie("CompanyName", tableset.Tables[0].Rows[0]["CompanyName"].ToString());
                        }
                    }

                    if (ViewStateUrl != "")
                    {
                        Response.Redirect(ViewStateUrl);
                    }
                    else
                        this.Response.Redirect("~/member/Index.aspx");
                }
            }
            else
            {
                this.divError.Visible = true;
                this.divError.InnerText = "用户名和密码错误！";
                this.txtCode.Text = "";
            }
           // userHostAddress = HttpContext.Current.Request.UserHostAddress;
          // userHostAddress = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];

        }
    }

}