/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.controllers;

import com.agilemind.commons.application.controllers.bw;
import com.agilemind.commons.application.modules.dynatags.Tag;
import com.agilemind.commons.application.modules.dynatags.TagException;
import com.agilemind.commons.application.modules.dynatags.TagPosition;
import com.agilemind.commons.application.views.MessageDialogProvider;
import com.agilemind.commons.application.views.dynatags.CodePanelView;
import com.agilemind.commons.mvc.controllers.PanelController;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class CodePanelControllerWithTag
extends PanelController {
    protected CodePanelView panelView;

    public void insertTag(Tag tag) {
        JTextComponent jTextComponent = this.panelView.getCodeTextArea();
        int n2 = jTextComponent.getCaretPosition();
        try {
            jTextComponent.getDocument().insertString(n2, tag.getRepresentation(), null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        jTextComponent.setCaretPosition(n2 + tag.getStartRepresentation().length());
        this.requestFocus();
    }

    public abstract void requestFocus();

    public void handleTagException(TagException tagException) {
        TagPosition tagPosition = tagException.getTagPosition();
        if (tagPosition != null) {
            int n2 = tagPosition.getStartPosition();
            int n3 = tagPosition.getEndPosition();
            if (n2 != 0 || n3 != 0) {
                this.panelView.getCodeTextArea().select(n2, n3);
            }
        }
        MessageDialogProvider.showHandleExpectedExceptionDialog(this, new bw(this, tagException), tagException);
    }
}

