/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.controllers.viewsets;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.controllers.viewsets.TableColumnsPanelController;
import com.agilemind.commons.application.data.FilterParam;
import com.agilemind.commons.application.data.operations.Operation;
import com.agilemind.commons.application.data.operations.Operations;
import com.agilemind.commons.application.data.operations.OperationsFactory;
import com.agilemind.commons.application.data.operations.operation.gui.ValueFieldEditComponent;
import com.agilemind.commons.application.data.providers.FilterProvider;
import com.agilemind.commons.application.views.viewsets.filter.FilterPanel;
import com.agilemind.commons.application.views.viewsets.filter.FilterPanelView;
import com.agilemind.commons.data.field.types.ElementalType;
import com.agilemind.commons.data.table.api.ICompositeFilter;
import com.agilemind.commons.data.table.api.IFilter;
import com.agilemind.commons.data.table.api.LogicalOperation;
import com.agilemind.commons.data.util.StringUtil;
import com.agilemind.commons.gui.locale.LocalizedPanel;
import com.agilemind.commons.mvc.controllers.PanelController;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilterPanelController
extends PanelController {
    private static final Logger o;
    protected FilterPanelView panelView;
    private static final String p;

    @Override
    protected LocalizedPanel createView() {
        this.panelView = this.getFilterPanelView();
        this.panelView.getAddFilterButton().addActionListener(actionEvent -> {
            FilterPanel filterPanel = this.panelView.addFilter();
            this.a(filterPanel, null);
        });
        this.panelView.getClearAll().addActionListener(actionEvent -> {
            this.panelView.clearFilterPanel();
            this.panelView.revalidate();
        });
        return this.panelView;
    }

    @NotNull
    protected FilterPanelView getFilterPanelView() {
        return new FilterPanelView();
    }

    @Override
    protected void initController() {
    }

    @Override
    protected void refreshData() throws Exception {
        int n2 = TableColumnsPanelController.t;
        this.panelView.clearFilterPanel();
        FilterProvider filterProvider = this.getNotNullProvider(FilterProvider.class);
        ICompositeFilter iCompositeFilter = filterProvider.getFilter();
        if (iCompositeFilter == null) {
            return;
        }
        List list = iCompositeFilter.getFiltersList();
        for (IFilter iFilter : list) {
            FilterPanel filterPanel = this.panelView.addFilter();
            this.a(filterPanel, iFilter);
            if (n2 == 0) continue;
        }
        this.panelView.getOperationsComboBox().setModel(new DefaultComboBoxModel<LogicalOperation>(LogicalOperation.values()));
        this.panelView.getOperationsComboBox().setSelectedItem(iCompositeFilter.getOperation());
        this.panelView.revalidate();
    }

    private void a(FilterPanel filterPanel, @Nullable IFilter iFilter) {
        filterPanel.getFieldComboBox().addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.a(itemEvent, filterPanel);
            }
        });
        filterPanel.getOperationComboBox().addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                AbstractFilterPanelController.b(itemEvent, filterPanel);
            }
        });
        ElementalType<?> elementalType = this.b(filterPanel, iFilter);
        Operation operation = this.a(filterPanel, iFilter, elementalType);
        ValueFieldEditComponent valueFieldEditComponent = operation.getEditComponent();
        AbstractFilterPanelController.a(valueFieldEditComponent, iFilter);
        filterPanel.setEditorComponent(valueFieldEditComponent);
        FilterParam filterParam = (FilterParam)filterPanel.getFieldComboBox().getSelectedItem();
        JComboBox jComboBox = filterPanel.getFieldComboBox();
        String string = filterParam != null ? filterParam.getName() : null;
        jComboBox.setToolTipText(string);
    }

    private void a(ItemEvent itemEvent, FilterPanel filterPanel) {
        FilterParam filterParam = (FilterParam)itemEvent.getItem();
        filterPanel.getFieldComboBox().setToolTipText(filterParam.getName());
        ElementalType elementalType = filterParam.getElementalType();
        OperationsFactory operationsFactory = this.l();
        Operations operations = operationsFactory.getOperations(elementalType);
        List list = operations.getAvailableOperations();
        filterPanel.getOperationComboBox().setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        Operation operation = list.get(0);
        filterPanel.getOperationComboBox().setSelectedItem(operation);
        filterPanel.setEditorComponent(operation.getEditComponent());
    }

    private static void b(ItemEvent itemEvent, FilterPanel filterPanel) {
        Operation operation = (Operation)itemEvent.getItem();
        filterPanel.setEditorComponent(operation.getEditComponent());
    }

    private Operation a(FilterPanel filterPanel, IFilter iFilter, ElementalType<?> elementalType) {
        Operation operation2;
        block5: {
            List<Operation<?>> list;
            block4: {
                OperationsFactory operationsFactory = this.l();
                Operations<?> operations = operationsFactory.getOperations(elementalType);
                list = operations.getAvailableOperations();
                filterPanel.getOperationComboBox().setModel(new DefaultComboBoxModel<Object>(list.toArray()));
                if (iFilter == null || iFilter.getOperationIdentifier() == null) break block4;
                operation2 = list.stream().filter(operation -> operation.getIdentifier().equals(iFilter.getOperationIdentifier())).findFirst().orElseThrow(() -> new IllegalStateException(p + elementalType.getDescription()));
                if (TableColumnsPanelController.t == 0) break block5;
            }
            operation2 = list.get(0);
        }
        filterPanel.getOperationComboBox().setSelectedItem(operation2);
        return operation2;
    }

    private OperationsFactory l() {
        ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.getApplicationController();
        return applicationControllerImpl.getOperationsFactory();
    }

    protected abstract List<? extends FilterParam> getFilterParams();

    private ElementalType<?> b(FilterPanel filterPanel, IFilter iFilter) {
        List<? extends FilterParam> list = this.getFilterParams();
        filterPanel.getFieldComboBox().setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        FilterParam filterParam = AbstractFilterPanelController.a(list, iFilter);
        if (filterParam == null) {
            filterParam = list.get(0);
        }
        filterPanel.getFieldComboBox().setSelectedItem(filterParam);
        return filterParam.getElementalType();
    }

    private static FilterParam<?> a(List<? extends FilterParam> list, IFilter iFilter) {
        int n2 = TableColumnsPanelController.t;
        if (iFilter == null) {
            return null;
        }
        String string = iFilter.getColumnIdentifier();
        for (FilterParam filterParam : list) {
            if (filterParam.getStringRepresentation().equals(string)) {
                return filterParam;
            }
            if (n2 == 0) continue;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(ValueFieldEditComponent valueFieldEditComponent, IFilter iFilter) {
        try {
            if (iFilter == null) return;
            if (iFilter.getStringEtalonValue() == null) return;
            valueFieldEditComponent.setData(iFilter.getStringEtalonValue());
            return;
        }
        catch (IOException iOException) {
            o.error("", (Throwable)iOException);
        }
    }

    @Override
    protected void collectData() {
        Object object;
        int n2 = TableColumnsPanelController.t;
        FilterProvider filterProvider = this.getNotNullProvider(FilterProvider.class);
        ICompositeFilter iCompositeFilter = filterProvider.getFilter();
        List list = iCompositeFilter.getFiltersList();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            object = (IFilter)list.get(i2);
            iCompositeFilter.removeFilter((IFilter)object);
            if (n2 == 0) continue;
        }
        List<FilterPanel> list2 = this.panelView.getFilterPanels();
        for (FilterPanel filterPanel : list2) {
            String string = null;
            try {
                string = filterPanel.getEditComponent().getData();
            }
            catch (IOException iOException) {
                o.error("", (Throwable)iOException);
            }
            if (StringUtil.isEmpty((String)string) && n2 == 0) continue;
            IFilter iFilter = iCompositeFilter.createFilter();
            iFilter.setStringEtalonValue(string);
            FilterParam filterParam = (FilterParam)filterPanel.getFieldComboBox().getSelectedItem();
            iFilter.setColumnIdentifier(filterParam.getStringRepresentation());
            Operation operation = (Operation)filterPanel.getOperationComboBox().getSelectedItem();
            iFilter.setOperationIdentifier(operation.getIdentifier());
            iCompositeFilter.addFilter(iFilter);
            if (n2 == 0) continue;
        }
        object = (LogicalOperation)this.panelView.getOperationsComboBox().getSelectedItem();
        iCompositeFilter.setOperation((LogicalOperation)object);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = ")[Z&H\u001e\u001aR!I\u000e\u001a[8B\u0018[@!H\u0004\u001aR'UJNM8BJ".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 106;
                            break;
                        }
                        case 1: {
                            n7 = 58;
                            break;
                        }
                        case 2: {
                            n7 = 52;
                            break;
                        }
                        case 3: {
                            n7 = 72;
                            break;
                        }
                        default: {
                            n7 = 39;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        p = new String(cArray).intern();
        o = LoggerFactory.getLogger(AbstractFilterPanelController.class);
    }
}

