/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.gui.ctable.renderer;

import com.agilemind.commons.application.gui.ctable.renderer.ColumnHeaderTooltipTableCellRenderer;
import com.agilemind.commons.gui.ctable.DisabledTableCellRenderer;
import com.agilemind.commons.localization.util.LocalizedStringUtil;
import com.agilemind.commons.util.FormatUtil;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class SimpleDecimalTableCellRenderer
extends DefaultTableCellRenderer
implements DisabledTableCellRenderer {
    private final DecimalFormat a;

    public static DefaultTableCellRenderer createBigInteger() {
        return new SimpleDecimalTableCellRenderer(FormatUtil.NUMBER_BIG_INT_FORMAT_US);
    }

    public SimpleDecimalTableCellRenderer(DecimalFormat decimalFormat) {
        this.a = decimalFormat;
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
        String string;
        block4: {
            Number number;
            block2: {
                boolean bl4;
                block3: {
                    bl4 = ColumnHeaderTooltipTableCellRenderer.d;
                    number = (Number)object;
                    if (!this.isChecked(number)) break block2;
                    if (!this.isNA(number)) break block3;
                    string = this.formatNA(number);
                    this.setEnabled(false);
                    if (!bl4) break block4;
                }
                string = this.format(number);
                this.setEnabled(true);
                if (!bl4) break block4;
            }
            string = this.formatNotYetChecked(number);
            this.setEnabled(false);
        }
        return super.getTableCellRendererComponent(jTable, string, bl2, bl3, n2, n3);
    }

    protected String formatNotYetChecked(Number number) {
        return LocalizedStringUtil.NOT_YET_CHECKED.getString();
    }

    protected boolean isNA(Number number) {
        return number.longValue() < 0L;
    }

    protected String formatNA(Number number) {
        if (number.intValue() == -1) {
            return LocalizedStringUtil.NOT_DATA_STR.getString();
        }
        if (number.intValue() == -2) {
            return LocalizedStringUtil.NA_STRING.getString();
        }
        return String.valueOf(number);
    }

    protected boolean isChecked(Number number) {
        return number != null;
    }

    @NotNull
    protected String format(Object object) {
        return this.a.format(object);
    }

    public boolean isEnabled(Object object) {
        return this.isEnabled();
    }
}

