/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.gui.editableheader;

import com.agilemind.commons.application.gui.editableheader.EditableHeaderUI;
import com.agilemind.commons.application.gui.editableheader.MouseInfoColumn;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public abstract class EditableHeader
extends JTableHeader
implements MouseInfoColumn {
    public static final int HEADER_ROW = -10;
    protected transient Component editorComp;
    protected transient int editingColumn;
    protected transient TableCellEditor cellEditor;
    private int a = -1;
    public static boolean b;

    public EditableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    @Override
    public void updateUI() {
        this.setUI(new EditableHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }

    public boolean editCellAt(int n2, EventObject eventObject) {
        this.a = n2;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (this.getReorderingAllowed()) {
            return false;
        }
        TableCellEditor tableCellEditor = this.getCellEditor(n2);
        if (tableCellEditor != null && tableCellEditor.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor(tableCellEditor, n2);
            this.editorComp.setBounds(this.getHeaderRect(n2));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.cellEditor = tableCellEditor;
            this.setEditingColumn(n2);
            return true;
        }
        return false;
    }

    @Override
    public int getMouseColumn() {
        return this.a;
    }

    @Override
    public void setMouseColumn(int n2) {
        this.a = n2;
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n2) {
        Object object = this.columnModel.getColumn(n2).getHeaderValue();
        int n3 = -10;
        JTable jTable = this.getTable();
        Component component = tableCellEditor.getTableCellEditorComponent(jTable, object, true, n3, n2);
        if (component instanceof JComponent) {
            ((JComponent)component).setNextFocusableComponent(this);
        }
        return component;
    }

    public abstract TableCellEditor getCellEditor(int var1);

    public void setEditingColumn(int n2) {
        this.editingColumn = n2;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void removeEditor() {
        if (this.cellEditor != null) {
            this.requestFocus();
            this.remove(this.editorComp);
            int n2 = this.getEditingColumn();
            Rectangle rectangle = this.getHeaderRect(n2);
            this.cellEditor = null;
            this.setEditingColumn(-1);
            this.editorComp = null;
            this.repaint(rectangle);
        }
    }

    public void editingStopped() {
        if (this.cellEditor != null) {
            this.removeEditor();
        }
    }

    public void editingCanceled() {
        this.removeEditor();
    }
}

