/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage;

import com.agilemind.commons.application.modules.audit.page.onpage.OnPageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.OnPageAuditFactoryType;
import com.agilemind.commons.application.modules.audit.page.onpage.OnePageStatisticsProvider;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.DuplicateMetaDescTagAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.DuplicateTitleTagAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.EmptyAltTextAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInAltTextAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInBodyAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInBoldAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInH1AuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInH2H6AuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInItalicAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInLinkAnchorsAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInMetaDescriptionAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInMetaKwsAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInTitleAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.MetaDescLengthAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.OpenGraphAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.StructuredDataMarkupAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.TitleLengthAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.WordCountInBodyAuditFactor;
import com.agilemind.commons.mvc.controllers.Controller;

public class OnPageAuditFactorFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OnPageAuditFactor createPageAuditFactor(OnPageAuditFactoryType onPageAuditFactoryType, OnePageStatisticsProvider onePageStatisticsProvider) {
        boolean bl2 = OnPageAuditFactoryType.b;
        switch (onPageAuditFactoryType) {
            case KEYWORDS_IN_TITLE: {
                return new KeywordsInTitleAuditFactor(onePageStatisticsProvider);
            }
            case TITLE_LENGTH: {
                return new TitleLengthAuditFactor();
            }
            case DUPLICATE_TITLE_TAG: {
                return new DuplicateTitleTagAuditFactor();
            }
            case KEYWORDS_IN_META_DESCRIPTION: {
                return new KeywordsInMetaDescriptionAuditFactor(onePageStatisticsProvider);
            }
            case META_DESCRIPTION_LENGTH: {
                return new MetaDescLengthAuditFactor();
            }
            case DUPLICATE_META_DESCRIPTION_TAG: {
                return new DuplicateMetaDescTagAuditFactor();
            }
            case KEYWORDS_IN_META_KWS: {
                return new KeywordsInMetaKwsAuditFactor(onePageStatisticsProvider);
            }
            case KEYWORDS_IN_BODY: {
                return new KeywordsInBodyAuditFactor(onePageStatisticsProvider);
            }
            case WORD_COUNT_IN_BODY: {
                return new WordCountInBodyAuditFactor();
            }
            case KEYWORDS_IN_H1: {
                return new KeywordsInH1AuditFactor(onePageStatisticsProvider);
            }
            case KEYWORDS_IN_H2H6: {
                return new KeywordsInH2H6AuditFactor(onePageStatisticsProvider);
            }
            case KEYWORDS_IN_BOLD: {
                return new KeywordsInBoldAuditFactor(onePageStatisticsProvider);
            }
            case KEYWORDS_IN_ITALIC: {
                return new KeywordsInItalicAuditFactor(onePageStatisticsProvider);
            }
            case KEYWORDS_IN_LINK_ANCHORS: {
                return new KeywordsInLinkAnchorsAuditFactor(onePageStatisticsProvider);
            }
            case KEYWORDS_IN_ALT_TEXT: {
                return new KeywordsInAltTextAuditFactor(onePageStatisticsProvider);
            }
            case EMPTY_ALT_TEXT: {
                return new EmptyAltTextAuditFactor();
            }
            case OPEN_GRAPH: {
                return new OpenGraphAuditFactor();
            }
            case STRUCTURED_DATA_MARKUP_TEC: {
                StructuredDataMarkupAuditFactor structuredDataMarkupAuditFactor = new StructuredDataMarkupAuditFactor();
                if (bl2) {
                    Controller.g = !Controller.g;
                }
                return structuredDataMarkupAuditFactor;
            }
        }
        throw new IllegalArgumentException(onPageAuditFactoryType.name());
    }
}

