/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.onpage.OnPageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.result.YesNoPageAuditResult;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import java.util.List;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateTitleTagAuditFactor
implements OnPageAuditFactor {
    private static final Logger a = LoggerFactory.getLogger(DuplicateTitleTagAuditFactor.class);

    @Override
    public PageAuditResult getResult(IAuditPage iAuditPage, List<? extends IAuditKeyword> list) throws Exception {
        if (iAuditPage.getContent() == null) {
            return new YesNoPageAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        if (StringUtil.isEmpty((String)iAuditPage.getContent())) {
            return new YesNoPageAuditResult(AuditStatusType.N_A);
        }
        try {
            HTMLElementInfo hTMLElementInfo = iAuditPage.getPageData().getHTMLElementInfo(HTMLTag.TITLE);
            int n2 = hTMLElementInfo.getTagsCount();
            AuditStatusType auditStatusType = n2 > 1 ? AuditStatusType.ERROR : AuditStatusType.OK;
            AuditStatusType auditStatusType2 = auditStatusType;
            return new YesNoPageAuditResult(auditStatusType2, AuditStatusType.ERROR);
        }
        catch (ParserException parserException) {
            a.error("", (Throwable)parserException);
            return new YesNoPageAuditResult(AuditStatusType.N_A);
        }
    }
}

