/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.PageOptimizationUtil;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.onpage.OnPageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.OnePageStatisticsProvider;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInTagAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.result.ImportantKeywordsAdvice;
import com.agilemind.commons.application.modules.audit.page.onpage.result.KeywordsInBodyAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.OnePageExtTagStatistics;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import java.util.HashSet;
import java.util.List;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordsInBodyAuditFactor
implements OnPageAuditFactor {
    private static final Logger a = LoggerFactory.getLogger(KeywordsInBodyAuditFactor.class);
    private final OnePageStatisticsProvider b;

    public KeywordsInBodyAuditFactor(OnePageStatisticsProvider onePageStatisticsProvider) {
        this.b = onePageStatisticsProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IAuditPage iAuditPage, List<? extends IAuditKeyword> list) throws Exception {
        int n2 = KeywordsInTagAuditFactor.d;
        if (iAuditPage.getContent() == null) {
            return new KeywordsInBodyAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        if (StringUtil.isEmpty((String)iAuditPage.getContent())) {
            return new KeywordsInBodyAuditResult(AuditStatusType.N_A);
        }
        int n3 = 0;
        int n4 = 0;
        ImportantKeywordsAdvice importantKeywordsAdvice = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        try {
            AuditStatusType auditStatusType;
            HTMLElementInfo hTMLElementInfo = iAuditPage.getPageData().getHTMLElementInfo(HTMLTag.BODY);
            for (IAuditKeyword iAuditKeyword : list) {
                block23: {
                    block22: {
                        int n5 = hTMLElementInfo.getKeywordCount(iAuditKeyword.getKeyword());
                        if (n5 == 0) {
                            hashSet3.add(iAuditKeyword.getKeyword());
                        }
                        n3 += n5;
                        n4 += hTMLElementInfo.getWordsCount();
                        if (!PageOptimizationUtil.isNoFullyOptimizedKeyword(iAuditKeyword, iAuditPage, HTMLTag.BODY)) break block22;
                        hashSet.add(iAuditKeyword.getKeyword());
                        if (n2 == 0) break block23;
                    }
                    if (PageOptimizationUtil.isReOptimizedKeyword(iAuditKeyword, iAuditPage, HTMLTag.BODY)) {
                        hashSet2.add(iAuditKeyword.getKeyword());
                    }
                }
                if (n2 == 0) continue;
            }
            boolean bl2 = hashSet.size() == list.size();
            OnePageExtTagStatistics onePageExtTagStatistics = (OnePageExtTagStatistics)this.b.getStatistics(iAuditPage, list, HTMLTag.BODY);
            if (n3 == 0) {
                importantKeywordsAdvice = KeywordsInTagAuditFactor.a(onePageExtTagStatistics, list, HTMLTag.BODY, false);
                auditStatusType = AuditStatusType.ERROR;
                return new KeywordsInBodyAuditResult(auditStatusType, importantKeywordsAdvice, hashSet2, hashSet, hashSet3, bl2, n3, n4);
            }
            if (bl2 || !hashSet2.isEmpty() || !hashSet3.isEmpty()) {
                importantKeywordsAdvice = KeywordsInTagAuditFactor.a(onePageExtTagStatistics, list, HTMLTag.BODY, false);
                auditStatusType = AuditStatusType.WARNING;
                return new KeywordsInBodyAuditResult(auditStatusType, importantKeywordsAdvice, hashSet2, hashSet, hashSet3, bl2, n3, n4);
            }
            if (!hashSet.isEmpty()) {
                auditStatusType = AuditStatusType.INFO;
                if (n2 == 0) return new KeywordsInBodyAuditResult(auditStatusType, importantKeywordsAdvice, hashSet2, hashSet, hashSet3, bl2, n3, n4);
            }
            auditStatusType = AuditStatusType.OK;
            return new KeywordsInBodyAuditResult(auditStatusType, importantKeywordsAdvice, hashSet2, hashSet, hashSet3, bl2, n3, n4);
        }
        catch (ParserException parserException) {
            a.error("", (Throwable)parserException);
            return new KeywordsInBodyAuditResult(AuditStatusType.N_A);
        }
    }
}

