/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.onpage.OnPageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.result.LengthAuditResult;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import java.util.List;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDescLengthAuditFactor
implements OnPageAuditFactor {
    private static final Logger a = LoggerFactory.getLogger(MetaDescLengthAuditFactor.class);
    public static final int META_LENGTH = 160;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IAuditPage iAuditPage, List<? extends IAuditKeyword> list) throws Exception {
        if (iAuditPage.getContent() == null) {
            return new LengthAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        if (StringUtil.isEmpty((String)iAuditPage.getContent())) {
            return new LengthAuditResult(AuditStatusType.N_A);
        }
        try {
            HTMLElementInfo.Simple simple = (HTMLElementInfo.Simple)iAuditPage.getPageData().getHTMLElementInfo(HTMLTag.META_DESCRIPTION);
            int n2 = simple.getTagText().length();
            AuditStatusType auditStatusType = n2 == 0 || n2 > 160 ? AuditStatusType.WARNING : AuditStatusType.OK;
            return new LengthAuditResult(auditStatusType, n2);
        }
        catch (ParserException parserException) {
            a.error("", (Throwable)parserException);
            return new LengthAuditResult(AuditStatusType.N_A);
        }
    }
}

