/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage.factor;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.onpage.OnPageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.factor.KeywordsInTagAuditFactor;
import com.agilemind.commons.application.modules.audit.page.onpage.result.LengthAuditResult;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import java.util.List;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleLengthAuditFactor
implements OnPageAuditFactor {
    private static final Logger a = LoggerFactory.getLogger(TitleLengthAuditFactor.class);
    public static final int TITLE_LENGTH = 70;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IAuditPage iAuditPage, List<? extends IAuditKeyword> list) throws Exception {
        int n2 = KeywordsInTagAuditFactor.d;
        if (iAuditPage.getContent() == null) {
            return new LengthAuditResult(AuditStatusType.NOT_YET_CHECKED);
        }
        if (StringUtil.isEmpty((String)iAuditPage.getContent())) {
            return new LengthAuditResult(AuditStatusType.N_A);
        }
        try {
            AuditStatusType auditStatusType;
            int n3;
            block11: {
                block12: {
                    block10: {
                        HTMLElementInfo.Simple simple = (HTMLElementInfo.Simple)iAuditPage.getPageData().getHTMLElementInfo(HTMLTag.TITLE);
                        n3 = simple.getTagText().length();
                        if (n3 != 0) break block10;
                        auditStatusType = AuditStatusType.ERROR;
                        if (n2 == 0) break block11;
                    }
                    if (n3 <= 70) break block12;
                    auditStatusType = AuditStatusType.WARNING;
                    if (n2 == 0) break block11;
                }
                auditStatusType = AuditStatusType.OK;
            }
            return new LengthAuditResult(auditStatusType, n3);
        }
        catch (ParserException parserException) {
            a.error("", (Throwable)parserException);
            return new LengthAuditResult(AuditStatusType.N_A);
        }
    }
}

