/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage.statistics;

import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.KeywordInTagStatistic;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.OnePageExtTagStatistics;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.OnePageTagStatistics;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.htmlparser.data.HTMLTag;
import com.agilemind.htmlparser.tfidf.TfIdfUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import org.htmlparser.util.ParserException;
import org.jetbrains.annotations.NotNull;

public class OnePageBodyStatistics
extends OnePageExtTagStatistics {
    private int g;

    public OnePageBodyStatistics(int n2, Iterable<? extends IAuditKeyword> iterable) throws ParserException, InterruptedException {
        super(HTMLTag.BODY, iterable);
        this.g = n2;
    }

    @Override
    protected int calcTargetWordCountImpl() {
        int n2 = OnePageTagStatistics.c;
        Collection collection = this.getAllStatistics().stream().filter(keywordInTagStatistic -> keywordInTagStatistic.getDocWithKeywordCount() > 0).collect(Collectors.toList());
        int n3 = collection.stream().mapToInt(KeywordInTagStatistic::getMinWordCountInDoc).min().orElse(0);
        int n4 = collection.stream().mapToInt(KeywordInTagStatistic::getMaxWordCountInDoc).max().orElse(0);
        if (n3 <= this.g && this.g <= n4) {
            return this.g;
        }
        int n5 = collection.stream().mapToInt(KeywordInTagStatistic::getAvgWordCountWithKeyword).min().orElse(0);
        if (Controller.g) {
            OnePageTagStatistics.c = ++n2;
        }
        return n5;
    }

    public final int getMinRecommendedKeywordCount(@NotNull String string) {
        KeywordInTagStatistic keywordInTagStatistic = this.getStatistics(string);
        if (keywordInTagStatistic.getDocWithKeywordCount() <= 5) {
            return 1;
        }
        try {
            double d2 = OnePageBodyStatistics.calcKeywordCount(this.c(), keywordInTagStatistic.getMinTfIdf(), keywordInTagStatistic.getDocumentsCount(), keywordInTagStatistic.getDocWithKeywordCount());
            return Math.min((int)Math.floor(d2), this.getRecommendedKeywordCount(string));
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
            return -2;
        }
    }

    @Override
    boolean c(String string) {
        KeywordInTagStatistic keywordInTagStatistic = this.getStatistics(string);
        double d2 = this.a(string, keywordInTagStatistic.getIdf());
        return d2 > TfIdfUtil.round((double)keywordInTagStatistic.getMaxTfIdf()) && this.getRecommendedKeywordCount(string) != 1 || d2 < TfIdfUtil.round((double)keywordInTagStatistic.getMinTfIdf());
    }
}

