/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage.statistics;

import com.agilemind.commons.application.modules.audit.page.onpage.IAuditKeyword;
import com.agilemind.commons.application.modules.audit.page.onpage.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.onpage.OnePageStatisticsProvider;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.OnePageBodyStatistics;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.OnePageTagStatistics;
import com.agilemind.commons.application.modules.audit.page.onpage.statistics.OnePageTitleDescStatistics;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.PageInfo;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.htmlparser.util.ParserException;

public class OnePageKeywordStatisticContext
implements OnePageStatisticsProvider {
    private Map<HTMLTag, OnePageTagStatistics> a = new EnumMap<HTMLTag, OnePageTagStatistics>(HTMLTag.class);

    @Override
    public synchronized OnePageTagStatistics getStatistics(IAuditPage iAuditPage, List<? extends IAuditKeyword> list, HTMLTag hTMLTag) throws InterruptedException, ParserException {
        return this.a(iAuditPage, hTMLTag, list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OnePageTagStatistics a(IAuditPage iAuditPage, HTMLTag hTMLTag, List<? extends IAuditKeyword> list) throws InterruptedException, ParserException {
        int n2 = OnePageTagStatistics.c;
        OnePageTagStatistics onePageTagStatistics = this.a.get(hTMLTag);
        if (onePageTagStatistics == null) {
            switch (hTMLTag) {
                case BODY: {
                    Integer n3 = OnePageKeywordStatisticContext.a(iAuditPage);
                    onePageTagStatistics = new OnePageBodyStatistics(n3 != null ? n3 : 0, list);
                    if (n2 == 0) break;
                }
                case TITLE: 
                case META_DESCRIPTION: {
                    onePageTagStatistics = new OnePageTitleDescStatistics(hTMLTag, list);
                    if (n2 == 0) break;
                }
                default: {
                    onePageTagStatistics = new OnePageTagStatistics(hTMLTag, list);
                }
            }
            this.a.put(hTMLTag, onePageTagStatistics);
        }
        return onePageTagStatistics;
    }

    private static Integer a(IAuditPage iAuditPage) throws InterruptedException {
        try {
            HTMLElementInfo hTMLElementInfo = iAuditPage.getPageData().getHTMLElementInfo(HTMLTag.BODY);
            return hTMLElementInfo.getWordsCount();
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
            ISearchEngineFactor iSearchEngineFactor = iAuditPage.getPopularityMap().getFactor(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
            Integer n2 = iSearchEngineFactor != null ? ((PageInfo)iSearchEngineFactor.getFactorValue()).getBodyWordsCount() : null;
            return n2;
        }
    }
}

