/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.autosave;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.controllers.ProjectPanelController;
import com.agilemind.commons.application.controllers.ProjectsTabController;
import com.agilemind.commons.application.data.IProject;
import com.agilemind.commons.application.data.IProjectMetaData;
import com.agilemind.commons.application.data.Project;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.localization.ProjectStringKey;
import com.agilemind.commons.application.modules.autosave.RecoveryFilesMap;
import com.agilemind.commons.application.modules.autosave.SelectRecoveryFilesTable;
import com.agilemind.commons.application.modules.license.LicenseType;
import com.agilemind.commons.application.modules.projectmanager.ProjectId;
import com.agilemind.commons.application.modules.report.controllers.ReportProjectPanelController;
import com.agilemind.commons.application.modules.storage.StorageType;
import com.agilemind.commons.application.taskmanager.data.TypedTask;
import com.agilemind.commons.application.taskmanager.util.ProjectTasksPredicate;
import com.agilemind.commons.application.views.MessageDialogProvider;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.gui.locale.keysets.BundleOptionPaneStringKeySet;
import com.agilemind.commons.gui.locale.keysets.OptionPaneStringKeySet;
import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.localization.stringkey.StringKeyStorage;
import com.agilemind.commons.modules.taskmanager.TaskManager;
import com.agilemind.commons.mvc.util.ApplicationIOUtils;
import com.agilemind.commons.util.DateUtil;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Autosaver {
    public static final String UNSAVED;
    private static final Logger a;
    private ApplicationControllerImpl<? extends Project> b;
    private Date c;
    private RecoveryFilesMap d;
    private int e;
    private Map<IProject, File> f;
    private File g;
    private boolean h;
    private static final String[] j;

    public Autosaver(ApplicationControllerImpl<? extends Project> applicationControllerImpl) {
        this.b = applicationControllerImpl;
        this.c = new Date();
        this.d = new RecoveryFilesMap(null);
        this.f = new HashMap<IProject, File>();
        this.e = 0;
        this.h = false;
        this.j();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        boolean bl2 = SelectRecoveryFilesTable.j;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.b.getLicenseType().isAllowed(LicenseType.SAVE_PROJECT)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.c);
            Date date = this.c;
            calendar.add(12, this.b.getParameters().getAutosaveInterval());
            if (this.a(calendar)) {
                ProjectsTabController<ReportProjectPanelController<?, Project>, Project> projectsTabController = this.b.getProjectsTab();
                for (ProjectPanelController projectPanelController : projectsTabController.getTabs()) {
                    Database database;
                    Object p2 = projectPanelController.getProject();
                    if (this.a((IProject)p2, database = p2.getDatabase())) {
                        File file = database.getFile();
                        File file2 = null;
                        try {
                            file2 = this.a((IProject)p2);
                            a.info(j[1], (Object)p2.getProjectName(), (Object)file2);
                            projectPanelController.saveBackUp(file2);
                            a.info(j[0], (Object)p2.getProjectName());
                            date = new Date();
                        }
                        catch (IOException iOException) {
                            a.error("", (Throwable)iOException);
                            this.a(iOException, file2 != null ? file2 : file);
                        }
                        finally {
                            database.setFile(file);
                        }
                    }
                    if (!bl2) continue;
                }
                this.c = date;
                this.c();
            }
        }
    }

    private boolean a(Calendar calendar) {
        return !this.b.hasModalDialogs() && DateUtil.compareDates((Date)calendar.getTime(), (Date)new Date(), (int)12) <= 0;
    }

    private boolean a(IProject iProject, Database database) {
        return !this.a(iProject.getProjectId()) && database.isModified() && DateUtil.compareDates((Date)this.c, (Date)database.getModificationDate(), (int)14) < 0;
    }

    private boolean a(ProjectId projectId) {
        TaskManager<TypedTask> taskManager = this.b.getTaskManager();
        return taskManager.getSnapshot().getActiveMap().keySet().stream().anyMatch(new ProjectTasksPredicate(projectId));
    }

    private void c() {
        try {
            this.d.getDatabase().save(new File(Autosaver.i(), j[9]), false);
        }
        catch (IOException iOException) {
            a.error(j[11] + iOException.getMessage(), (Throwable)iOException);
            this.a(iOException, new File(Autosaver.i(), j[10]));
        }
    }

    private void a(IOException iOException, File file) {
        if (!this.h) {
            this.h = true;
            MessageDialogProvider.showHandleExpectedExceptionDialog(this.b, (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet(new ProjectStringKey(j[7]).createExtension((StringKeyStorage)new StringKeyStorage.Fixed(j[6], file.toString()))), iOException);
        }
    }

    private File a(IProject iProject) throws IOException {
        File file;
        block5: {
            String string;
            Object object;
            String string2;
            block7: {
                block6: {
                    file = this.f.get(iProject);
                    if (file != null) break block5;
                    Database database = iProject.getDatabase();
                    if (database.getFile() == null) break block6;
                    string2 = Autosaver.b(iProject, database);
                    object = string2.hashCode() + database.getFile().getName() + j[4];
                    file = new File(Autosaver.i(), (String)object);
                    if (!SelectRecoveryFilesTable.j) break block7;
                }
                object = j[3] + this.e++;
                string2 = j[2];
                file = new File(this.g, (String)object);
            }
            this.f.put(iProject, file);
            if (iProject.getMetadata() == null) {
                object = StorageType.LOCAL;
                string = iProject.getProjectName();
            } else {
                object = iProject.getMetadata().getLocation().getStorageType();
                string = iProject.getMetadata().getProjectName();
            }
            this.d.put(file.getCanonicalPath(), new ProjectLocationInfo((StorageType)((Object)object), string2, string));
        }
        return file;
    }

    private static String b(IProject iProject, Database database) throws IOException {
        IProjectMetaData iProjectMetaData;
        block4: {
            iProjectMetaData = iProject.getMetadata();
            if (iProjectMetaData != null && iProjectMetaData.getLocation().getStorageType() != StorageType.LOCAL) break block4;
            return database.getFile().getCanonicalPath();
        }
        return iProjectMetaData.getLocation().getPath();
    }

    private static File i() {
        File file = new File(ApplicationIOUtils.getApplicationDir(), j[13]);
        if (!file.exists() && !file.mkdir()) {
            a.error(j[12] + file.getName() + j[14]);
        }
        return file;
    }

    private void j() {
        File file;
        boolean bl2 = SelectRecoveryFilesTable.j;
        int n2 = 0;
        File file2 = Autosaver.i();
        while ((file = new File(file2, j[8] + n2)).exists()) {
            ++n2;
            if (!bl2) continue;
        }
        file.mkdir();
        this.g = file;
    }

    public static File getInfoFile() {
        return new File(Autosaver.i(), j[5]);
    }

    public void clear() {
        try {
            IOUtils.deleteFolder((File)Autosaver.i());
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[15];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Z\u0011X2FJ\u001b";
        int n3 = 14;
        block23: while (true) {
            char[] cArray;
            block28: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block27: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block27;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block28;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 47;
                                break;
                            }
                            case 1: {
                                n9 = 127;
                                break;
                            }
                            case 2: {
                                n9 = 43;
                                break;
                            }
                            case 3: {
                                n9 = 83;
                                break;
                            }
                            default: {
                                n9 = 48;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 14: {
                    UNSAVED = string.intern();
                    string2 = "|\u001e]6T\u000f\u000fY<ZJ\u001c_sKR";
                    n3 = -1;
                    continue block23;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "|\u001e]6\u0010_\rD9UL\u000b\u000b(M\u000f\u000bDsKR";
                    n3 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Z\u0011X2FJ\u001b";
                    n3 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "Z\u0011X2FJ\u001b";
                    n3 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0001\u001dJ8";
                    n3 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "F\u0011M<\u001eK\u001e_";
                    n3 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "p\u0019B?U";
                    n3 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "J\rY<B\u0001\u000fY<ZJ\u001c_}BJ\u001cD%U]\u0006\u0005 QY\u001a";
                    n3 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "Z\u0011X2FJ\u001b";
                    n3 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "F\u0011M<\u001eK\u001e_";
                    n3 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "F\u0011M<\u001eK\u001e_";
                    n3 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "|\u001e]6\u0010]\u001aH<FJ\rRsVF\u0013NsU]\rD!\u0010";
                    n3 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "l\u0010^?TAX_sRJ_H!UN\u000bN7\u0010";
                    n3 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "]\u001aH<FJ\rR";
                    n3 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\u000f\u001bB!UL\u000bD!I";
                    n3 = 13;
                    continue block23;
                }
                case 13: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        j = stringArray3;
        a = LoggerFactory.getLogger(Autosaver.class);
    }
}

