/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.commands.operations;

import com.agilemind.commons.application.data.IProjectLocation;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.commands.Command;
import com.agilemind.commons.application.modules.commands.execution.CommandExecutor;
import com.agilemind.commons.application.modules.commands.parser.CommandsParser;
import com.agilemind.commons.application.modules.concurrent.util.operations.logger.LogEntry;
import com.agilemind.commons.application.modules.concurrent.util.operations.logger.OperationResultInfoTransient;
import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskState;
import com.agilemind.commons.application.modules.storage.StorageType;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.ProjectClient;
import com.agilemind.commons.application.service.ScheduledTasksService;
import com.agilemind.commons.application.views.MessageDialogProvider;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.gui.locale.keysets.BundleOptionPaneStringKeySet;
import com.agilemind.commons.gui.locale.keysets.OptionPaneStringKeySet;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.localization.IStringKey;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.localization.stringkey.OperationConstants;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.localization.stringkey.StringKeyStorage;
import com.agilemind.commons.modules.concurrent.util.operations.CompositeOperation;
import com.agilemind.commons.modules.concurrent.util.operations.Operation;
import com.agilemind.commons.modules.concurrent.util.operations.OperationState;
import com.agilemind.commons.modules.concurrent.util.operations.SuccesiveCompositeOperation;
import com.agilemind.commons.mvc.controllers.ApplicationController;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.mvc.controllers.WindowControllerProvider;
import com.agilemind.commons.mvc.util.ApplicationIOUtils;
import com.agilemind.commons.util.ThreadSafeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledOperation
extends SuccesiveCompositeOperation {
    private static final Logger a;
    private final IScheduledTaskSettings b;
    private final ProjectLocationInfo c;
    private final SearchEngineManager d;
    private final ScheduledTasksService e;
    private final WindowControllerProvider f;
    private List<CommandExecutor> g;
    public static int i;
    private static final String[] F;

    public ScheduledOperation(ApplicationController applicationController, ProjectLocationInfo projectLocationInfo, SearchEngineManager searchEngineManager, CommandsParser commandsParser, ScheduledTasksService scheduledTasksService, IScheduledTaskSettings iScheduledTaskSettings) {
        int n2 = i;
        super((IStringKey)new CommonsStringKey(F[0]).createExtension((StringKeyStorage)new StringKeyStorage.Fixed(F[1], projectLocationInfo.getProjectName())));
        assert (iScheduledTaskSettings != null);
        this.f = applicationController;
        this.d = searchEngineManager;
        this.e = scheduledTasksService;
        this.c = projectLocationInfo;
        this.b = iScheduledTaskSettings;
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        hashMap.put(iScheduledTaskSettings.getCommand(), iScheduledTaskSettings.getCommandParameters());
        List<Command> list = commandsParser.parse(projectLocationInfo, iScheduledTaskSettings, hashMap);
        this.g = new ArrayList<CommandExecutor>();
        for (Command command : list) {
            CommandExecutor commandExecutor = command.getCommandExecutor(applicationController);
            this.g.add(commandExecutor);
            if (n2 == 0) continue;
            Controller.g = !Controller.g;
            break;
        }
    }

    protected void execute() throws IOException, InterruptedException {
        int n2 = i;
        ThreadSafeUtil.invokeAndWaitEx(() -> this.e.setStateForAll(this.b.getId(), ScheduledTaskState.RUNNING));
        this.checkStopped();
        for (CommandExecutor commandExecutor : this.g) {
            this.checkStopped();
            commandExecutor.execute((CompositeOperation)this, this.d);
            if (n2 == 0) continue;
        }
        super.execute();
    }

    protected void operationFinished() {
        if (this.getOperationState() == OperationState.STOPPED) {
            this.log(OperationConstants.STOPPED_STRING_KEY.getString());
        }
        if (this.getOperationState() == OperationState.FAILED) {
            this.log(OperationConstants.FAILED_STATUS.getString());
        }
        ThreadSafeUtil.runInDispatchThread(() -> {
            this.e.setFinishTimeForAll(this.b.getId(), new Date());
            this.e.setStateForAll(this.b.getId(), ScheduledOperation.getScheduledOperationState(this.getOperationState()));
            try {
                ScheduledOperation.removeOldLog(this.c, this.b);
                ScheduledOperation.saveLog(this.e, this.b, this.c, new OperationResultInfoTransient((Operation)this));
            }
            catch (IOException iOException) {
                a.error("", (Throwable)iOException);
                MessageDialogProvider.showHandleExpectedExceptionDialog(this.f, (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new CommonsStringKey(F[3])), iOException);
            }
        });
        this.g = new ArrayList<CommandExecutor>();
    }

    public static ScheduledTaskState getScheduledOperationState(OperationState operationState) {
        return ScheduledOperation.b(operationState);
    }

    private static ScheduledTaskState b(OperationState operationState) {
        switch (operationState) {
            case OK: {
                return ScheduledTaskState.SUCCESS;
            }
            case STOPPED: {
                return ScheduledTaskState.STOPPED;
            }
            case FAILED: {
                return ScheduledTaskState.FAILED;
            }
        }
        return ScheduledTaskState.SUCCESS;
    }

    public static void saveLog(ScheduledTasksService scheduledTasksService, IScheduledTaskSettings iScheduledTaskSettings, ProjectLocationInfo projectLocationInfo, OperationResultInfoTransient operationResultInfoTransient) throws IOException {
        int n2 = i;
        LogEntry logEntry = new LogEntry(operationResultInfoTransient);
        Database database = logEntry.getDatabase();
        String string = ScheduledOperation.a(projectLocationInfo.getLocation(), iScheduledTaskSettings);
        File file = new File(ApplicationIOUtils.getSchedulerLogDir(), string);
        database.saveToFile(file);
        scheduledTasksService.setLogFilePath(iScheduledTaskSettings.getId(), projectLocationInfo, string);
        if (Controller.g) {
            i = ++n2;
        }
    }

    private static String a(IProjectLocation iProjectLocation, IScheduledTaskSettings iScheduledTaskSettings) {
        StringBuilder stringBuilder;
        block3: {
            block2: {
                stringBuilder = new StringBuilder();
                stringBuilder.append(iScheduledTaskSettings.getName().hashCode()).append(iScheduledTaskSettings.getFinishTime().getTime()).append(iProjectLocation.getStorageType().getId()).append('-');
                if (iProjectLocation.getStorageType() != StorageType.SPS) break block2;
                stringBuilder.append(ProjectClient.cutToken(iProjectLocation.getPath()));
                if (i == 0) break block3;
            }
            stringBuilder.append(new File(iProjectLocation.getPath()).getName());
        }
        stringBuilder.append(F[2]);
        return stringBuilder.toString();
    }

    public static void removeOldLog(ProjectLocationInfo projectLocationInfo, IScheduledTaskSettings iScheduledTaskSettings) {
        String string = ScheduledOperation.a(projectLocationInfo.getLocation(), iScheduledTaskSettings);
        if (!ScheduledOperation.a(ApplicationIOUtils.getApplicationDir(), string)) {
            ScheduledOperation.a(ApplicationIOUtils.getSchedulerLogDir(), string);
        }
    }

    private static boolean a(File file, String string) {
        File file2 = new File(file, string);
        return file2.exists() && file2.delete();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0018[y;d\u0003Bs'+\u0004Ht,a\u0002Gy-Q\u0016Xw";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 119;
                                break;
                            }
                            case 1: {
                                n9 = 43;
                                break;
                            }
                            case 2: {
                                n9 = 28;
                                break;
                            }
                            case 3: {
                                n9 = 73;
                                break;
                            }
                            default: {
                                n9 = 5;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "([n&o\u0012Hh\u000fl\u001bNR(h\u0012";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "YGs.";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0013B}%j\u0010\u0005\u007f(k9Dh\u001aq\u0018Yy\rd\u0003J";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        F = stringArray3;
        a = LoggerFactory.getLogger(ScheduledOperation.class);
    }
}

