/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.commands.process;

import com.agilemind.commons.application.modules.commands.Command;
import com.agilemind.commons.application.modules.commands.process.ICommandManager;
import com.agilemind.commons.application.modules.commands.process.ICommandRunner;
import com.agilemind.commons.application.modules.commands.process.ModalOperationCommandRunner;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandManager
implements ICommandManager {
    private static final Logger a = LoggerFactory.getLogger(CommandManager.class);
    private final Queue<Command> b;
    private final ICommandRunner c;

    public CommandManager(ICommandRunner iCommandRunner) {
        this.c = iCommandRunner;
        this.b = new LinkedList<Command>();
    }

    @Override
    public synchronized void add(Command command) {
        this.b.offer(command);
        this.process();
    }

    @Override
    public synchronized void batchAdd(List<Command> list) {
        boolean bl2 = ModalOperationCommandRunner.f;
        for (Command command : list) {
            this.b.offer(command);
            if (!bl2) continue;
        }
        this.process();
    }

    @Override
    public synchronized void batchExecute(List<Command> list) {
        boolean bl2 = ModalOperationCommandRunner.f;
        for (Command command : list) {
            try {
                this.c.addCommand(command);
            }
            catch (Exception exception) {
                a.error("", (Throwable)exception);
            }
            if (!bl2) continue;
        }
        this.c.run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void process() {
        Command command;
        boolean bl2 = ModalOperationCommandRunner.f;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.b.isEmpty()) {
            return;
        }
        if (!this.c.canRun()) {
            return;
        }
        while ((command = this.b.poll()) != null) {
            try {
                this.c.addCommand(command);
            }
            catch (Exception exception) {
                a.error("", (Throwable)exception);
                if (!bl2) continue;
            }
        }
        this.c.run();
    }

    @Override
    public synchronized void resetOperation() {
        this.c.reset();
    }

    @Override
    public synchronized boolean canProcess() {
        return this.c.canRun();
    }
}

