/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.export.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.data.IProject;
import com.agilemind.commons.application.data.providers.ProjectInfoProvider;
import com.agilemind.commons.application.gui.filechooser.SafeFileChooser;
import com.agilemind.commons.application.localization.LocalizedOptionPane;
import com.agilemind.commons.application.localization.LocalizedValidationException;
import com.agilemind.commons.application.localization.ProjectStringKey;
import com.agilemind.commons.application.modules.dynatags.TagException;
import com.agilemind.commons.application.modules.export.data.ExportData;
import com.agilemind.commons.application.modules.export.data.ExportType;
import com.agilemind.commons.application.modules.export.data.Exporter;
import com.agilemind.commons.application.modules.export.data.IExportTemplate;
import com.agilemind.commons.application.modules.export.data.providers.ExportSupportedInfoProvider;
import com.agilemind.commons.application.modules.export.util.ExportStringKey;
import com.agilemind.commons.application.modules.export.util.a;
import com.agilemind.commons.application.modules.export.util.b;
import com.agilemind.commons.application.modules.export.util.c;
import com.agilemind.commons.application.modules.export.util.d;
import com.agilemind.commons.application.modules.license.LicenseType;
import com.agilemind.commons.application.util.settings.LicenseTypeUtils;
import com.agilemind.commons.application.views.MessageDialogProvider;
import com.agilemind.commons.gui.locale.keysets.BundleOptionPaneStringKeySet;
import com.agilemind.commons.gui.locale.keysets.OptionPaneStringKeySet;
import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.utils.csv.CSVExtensionFileFilter;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.localization.stringkey.StringKeyStorage;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.mvc.controllers.PresentationController;
import com.agilemind.commons.util.Extensions;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.os.Platform;
import com.agilemind.commons.validation.ValidationException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportGenerator {
    private static final Logger a;
    private PresentationController b;
    private static final JFileChooser c;
    private static final String[] d;

    public ExportGenerator(PresentationController presentationController) {
        this.b = presentationController;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveResult(PresentationController presentationController, File file, String string) {
        int n2;
        block11: {
            n2 = ExportStringKey.b;
            try {
                if (!file.exists() && !file.createNewFile()) {
                    a.warn(d[2], (Object)file.getAbsolutePath());
                }
                if (file.canWrite()) {
                    IOUtils.save2UTF8((File)file, (String)string);
                    int n3 = LocalizedOptionPane.showConfirmDialog(presentationController.getContainer(), (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new ExportStringKey(d[0])), 0);
                    if (n3 == 0) {
                        Platform.openFolderAndSelectFile((File)file);
                    }
                    if (n2 == 0) break block11;
                }
                MessageDialogProvider.showErrorMessageDialog(presentationController, (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new ExportStringKey(d[3])));
            }
            catch (IOException iOException) {
                a.error("", (Throwable)iOException);
                MessageDialogProvider.showHandleExpectedExceptionDialog(presentationController, (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new ExportStringKey(d[1])), iOException);
            }
        }
        if (!Controller.g) return;
        ExportStringKey.b = ++n2;
    }

    public <T> String generateResult(IExportTemplate iExportTemplate, ExportData<T> exportData) throws ValidationException, TagException, InterruptedException, IOException {
        return this.a(iExportTemplate, exportData);
    }

    public <T> List<T> checkLicenseType(List<T> list) throws LocalizedValidationException {
        block8: {
            LicenseType licenseType = ((ApplicationControllerImpl)this.b.getApplicationController()).getLicenseType();
            if (licenseType.isAllowed(LicenseType.EXPORT) || list.size() <= 5) break block8;
            int n2 = LicenseTypeUtils.showChangeLicenseMessage(licenseType, LicenseType.EXPORT, this.b);
            if (n2 == 0) {
                throw new LocalizedValidationException(null);
            }
            StringKey stringKey = new ProjectStringKey(d[5]).createExtension((StringKeyStorage)new StringKeyStorage.Fixed(d[4], String.valueOf(5)));
            int n3 = LocalizedOptionPane.showConfirmDialog((Component)this.b.getWindowController().getWindowView(), (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet(stringKey), 2, 1);
            if (n3 != 0) {
                throw new LocalizedValidationException(null);
            }
            list = list.subList(0, Math.min(list.size(), 5));
        }
        return list;
    }

    public static File createDefaultCsvFile(Controller controller, String string) {
        IExportTemplate iExportTemplate = ExportGenerator.a(ExportGenerator.b(controller), string);
        return ExportGenerator.a(controller, iExportTemplate);
    }

    public <T> T[] checkLicenseType(T[] TArray) throws LocalizedValidationException {
        block8: {
            LicenseType licenseType = ((ApplicationControllerImpl)this.b.getApplicationController()).getLicenseType();
            if (licenseType.isAllowed(LicenseType.EXPORT) || TArray.length <= 5) break block8;
            int n2 = LicenseTypeUtils.showChangeLicenseMessage(licenseType, LicenseType.EXPORT, this.b);
            if (n2 == 0) {
                throw new LocalizedValidationException(null);
            }
            StringKey stringKey = new ProjectStringKey(d[11]).createExtension((StringKeyStorage)new StringKeyStorage.Fixed(d[10], String.valueOf(5)));
            int n3 = LocalizedOptionPane.showConfirmDialog((Component)this.b.getWindowController().getWindowView(), (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet(stringKey), 2, 1);
            if (n3 != 0) {
                throw new LocalizedValidationException(null);
            }
            TArray = Arrays.copyOf(TArray, 5);
        }
        return TArray;
    }

    public void saveCSVTemplateFile(String string) {
        IExportTemplate iExportTemplate = ExportGenerator.c();
        File file = this.selectTemplateFile(iExportTemplate);
        if (file != null) {
            ExportGenerator.saveResult(this.b, file, string);
        }
    }

    public void saveCSVTemplateFile(IProject iProject, String string, String string2) {
        IExportTemplate iExportTemplate = ExportGenerator.a(iProject, string);
        File file = this.selectTemplateFile(iExportTemplate);
        if (file != null) {
            ExportGenerator.saveResult(this.b, file, string2);
        }
    }

    private static IExportTemplate a(IProject iProject, String string) {
        String string2 = string + d[12] + iProject.getProjectName();
        string2 = SafeFileChooser.getIncorrectCharsPattern().matcher(string2).replaceAll("_");
        return new d(string2, null);
    }

    private static IExportTemplate c() {
        String string = ExportType.TXT.getDefaultName();
        return new d(string, null);
    }

    public File selectTemplateFile(IExportTemplate iExportTemplate) {
        File file;
        block6: {
            String string;
            block8: {
                int n2;
                block7: {
                    block5: {
                        n2 = ExportStringKey.b;
                        String string2 = iExportTemplate.getFile();
                        string = StringUtil.getFileExtension((String)string2);
                        if (!string.equals(d[6])) break block5;
                        c.setFileFilter((FileFilter)((Object)new a()));
                        if (n2 == 0) break block6;
                        boolean bl2 = Controller.g = !Controller.g;
                    }
                    if (!string.equals(d[8])) break block7;
                    c.setFileFilter((FileFilter)((Object)new b()));
                    if (n2 == 0) break block6;
                }
                if (!string.equals(d[7]) && !string.equals(d[9])) break block8;
                c.setFileFilter((FileFilter)new CSVExtensionFileFilter(true));
                if (n2 == 0) break block6;
            }
            if (StringUtil.contains(Arrays.asList(Extensions.HTML_EXTENTIONS), (String)string)) {
                c.setFileFilter((FileFilter)((Object)new c(this)));
            }
        }
        c.setSelectedFile(ExportGenerator.a(this.b, iExportTemplate));
        int n3 = c.showSaveDialog(this.b.getWindowController().getWindowView());
        if (!(n3 != 0 || (file = c.getSelectedFile()).exists() && this.i() != 0)) {
            return file;
        }
        return null;
    }

    private <T> String a(IExportTemplate iExportTemplate, ExportData<T> exportData) throws TagException, InterruptedException, IOException {
        ExportSupportedInfoProvider exportSupportedInfoProvider = this.b.getNotNullProvider(ExportSupportedInfoProvider.class);
        Exporter<T> exporter = exportSupportedInfoProvider.getExporter();
        String string = iExportTemplate.getTemplate();
        return exporter.generate(string, exportData);
    }

    private int i() {
        return LocalizedOptionPane.showConfirmDialog(this.b.getContainer(), (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new ExportStringKey(d[13])), 2);
    }

    private static File a(Controller controller, IExportTemplate iExportTemplate) {
        String string = iExportTemplate.getFile();
        if (iExportTemplate.isAppendProjectName()) {
            string = StringUtil.getFileNameWOExtension((String)string) + ExportGenerator.a(controller) + '.' + StringUtil.getFileExtension((String)string);
        }
        return new File(string);
    }

    private static String a(Controller controller) {
        return "_" + ExportGenerator.b(controller).getProjectName();
    }

    private static IProject b(Controller controller) {
        ProjectInfoProvider projectInfoProvider = controller.getProvider(ProjectInfoProvider.class);
        return projectInfoProvider.getProject();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "(#yr1v'og2*6dv+=ldb>;'dd";
        int n3 = -1;
        block21: while (true) {
            char[] cArray;
            block26: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block25: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block25;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block26;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 88;
                                break;
                            }
                            case 1: {
                                n9 = 66;
                                break;
                            }
                            case 2: {
                                n9 = 23;
                                break;
                            }
                            case 3: {
                                n9 = 23;
                                break;
                            }
                            default: {
                                n9 = 93;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "(#yr1v'og2*6dv+=lxg)1-yg<6'9t<6,xc.94r";
                    n3 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001b#yy2,bte896r7;1.r7&%";
                    n3 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "(#yr1v'og2*6dv+=lxg)1-yg<6'9t<6,xc.94r";
                    n3 = 2;
                    continue block21;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0007'og2*6[~016";
                    n3 = 3;
                    continue block21;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "72re<,+xys(0x}8;69r%(-ecs;-yq4*/";
                    n3 = 4;
                    continue block21;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "+3{";
                    n3 = 5;
                    continue block21;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ",:c";
                    n3 = 6;
                    continue block21;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = " /{";
                    n3 = 7;
                    continue block21;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = ";1a";
                    n3 = 8;
                    continue block21;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0007'og2*6[~016";
                    n3 = 9;
                    continue block21;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "72re<,+xys(0x}8;69r%(-ecs;-yq4*/";
                    n3 = 10;
                    continue block21;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "xo7";
                    n3 = 11;
                    continue block21;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "(#yr1v'og2*6dv+=lxg)1-yg<6'9v1*'vs$=:~d)+";
                    n3 = 12;
                    continue block21;
                }
                case 12: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        d = stringArray3;
        a = LoggerFactory.getLogger(ExportGenerator.class);
        c = SafeFileChooser.create();
    }
}

