/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.factors.data;

import com.agilemind.commons.application.modules.factors.data.DomainStrengthCalculated;
import com.agilemind.commons.application.modules.factors.data.SEOFactorsSettings;
import com.agilemind.commons.application.modules.factors.data.a;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.ISearchEngineFactor;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.factors.IFactorParser;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.AlexaPopularityResult;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class DomainStrengthUtil {
    private static final DecimalFormatSymbols a;
    public static final DecimalFormat NUMBER_FORMAT;
    public static final double NA = -1.0;
    private static final String b;

    private DomainStrengthUtil() {
    }

    public static DomainStrengthCalculated toCalculated(IPopularityMap iPopularityMap) {
        int n2 = SEOFactorsSettings.r;
        DomainStrengthCalculated domainStrengthCalculated = new DomainStrengthCalculated();
        domainStrengthCalculated.setPageRank((Integer)DomainStrengthUtil.a(SearchEngineFactorsList.BLEX_DOMAIN_RANK, iPopularityMap));
        domainStrengthCalculated.setAlexa((AlexaPopularityResult)DomainStrengthUtil.a(SearchEngineFactorsList.ALEXA, iPopularityMap));
        domainStrengthCalculated.setBacklinkDomains((Long)DomainStrengthUtil.a(SearchEngineFactorsList.BACKLINK_DOMAINS, iPopularityMap));
        domainStrengthCalculated.setDomainAge((Date)DomainStrengthUtil.a(SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE, iPopularityMap));
        domainStrengthCalculated.setFacebookSignals((Long)DomainStrengthUtil.a(SearchEngineFactorsList.DOMAIN_FACEBOOK_FACTOR_TYPE, iPopularityMap));
        domainStrengthCalculated.setTwitterSignals((Long)DomainStrengthUtil.a(SearchEngineFactorsList.DOMAIN_TWITTER_FACTOR_TYPE, iPopularityMap));
        domainStrengthCalculated.setGooglePlusSignals((Integer)DomainStrengthUtil.a(SearchEngineFactorsList.DOMAIN_GOOGLE_PLUS_ONE_FACTOR_TYPE, iPopularityMap));
        if (Controller.g) {
            SEOFactorsSettings.r = ++n2;
        }
        return domainStrengthCalculated;
    }

    public static double getStrength(IPopularityMap iPopularityMap) {
        return DomainStrengthUtil.getStrength(DomainStrengthUtil.toCalculated(iPopularityMap));
    }

    public static double getStrength(DomainStrengthCalculated domainStrengthCalculated) {
        int n2 = SEOFactorsSettings.r;
        int n3 = 0;
        for (FactorStrength factorStrength : DomainStrengthUtil.c()) {
            int n4 = factorStrength.getStrength(domainStrengthCalculated);
            if (n4 == -1) {
                return -1.0;
            }
            n3 += n4;
            if (n2 == 0) continue;
        }
        return (double)n3 / 100.0;
    }

    private static List<FactorStrength> c() {
        ArrayList<FactorStrength> arrayList = new ArrayList<FactorStrength>();
        arrayList.add(new RankFactorStrength());
        arrayList.add(new a());
        arrayList.add(new SocialPopularityFactorStrength());
        arrayList.add(new DomainAgeFactorStrength());
        arrayList.add(new BacklinkDomainsFactorStrength());
        return arrayList;
    }

    @Nullable
    private static <T extends Comparable> T a(SearchEngineFactorType<T> searchEngineFactorType, IPopularityMap iPopularityMap) {
        ISearchEngineFactor<T> iSearchEngineFactor = iPopularityMap.getFactor(searchEngineFactorType);
        if (iSearchEngineFactor == null) {
            return null;
        }
        return iSearchEngineFactor.getFactorValue();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "#$})".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 19;
                            break;
                        }
                        case 1: {
                            n7 = 10;
                            break;
                        }
                        case 2: {
                            n7 = 77;
                            break;
                        }
                        case 3: {
                            n7 = 25;
                            break;
                        }
                        default: {
                            n7 = 102;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        b = new String(cArray).intern();
        a = new DecimalFormatSymbols();
        a.setDecimalSeparator('.');
        NUMBER_FORMAT = new DecimalFormat(b, a);
    }

    public static class BacklinkDomainsFactorStrength
    implements FactorStrength {
        private static final Long[] a = new Long[]{10L, 20L, 30L, 40L, 50L, 60L, 70L, 80L, 90L, 100L, 150L, 200L, 250L, 300L, 350L, 400L, 450L, 500L, 550L, 600L, 650L, 700L, 750L, 800L, 850L, 900L, 950L, 1000L, 1100L, 1200L, 1300L, 1400L, 1500L, 1600L, 1700L, 1800L, 1900L, 2000L, 2100L, 2200L, 2300L, 2400L, 2500L, 2600L, 2700L, 2800L, 2900L, 3000L, 3100L, 3200L, 3300L, 3400L, 3500L, 3600L, 3700L, 3800L, 3900L, 4000L, 4100L, 4200L, 4300L, 4400L, 4500L, 4600L, 4700L, 4800L, 4900L, 5000L, 5500L, 6000L, 6500L, 7000L, 7500L, 8000L, 8500L, 9000L, 9500L, 10000L, 11000L, 12000L, 13000L, 14000L, 15000L, 16000L, 17000L, 18000L, 19000L, 20000L, 25000L, 30000L, 35000L, 40000L, 45000L, 50000L, 55000L, 60000L, 65000L, 70000L, 75000L, 80000L, 85000L, 90000L, 100000L};

        @Override
        public int getStrength(DomainStrengthCalculated domainStrengthCalculated) {
            Long l2 = domainStrengthCalculated.getBacklinkDomains();
            if (l2 == null) {
                return -1;
            }
            if (l2 == 0L) {
                return 0;
            }
            int n2 = Arrays.binarySearch(a, l2, Long::compare);
            return n2 < 0 ? -n2 - 1 : n2 + 1;
        }
    }

    public static class DomainAgeFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108, 114, 120, 132, 144, 156, 168, 180, 192, 204, 216, 228, 240};

        @Override
        public int getStrength(DomainStrengthCalculated domainStrengthCalculated) {
            Date date = domainStrengthCalculated.getDomainAge();
            if (date == null) {
                return -1;
            }
            if (date.equals(IFactorParser.NA_DATE)) {
                return 0;
            }
            int n2 = DomainAgeFactorStrength.differenceInMonth(date, new Date());
            int n3 = Arrays.binarySearch((Object[])a, (Object)n2);
            return n3 < 0 ? -n3 - 1 : n3 + 1;
        }

        public static int differenceInMonth(Date date, Date date2) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            int n2 = calendar2.get(1) - calendar.get(1);
            return n2 * 12 + calendar2.get(2) - calendar.get(2);
        }
    }

    public static class SocialPopularityFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{10, 50, 60, 70, 80, 90, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500, 9000, 9500, 10000, 11000, 12000, 13000, 14000, 15000, 16000, 17000, 18000, 19000, 20000, 25000, 30000, 35000, 40000, 45000, 50000, 60000, 70000, 80000, 90000, 100000, 500000, 1000000, 2000000, 3000000, 4000000, 5000000};

        @Override
        public int getStrength(DomainStrengthCalculated domainStrengthCalculated) {
            Integer n2;
            Long l2 = domainStrengthCalculated.getFacebookSignals();
            if (l2 == null) {
                return -1;
            }
            Long l3 = domainStrengthCalculated.getTwitterSignals();
            if (l3 == null || l3 == -1L) {
                l3 = 0L;
            }
            if ((n2 = domainStrengthCalculated.getGooglePlusSignals()) == null) {
                return -1;
            }
            int n3 = l2.intValue() + l3.intValue() + n2;
            int n4 = Arrays.binarySearch((Object[])a, (Object)n3);
            return n4 < 0 ? -n4 - 1 : n4 + 1;
        }
    }

    public static class RankFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 56, 62, 68, 74, 80, 86, 92, 98, 104, 110, 116, 122, 128, 134, 140, 146, 152, 158, 164, 170, 176, 182, 188, 194, 200, 206, 212, 218, 224, 230, 237, 244, 251, 258, 265, 272, 279, 286, 293, 300, 307, 314, 321, 328, 335, 342, 349, 356, 363, 370, 377, 384, 391, 398, 405, 412, 419, 426, 433, 440, 447, 454, 461, 468, 475, 482, 489, 496, 503, 510, 517, 524, 531, 538, 545, 552, 559, 566, 573, 580, 582, 584, 586, 588, 590, 592, 594, 596, 598, 600};

        @Override
        public int getStrength(DomainStrengthCalculated domainStrengthCalculated) {
            Integer n2 = domainStrengthCalculated.getPageRank();
            if (n2 == null) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            assert (a.length == 101);
            return n2 >= 0 && n2 <= 100 ? a[n2] : 0;
        }
    }

    public static interface FactorStrength {
        public static final int NA = -1;

        public int getStrength(DomainStrengthCalculated var1);
    }
}

