/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.io.searchengine.data;

import com.agilemind.commons.application.data.difference.FactorDifferencePeriod;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineFactorList;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.Flexible;
import com.agilemind.commons.data.Identifier;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.data.RecordList;
import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.data.field.ModifiableField;
import com.agilemind.commons.data.field.RecordBeanField;
import com.agilemind.commons.gui.chart.data.XYChartData;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.localization.util.LocalizedStringUtil;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.factors.SearchEngineFactorType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PopularityHistory<T extends Comparable>
extends RecordList<PopularityHistory<T>, SearchEngineFactor<T>> {
    private static final RecordBeanField a;
    private static final String k;

    public PopularityHistory(Database database, Identifier identifier) {
        super(database, identifier, a);
    }

    public PopularityHistory(PopularityHistoryMap popularityHistoryMap) {
        super((Record)popularityHistoryMap, a);
    }

    public void addFactorValue(Date date, SearchEngineFactorType<T> searchEngineFactorType, T t2) {
        block3: {
            SearchEngineFactor<T> searchEngineFactor;
            block2: {
                searchEngineFactor = this.getLastRankingFactor();
                if (searchEngineFactor != null && DateUtil.theSameDay((Date)searchEngineFactor.getCheckDate(), (Date)date)) break block2;
                this.add(new SearchEngineFactor<T>((Record)this, date, searchEngineFactorType, t2));
                if (!UseSearchEngineFactorList.DefaultSearchEnginesFactors.b) break block3;
            }
            searchEngineFactor.set((RecordBeanField)SearchEngineFactor.FLEXIBLE, new Flexible(searchEngineFactor.getFactorClassType(), t2));
            searchEngineFactor.set((RecordBeanField)SearchEngineFactor.PROPERTY_CHECK_DATE, date);
        }
    }

    public SearchEngineFactor<T> getLastRankingFactor() {
        boolean bl2 = UseSearchEngineFactorList.DefaultSearchEnginesFactors.b;
        SearchEngineFactor searchEngineFactor = null;
        Date date = null;
        for (SearchEngineFactor searchEngineFactor2 : this.getList()) {
            Date date2 = searchEngineFactor2.getCheckDate();
            if (date == null || date.compareTo(date2) < 0) {
                searchEngineFactor = searchEngineFactor2;
                date = date2;
            }
            if (!bl2) continue;
        }
        return searchEngineFactor;
    }

    public void save2CSV(File file) throws IOException {
        boolean bl2 = UseSearchEngineFactorList.DefaultSearchEnginesFactors.b;
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        for (SearchEngineFactor searchEngineFactor : this.getList()) {
            bufferedWriter.write(LocalizedStringUtil.getShortDateWithoutTime((Date)searchEngineFactor.getCheckDate()));
            bufferedWriter.write(";");
            bufferedWriter.write(StringUtil.toString(searchEngineFactor.getFactorValue()));
            bufferedWriter.newLine();
            if (!bl2) continue;
        }
        bufferedWriter.close();
    }

    public SearchEngineFactor<T> getRankingFactor(Age age) {
        boolean bl2 = UseSearchEngineFactorList.DefaultSearchEnginesFactors.b;
        SearchEngineFactor searchEngineFactor = null;
        Calendar calendar = Calendar.getInstance();
        DateUtil.setStartDayCalendar((Calendar)calendar, (Date)new Date());
        age.getDate(calendar);
        Date date = calendar.getTime();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SearchEngineFactor searchEngineFactor2 = (SearchEngineFactor)iterator.next();
            DateUtil.setStartDayCalendar((Calendar)calendar, (Date)searchEngineFactor2.getCheckDate());
            if (calendar.getTime().after(date) && !bl2) break;
            searchEngineFactor = searchEngineFactor2;
            if (!bl2) continue;
        }
        return searchEngineFactor;
    }

    public XYChartData<T> getChartData(SearchEngineFactorType<T> searchEngineFactorType) {
        XYDataset<T> xYDataset = this.getSeriesDataset();
        return new XYChartData.Builder().setReverse(searchEngineFactorType.isMoreIsAlwaysBetter()).addSeriesDataset(xYDataset).build();
    }

    public XYDataset<T> getSeriesDataset() {
        boolean bl2 = UseSearchEngineFactorList.DefaultSearchEnginesFactors.b;
        XYDataset xYDataset = new XYDataset();
        for (SearchEngineFactor searchEngineFactor : this.getList()) {
            Object t2 = searchEngineFactor.getFactorValue();
            if (t2 instanceof Number && ((Number)t2).intValue() < 0 || ((Number)t2).intValue() == Integer.MAX_VALUE) {
                t2 = null;
            }
            xYDataset.put((Object)searchEngineFactor.getCheckDate(), t2);
            if (!bl2) continue;
        }
        return xYDataset;
    }

    public SearchEngineFactor<? extends Comparable> getFactorDifference(FactorDifferencePeriod factorDifferencePeriod) {
        return (SearchEngineFactor)factorDifferencePeriod.getValue(this.getList());
    }

    public SearchEngineFactor<T> getFirstFactor() {
        return this.isEmpty() ? null : (SearchEngineFactor)this.get(0);
    }

    public List<SearchEngineFactor> getRecords(boolean bl2) {
        ArrayList<SearchEngineFactor> arrayList = new ArrayList<SearchEngineFactor>(this.getList());
        if (!bl2) {
            Collections.sort(arrayList, (searchEngineFactor, searchEngineFactor2) -> {
                Date date = searchEngineFactor.getCheckDate();
                Date date2 = searchEngineFactor2.getCheckDate();
                return date2.compareTo(date);
            });
        }
        return arrayList;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "[m\u001e\u000e_@M\u0011\u001bUFm9\u001d_\\g\r".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 40;
                            break;
                        }
                        case 1: {
                            n7 = 8;
                            break;
                        }
                        case 2: {
                            n7 = 127;
                            break;
                        }
                        case 3: {
                            n7 = 124;
                            break;
                        }
                        default: {
                            n7 = 60;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        k = new String(cArray).intern();
        a = new ModifiableField(k, PopularityHistory.class, SearchEngineFactor.class);
    }
}

