/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.newchart.data;

import com.agilemind.commons.application.modules.newchart.data.AbstractGraphicData;
import com.agilemind.commons.application.modules.newchart.data.ChartEvent;
import com.agilemind.commons.application.modules.newchart.data.IChartSettings;
import com.agilemind.commons.application.modules.newchart.data.IGraphicDataProvider;
import com.agilemind.commons.application.modules.newchart.data.IGraphicDescription;
import com.agilemind.commons.application.modules.newchart.data.Period;
import com.agilemind.commons.application.modules.newchart.data.PeriodSupplier;
import com.agilemind.commons.application.modules.newchart.data.SettingsFields;
import com.agilemind.commons.application.modules.newchart.data.XYChartVersion2;
import com.agilemind.commons.application.modules.newchart.data.c;
import com.agilemind.commons.application.modules.newchart.data.d;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.Pair;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.data.time.TimePeriodValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChartSettingsImpl<T extends AbstractGraphicData>
implements IChartSettings {
    private static final Logger a;
    protected final Map<IGraphicDescription, T> graphicDataMap;
    final PropertyChangeSupport b;
    protected final IGraphicDataProvider provider;
    private d c;
    @NotNull
    private Supplier<Pair<Date, Date>> d;
    @Nullable
    private List<ChartEvent> e;
    private Date f;
    private Function<Optional<Date>, Optional<Date>> g;
    private static final String[] h;

    public AbstractChartSettingsImpl(@NotNull Supplier<Pair<Date, Date>> supplier, IGraphicDataProvider iGraphicDataProvider) {
        boolean bl2 = XYChartVersion2.k;
        this.graphicDataMap = new HashMap<IGraphicDescription, T>();
        this.c = new d(null);
        a.debug(h[3]);
        this.provider = iGraphicDataProvider;
        Objects.requireNonNull(supplier);
        this.d = supplier;
        this.b = new PropertyChangeSupport(this);
        this.b.addPropertyChangeListener(SettingsFields.CHART_DATA.name(), (PropertyChangeEvent propertyChangeEvent) -> {
            this.f = null;
        });
        if (Controller.g) {
            XYChartVersion2.k = !bl2;
        }
    }

    @Override
    public boolean isEnableGraphic(IGraphicDescription iGraphicDescription) {
        return this.graphicDataMap.containsKey(iGraphicDescription) && ((AbstractGraphicData)this.graphicDataMap.get(iGraphicDescription)).isEnable();
    }

    public void setMinimumDateHandler(@NotNull Function<Optional<Date>, Optional<Date>> function) {
        this.g = function;
    }

    public void clearTooltips() {
        com.agilemind.commons.application.modules.newchart.data.d.access$100(this.c).clear();
    }

    @Override
    @NotNull
    public Period getPeriod() {
        return this.c();
    }

    @Override
    public Pair<Date, Date> getPeriodRange() {
        return this.d.get();
    }

    @Override
    public Optional<Map<TimePeriodValues, Paint>> getChartData() {
        a.debug(h[1]);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        int[] nArray = new int[]{0};
        this.graphicDataMap.values().forEach(abstractGraphicData -> {
            if (abstractGraphicData.isEnable()) {
                TimePeriodValues timePeriodValues;
                if (abstractGraphicData.getChartData() == null) {
                    this.provider.getDataFor((IGraphicDescription)abstractGraphicData.graphicId).ifPresent(abstractGraphicData::setChartData);
                }
                if ((timePeriodValues = abstractGraphicData.getChartData()) != null && !timePeriodValues.isEmpty()) {
                    linkedHashMap.put(abstractGraphicData.getChartData(), abstractGraphicData.getColor());
                    int n2 = nArray[0];
                    nArray[0] = n2 + 1;
                    this.c.a(n2, (AbstractGraphicData)abstractGraphicData);
                }
            }
        });
        return linkedHashMap.isEmpty() ? Optional.empty() : Optional.of(linkedHashMap);
    }

    @Override
    public Optional<List<ChartEvent>> getEvents() {
        return Optional.ofNullable(this.e);
    }

    @Override
    public void addPropertyChangeListener(SettingsFields settingsFields, PropertyChangeListener propertyChangeListener) {
        this.b.addPropertyChangeListener(settingsFields.name(), propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(SettingsFields settingsFields, PropertyChangeListener propertyChangeListener) {
        this.b.removePropertyChangeListener(settingsFields.name(), propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.b.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.b.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void setPeriodSupplier(@NotNull Supplier<Pair<Date, Date>> supplier) {
        Period period = this.c();
        Supplier<Pair<Date, Date>> supplier2 = this.d;
        this.d = supplier;
        this.b.firePropertyChange(SettingsFields.RANGE.name(), supplier2, supplier);
        this.b.firePropertyChange(SettingsFields.PERIOD.name(), (Object)period, (Object)this.c());
    }

    @Override
    public Supplier<Pair<Date, Date>> createNewAllSupplier() {
        return new c(this, null);
    }

    @Override
    public long getZoomStepInDays() {
        return 1L;
    }

    public void setPeriodSupplier(@NotNull PeriodSupplier periodSupplier) {
        this.setPeriodSupplier(periodSupplier.getSupplier());
    }

    public XYToolTipGenerator geToolTipGenerator() {
        return this.c;
    }

    public void setEnableGraphic(IGraphicDescription iGraphicDescription, boolean bl2) {
        a.debug(h[5], (Object)iGraphicDescription.getName(), (Object)bl2);
        this.graphicDataMap.computeIfPresent(iGraphicDescription, (iGraphicDescription2, abstractGraphicData) -> {
            abstractGraphicData.setEnable(bl2);
            if (bl2 && abstractGraphicData.getChartData() == null) {
                this.provider.getDataFor(iGraphicDescription).ifPresent(abstractGraphicData::setChartData);
            }
            this.updateChartDataList();
            return abstractGraphicData;
        });
    }

    public boolean isNeedShowItems() {
        Optional optional = this.getChartData().flatMap(map -> {
            boolean bl2 = XYChartVersion2.k;
            Pair<Date, Date> pair = this.getPeriodRange();
            Date date = (Date)pair.getA();
            Date date2 = (Date)pair.getB();
            int n2 = 0;
            boolean bl3 = false;
            for (TimePeriodValues timePeriodValues : map.keySet()) {
                TimePeriodValue timePeriodValue;
                n2 = 0;
                for (int i2 = 0; i2 < timePeriodValues.getItemCount() && ((timePeriodValue = timePeriodValues.getDataItem(i2)).getPeriod().getStart().compareTo(date) < 0 || timePeriodValue.getPeriod().getEnd().compareTo(date2) >= 0 || !(bl3 = ++n2 >= 32) || bl2); ++i2) {
                    if (!bl2) continue;
                }
                if ((!bl3 || bl2) && !bl2) continue;
            }
            return Optional.of(!bl3);
        });
        return optional.isPresent() && (Boolean)optional.get() != false;
    }

    public Optional<Pair<? extends Number, ? extends Number>> getMinimumAndMaximumValue(Pair<Date, Date> pair) {
        boolean bl2 = XYChartVersion2.k;
        Optional<Map<TimePeriodValues, Paint>> optional = this.getChartData();
        if (optional.isPresent()) {
            Map<TimePeriodValues, Paint> map = optional.get();
            int[] nArray = new int[]{0, Integer.MIN_VALUE};
            Date date = Date.from(((Date)pair.getA()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date date2 = Date.from(((Date)pair.getB()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
            for (TimePeriodValues timePeriodValues : map.keySet()) {
                for (int i2 = 0; i2 < timePeriodValues.getItemCount(); ++i2) {
                    TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(i2);
                    FixedMillisecond fixedMillisecond = (FixedMillisecond)timePeriodValue.getPeriod();
                    Date date3 = fixedMillisecond.getTime();
                    if (!date3.after(date) || !date3.before(date2)) continue;
                    int n2 = timePeriodValue.getValue().intValue();
                    nArray[1] = Math.max(nArray[1], n2);
                    if (!bl2) continue;
                }
                if (!bl2) continue;
            }
            return Optional.of(Pair.create((Object)nArray[0], (Object)Math.max(nArray[1], 10)));
        }
        return Optional.of(Pair.create((Object)0, (Object)10));
    }

    public <T extends AbstractGraphicData> Optional<T> getGraphicData(IGraphicDescription iGraphicDescription, Class<T> clazz) {
        AbstractGraphicData abstractGraphicData = (AbstractGraphicData)this.graphicDataMap.get(iGraphicDescription);
        return abstractGraphicData == null || !clazz.isInstance(abstractGraphicData) ? Optional.empty() : Optional.of(abstractGraphicData);
    }

    public void refreshData() {
        this.clearData();
        a.debug(h[2]);
        this.graphicDataMap.forEach((iGraphicDescription, abstractGraphicData) -> {
            if (abstractGraphicData.isEnable()) {
                this.provider.getDataFor((IGraphicDescription)iGraphicDescription).ifPresent(abstractGraphicData::setChartData);
            }
        });
        this.updateChartDataList();
    }

    public void clearData() {
        a.debug(h[4]);
        this.graphicDataMap.values().stream().forEach(AbstractGraphicData::clearData);
    }

    public Optional<Date> getMinimumDate() {
        if (this.f == null) {
            this.getChartData().ifPresent(map -> {
                Date date;
                boolean bl2 = XYChartVersion2.k;
                this.f = date = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
                for (Map.Entry entry : map.entrySet()) {
                    for (int i2 = 0; i2 < ((TimePeriodValues)entry.getKey()).getItemCount(); ++i2) {
                        Number number = ((TimePeriodValues)entry.getKey()).getValue(i2);
                        if (number == null || number.equals(Double.NaN) && !bl2) continue;
                        Date date2 = ((TimePeriodValues)entry.getKey()).getDataItem(i2).getPeriod().getStart();
                        Date date3 = this.f = date2.before(this.f) ? date2 : this.f;
                        if (!bl2) break;
                        if (!bl2) continue;
                    }
                    if (!bl2) continue;
                }
                if (this.f == date) {
                    this.f = null;
                }
            });
        }
        Optional<Date> optional = Optional.ofNullable(this.f);
        return this.g == null ? optional : this.g.apply(optional);
    }

    public void setEventsList(@Nullable List<ChartEvent> list) {
        List<ChartEvent> list2 = this.e;
        this.e = list;
        this.b.firePropertyChange(SettingsFields.EVENTS_DATA.name(), list2, list);
    }

    public List<IGraphicDescription> getAllDescriptions() {
        return new ArrayList<IGraphicDescription>(this.graphicDataMap.keySet());
    }

    protected void updateChartDataList() {
        a.debug(h[0]);
        this.b.firePropertyChange(SettingsFields.CHART_DATA.name(), null, this.getChartData().orElse(null));
    }

    private Period c() {
        return PeriodSupplier.recognizePeriod(this.d);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "l\\?\u0013\u0006|\f\u0018\u001a\u0013kX{6\u0013mM{>\u001bjXu";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 25;
                                break;
                            }
                            case 1: {
                                n9 = 44;
                                break;
                            }
                            case 2: {
                                n9 = 91;
                                break;
                            }
                            case 3: {
                                n9 = 114;
                                break;
                            }
                            default: {
                                n9 = 114;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "KI/\u0007\u0000w\f8\u001a\u0013kX{\u0016\u0013mM";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "KI=\u0000\u0017jD2\u001c\u00159H:\u0006\u0013";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "PB2\u0006RjI/\u0006\u001bwK(";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "z@>\u0013\u00009H:\u0006\u0013";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "zD:\u001c\u0015|\f>\u001c\u0013{@>R5kM+\u001a\u001bz\ffRUbQ|R\u0006v\ffRUbQ|";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        h = stringArray3;
        a = LoggerFactory.getLogger(AbstractChartSettingsImpl.class);
    }
}

