/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.newchart.data;

import com.agilemind.commons.application.modules.newchart.data.IGraphicDescription;
import com.agilemind.commons.application.modules.newchart.data.XYChartVersion2;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.util.Pair;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphicData<T extends IGraphicDescription> {
    private static final DateTimeFormatter a;
    private static final Logger b;
    private final PropertyChangeSupport c;
    protected T graphicId;
    private boolean d;
    private Color e;
    private static final String[] f;

    public AbstractGraphicData(boolean bl2, T t2) {
        b.debug(f[6], (Object)t2.toString());
        this.d = bl2;
        this.graphicId = t2;
        this.c = new PropertyChangeSupport(this);
        this.addEnableListener(propertyChangeEvent -> {
            this.d = (Boolean)propertyChangeEvent.getNewValue();
        });
    }

    public boolean isEnable() {
        return this.d;
    }

    public void setEnable(boolean bl2) {
        this.c.firePropertyChange(f[8], this.d, bl2);
    }

    public abstract TimePeriodValues getChartData();

    public abstract void setChartData(XYDataset<Number> var1);

    public Color getColor() {
        return this.e;
    }

    public void setColor(Color color) {
        this.e = color;
    }

    public void addEnableListener(PropertyChangeListener propertyChangeListener) {
        this.c.addPropertyChangeListener(f[0], propertyChangeListener);
    }

    public void addDataListener(PropertyChangeListener propertyChangeListener) {
        this.c.addPropertyChangeListener(f[9], propertyChangeListener);
    }

    public abstract String getTooltip(Integer var1);

    public abstract void clearData();

    protected void fireDataChange(XYDataset<Number> xYDataset, XYDataset<Number> xYDataset2) {
        this.c.firePropertyChange(f[7], xYDataset, xYDataset2);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.c.firePropertyChange(string, object, object2);
    }

    protected void addPropertyListener(String string, PropertyChangeListener propertyChangeListener) {
        this.c.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected abstract void setTooltipFor(int var1, String var2);

    @NotNull
    protected TimePeriodValues createTimePeriodValues(@NotNull XYDataset<Number> xYDataset) {
        String string = this.graphicId.getName();
        TimePeriodValues timePeriodValues = new TimePeriodValues(string);
        if (!xYDataset.isEmpty()) {
            this.fillTimePeriodValues(xYDataset, string, timePeriodValues);
        }
        return timePeriodValues;
    }

    protected void fillTimePeriodValues(@NotNull XYDataset<Number> xYDataset, String string, TimePeriodValues timePeriodValues) {
        boolean bl2 = XYChartVersion2.k;
        int n2 = 0;
        ArrayList<Pair<LocalDate, Double>> arrayList = new ArrayList<Pair<LocalDate, Double>>(7);
        for (Map.Entry entry : xYDataset.entrySet()) {
            Number number = (Number)entry.getValue();
            if (number != null) {
                LocalDate localDate = ((Date)entry.getKey()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                timePeriodValues.add((TimePeriod)new FixedMillisecond(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant())), number);
                this.setTooltipFor(n2++, this.createTooltip(string, number.longValue(), arrayList));
            }
            if (!bl2) continue;
        }
    }

    protected String createTooltip(String string, long l2, List<Pair<LocalDate, Double>> list) {
        if (list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(f[3]).append(string).append(f[2]).append(l2).append(f[5]).append(a.withLocale(Locale.getDefault()).format((TemporalAccessor)list.get(0).getA()));
            if (list.size() > 1) {
                stringBuilder.append(f[4]).append(a.format((TemporalAccessor)list.get(list.size() - 1).getA()));
            }
            return stringBuilder.append(f[1]).toString();
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block33: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block32: {
                String string;
                String[] stringArray = new String[10];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "[\n:\"O[";
                int n6 = -1;
                block23: while (true) {
                    char[] cArray3;
                    block31: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block30: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block30;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block31;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 62;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 100;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 91;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 64;
                                        break;
                                    }
                                    default: {
                                        n11 = 35;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "\u0002K34NRZ";
                            n6 = 0;
                            continue block23;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = "\u0004D";
                            n6 = 1;
                            continue block23;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "\u0002\f/-O\u0000";
                            n6 = 2;
                            continue block23;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "\u001eI{";
                            n6 = 3;
                            continue block23;
                        }
                        case 3: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 5;
                            string2 = "\u0002\u0006)o\u001d";
                            n6 = 4;
                            continue block23;
                        }
                        case 4: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 6;
                            string2 = "}\u0016>!W[D5%T\u001e#)!SV\r8\u0004BJ\u0005{&LLDf`\u0004E\u0019|";
                            n6 = 5;
                            continue block23;
                        }
                        case 5: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 7;
                            string2 = "Z\u0005/!";
                            n6 = 6;
                            continue block23;
                        }
                        case 6: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 8;
                            string2 = "[\n:\"O[";
                            n6 = 7;
                            continue block23;
                        }
                        case 7: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 9;
                            string2 = "Z\u0005/!";
                            n6 = 8;
                            continue block23;
                        }
                        case 8: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                f = stringArray3;
                char[] cArray8 = "s)\u0016`GZH\u0002\u0019zg".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block32;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block33;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 62;
                            break;
                        }
                        case 1: {
                            n14 = 100;
                            break;
                        }
                        case 2: {
                            n14 = 91;
                            break;
                        }
                        case 3: {
                            n14 = 64;
                            break;
                        }
                        default: {
                            n14 = 35;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = DateTimeFormatter.ofPattern(new String(cArray).intern(), Locale.getDefault());
        b = LoggerFactory.getLogger(AbstractGraphicData.class);
    }
}

