/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.newchart.data;

import com.agilemind.commons.application.modules.newchart.data.AbstractGraphicData;
import com.agilemind.commons.application.modules.newchart.data.IGraphicDescription;
import com.agilemind.commons.application.modules.newchart.data.Summarize;
import com.agilemind.commons.application.modules.newchart.data.XYChartVersion2;
import com.agilemind.commons.gui.chart.data.XYDataset;
import com.agilemind.commons.util.Pair;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;

public abstract class AbstractSummarizeGraphicData<T extends IGraphicDescription>
extends AbstractGraphicData<T> {
    protected Summarize summarize;

    public AbstractSummarizeGraphicData(boolean bl2, T t2, Summarize summarize) {
        super(bl2, t2);
        this.summarize = summarize;
    }

    @Override
    protected void fillTimePeriodValues(@NotNull XYDataset<Number> xYDataset, String string, TimePeriodValues timePeriodValues) {
        block3: {
            LocalDate localDate2;
            LocalDate localDate3;
            block4: {
                boolean bl2;
                block2: {
                    bl2 = XYChartVersion2.k;
                    localDate3 = ((Date)xYDataset.firstKey()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (Summarize.DAY != this.summarize) break block2;
                    this.a(xYDataset, string, timePeriodValues, localDate3, localDate -> localDate.plusDays(1L));
                    if (!bl2) break block3;
                }
                if (this.summarize != Summarize.WEEK) break block4;
                localDate2 = localDate3.with(WeekFields.of(Locale.getDefault()).dayOfWeek(), 1L).minusDays(1L);
                this.a(xYDataset, string, timePeriodValues, localDate2, localDate -> localDate.plusWeeks(1L));
                if (!bl2) break block3;
            }
            localDate2 = localDate3.with(TemporalAdjusters.lastDayOfMonth());
            this.a(xYDataset, string, timePeriodValues, localDate2, localDate -> localDate.plusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
        }
    }

    public void setSummarize(Summarize summarize) {
        this.summarize = summarize;
    }

    private void a(@NotNull XYDataset<Number> xYDataset, String string, TimePeriodValues timePeriodValues, LocalDate localDate, Function<LocalDate, LocalDate> function) {
        boolean bl2 = XYChartVersion2.k;
        int n2 = 0;
        int n3 = xYDataset.size();
        ArrayList<Pair<LocalDate, Double>> arrayList = new ArrayList<Pair<LocalDate, Double>>(7);
        for (Map.Entry entry : xYDataset.entrySet()) {
            block3: {
                block4: {
                    block6: {
                        LocalDate localDate2;
                        block5: {
                            localDate2 = ((Date)entry.getKey()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                            Number number = (Number)entry.getValue();
                            arrayList.add(Pair.create((Object)localDate2, (Object)(number == null ? Double.NaN : number.doubleValue())));
                            if (localDate.compareTo(localDate2) > 0 && --n3 > 0) break block3;
                            if (arrayList.isEmpty()) break block4;
                            if (!this.a(arrayList)) break block5;
                            timePeriodValues.add((TimePeriod)new FixedMillisecond(Date.from(localDate2.atStartOfDay(ZoneId.systemDefault()).toInstant())), Double.NaN);
                            this.setTooltipFor(n2++, this.createTooltip(string, 0L, arrayList));
                            if (!bl2) break block6;
                        }
                        long l2 = Double.valueOf(arrayList.stream().mapToDouble(Pair::getB).sum()).longValue();
                        timePeriodValues.add((TimePeriod)new FixedMillisecond(Date.from(localDate2.atStartOfDay(ZoneId.systemDefault()).toInstant())), (double)l2);
                        this.setTooltipFor(n2++, this.createTooltip(string, l2, arrayList));
                    }
                    arrayList.clear();
                }
                localDate = function.apply(localDate);
            }
            if (!bl2) continue;
        }
    }

    private boolean a(List<Pair<LocalDate, Double>> list) {
        return list.stream().filter(pair -> pair.getB() == null || ((Double)pair.getB()).equals(Double.NaN)).count() == (long)list.size();
    }
}

