/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.newchart.data;

import com.agilemind.commons.application.modules.newchart.data.AbstractSummarizeGraphicData;
import com.agilemind.commons.application.modules.newchart.data.IGraphicDescription;
import com.agilemind.commons.application.modules.newchart.data.Summarize;
import com.agilemind.commons.gui.chart.data.XYDataset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jfree.data.time.TimePeriodValues;

public class SimpleSummarizeGraphicData
extends AbstractSummarizeGraphicData<IGraphicDescription> {
    private Map<Summarize, TimePeriodValues> f = new HashMap<Summarize, TimePeriodValues>();
    private Optional<XYDataset<Number>> g = Optional.empty();
    private Map<Summarize, Map<Integer, String>> h = new HashMap<Summarize, Map<Integer, String>>();

    public SimpleSummarizeGraphicData(boolean bl2, IGraphicDescription iGraphicDescription, Summarize summarize) {
        super(bl2, iGraphicDescription, summarize);
        this.addDataListener(propertyChangeEvent -> {
            this.f.clear();
            this.h.clear();
            this.g = Optional.ofNullable((XYDataset)propertyChangeEvent.getNewValue());
        });
    }

    @Override
    public TimePeriodValues getChartData() {
        return this.f.computeIfAbsent(this.summarize, summarize -> {
            if (this.g.isPresent()) {
                XYDataset<Number> xYDataset = this.g.get();
                this.setColor(xYDataset.getColor());
                return this.createTimePeriodValues(xYDataset);
            }
            return null;
        });
    }

    @Override
    public void setChartData(XYDataset<Number> xYDataset) {
        XYDataset xYDataset2 = this.g.orElse(null);
        this.fireDataChange((XYDataset<Number>)xYDataset2, xYDataset);
    }

    @Override
    public String getTooltip(Integer n2) {
        return this.h.get((Object)this.summarize).getOrDefault(n2, "");
    }

    @Override
    public void clearData() {
        this.setChartData(null);
        this.f.clear();
        this.h.clear();
    }

    @Override
    protected void setTooltipFor(int n2, String string) {
        this.h.computeIfAbsent(this.summarize, summarize -> new HashMap()).put(n2, string);
    }

    @Override
    public void setSummarize(Summarize summarize) {
        this.summarize = summarize;
    }
}

