/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.newchart.data;

import com.agilemind.commons.application.modules.newchart.data.AbstractChartSettingsImpl;
import com.agilemind.commons.application.modules.newchart.data.IChartSettings;
import com.agilemind.commons.application.modules.newchart.data.IGraphicDataProvider;
import com.agilemind.commons.application.modules.newchart.data.IGraphicDescription;
import com.agilemind.commons.application.modules.newchart.data.SettingsFields;
import com.agilemind.commons.application.modules.newchart.data.SimpleSummarizeGraphicData;
import com.agilemind.commons.application.modules.newchart.data.Summarize;
import com.agilemind.commons.util.Pair;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class SummarizingChartSettingsImpl
extends AbstractChartSettingsImpl<SimpleSummarizeGraphicData>
implements IChartSettings {
    private Summarize h = Summarize.DAY;

    public SummarizingChartSettingsImpl(Summarize summarize, @NotNull Supplier<Pair<Date, Date>> supplier, IGraphicDataProvider iGraphicDataProvider) {
        super(supplier, iGraphicDataProvider);
        Objects.requireNonNull(summarize);
        this.h = summarize;
        this.addPropertyChangeListener(SettingsFields.SUMMARIZING, propertyChangeEvent -> {
            this.h = (Summarize)((Object)((Object)propertyChangeEvent.getNewValue()));
            this.graphicDataMap.values().forEach(simpleSummarizeGraphicData -> simpleSummarizeGraphicData.setSummarize(this.h));
            this.updateChartDataList();
        });
    }

    @Override
    @NotNull
    public Summarize getSummarizeBy() {
        return this.h;
    }

    public void setSummarizeBy(Summarize summarize) {
        if (summarize == null) {
            return;
        }
        this.b.firePropertyChange(SettingsFields.SUMMARIZING.name(), (Object)this.h, (Object)summarize);
    }

    public void addGraphic(IGraphicDescription iGraphicDescription, boolean bl2) {
        this.graphicDataMap.computeIfAbsent(iGraphicDescription, iGraphicDescription2 -> new SimpleSummarizeGraphicData(bl2, iGraphicDescription, this.getSummarizeBy())).setEnable(bl2);
    }

    @Override
    public long getZoomStepInDays() {
        return this.h.getDays();
    }

    @Override
    public Optional<Pair<? extends Number, ? extends Number>> getMinimumAndMaximumValue(Pair<Date, Date> pair) {
        return super.getMinimumAndMaximumValue(pair);
    }

    public void disableAll() {
        this.graphicDataMap.values().forEach(simpleSummarizeGraphicData -> simpleSummarizeGraphicData.setEnable(false));
    }
}

