/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.report.props.data;

import com.agilemind.commons.application.data.fields.BinaryFileValueField;
import com.agilemind.commons.application.data.fields.URLValueField;
import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.application.modules.report.util.AdvTemplateStringKey;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.Identifier;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.data.RecordBean;
import com.agilemind.commons.data.field.RecordBeanField;
import com.agilemind.commons.data.field.StringValueField;
import com.agilemind.commons.gui.util.ImageFactory;
import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.Resource;
import com.agilemind.commons.util.StringURLUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLFactory;
import com.agilemind.commons.util.UnicodeURLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class PersonInformation
extends RecordBean
implements IPersonInformation {
    public static final StringValueField<PersonInformation> NAME_FIELD;
    public static final StringValueField<PersonInformation> ADDRES_FIELD;
    public static final URLValueField<PersonInformation> WEBSITE_FIELD;
    public static final StringValueField<PersonInformation> EMAIL_FIELD;
    public static final BinaryFileValueField<PersonInformation> LOGO_FIELD;
    public final String DEFAULT_CUSTOMER_NAME;
    public final String DEFAULT_CUSTOMER_EMAIL;
    public final String DEFAULT_CUSTOMER_WEBSITE;
    private static final String[] i;

    public PersonInformation(Database database, Identifier identifier) {
        super(database, identifier);
        this.DEFAULT_CUSTOMER_NAME = new AdvTemplateStringKey(i[7]).getString();
        this.DEFAULT_CUSTOMER_EMAIL = new AdvTemplateStringKey(i[8]).getString();
        this.DEFAULT_CUSTOMER_WEBSITE = new AdvTemplateStringKey(i[9]).getString();
    }

    public PersonInformation(Record record) {
        super(record);
        this.DEFAULT_CUSTOMER_NAME = new AdvTemplateStringKey(i[6]).getString();
        this.DEFAULT_CUSTOMER_EMAIL = new AdvTemplateStringKey(i[4]).getString();
        this.DEFAULT_CUSTOMER_WEBSITE = new AdvTemplateStringKey(i[5]).getString();
    }

    public static PersonInformation createMergedFakeCustomerInformation(IPersonInformation iPersonInformation) {
        return PersonInformation.mergePersonInformation(iPersonInformation, PersonInformation.createFakeCustomerInformation());
    }

    public static PersonInformation createMergedFakeCompanyInformation(IPersonInformation iPersonInformation) {
        return PersonInformation.mergePersonInformation(iPersonInformation, PersonInformation.createFakeCompanyInformation());
    }

    public static PersonInformation mergePersonInformation(IPersonInformation iPersonInformation, PersonInformation personInformation) {
        if (iPersonInformation != null) {
            if (!StringUtil.isEmpty((String)iPersonInformation.getName())) {
                personInformation.setName(iPersonInformation.getName());
            }
            if (!StringUtil.isEmpty((String)iPersonInformation.getEmail())) {
                personInformation.setEmail(iPersonInformation.getEmail());
            }
            if (!UnicodeURLUtil.isEmpty((UnicodeURL)iPersonInformation.getWebsite())) {
                personInformation.setWebsite(iPersonInformation.getWebsite());
            }
            if (!StringUtil.isEmpty((String)iPersonInformation.getAddress())) {
                personInformation.setAddress(iPersonInformation.getAddress());
            }
            if (!StringUtil.isEmpty((Object)iPersonInformation.getLogo())) {
                personInformation.setLogo(iPersonInformation.getLogo());
            }
        }
        return personInformation;
    }

    public static PersonInformation createFakeCustomerInformation() {
        PersonInformation personInformation = new PersonInformation(null);
        PersonInformation.setDefaultCustomerInformation(personInformation);
        return personInformation;
    }

    public static void setDefaultCustomerInformation(PersonInformation personInformation) {
        personInformation.setAddress(new AdvTemplateStringKey(i[10]).getString());
        personInformation.setEmail(personInformation.DEFAULT_CUSTOMER_EMAIL);
        personInformation.setLogo(null);
        personInformation.setName(personInformation.DEFAULT_CUSTOMER_NAME);
        try {
            personInformation.setWebsite(UnicodeURLFactory.getInstance().createUnicodeURL(personInformation.DEFAULT_CUSTOMER_WEBSITE));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static PersonInformation createFakeCompanyInformation() {
        PersonInformation personInformation = new PersonInformation(null);
        personInformation.setAddress(new AdvTemplateStringKey(i[1]).getString());
        personInformation.setEmail(new AdvTemplateStringKey(i[0]).getString());
        personInformation.setLogo(null);
        personInformation.setName(new AdvTemplateStringKey(i[2]).getString());
        try {
            personInformation.setWebsite(UnicodeURLFactory.getInstance().createUnicodeURL(new AdvTemplateStringKey(i[3]).getString()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return personInformation;
    }

    @Override
    public String getName() {
        return (String)this.get((RecordBeanField)NAME_FIELD);
    }

    @Override
    public String getFirstName() {
        return StringUtil.NameUtil.getFirstName((String)this.getName());
    }

    public void setName(String string) {
        this.set((RecordBeanField)NAME_FIELD, string);
    }

    @Override
    public String getAddress() {
        return (String)this.get((RecordBeanField)ADDRES_FIELD);
    }

    public void setAddress(String string) {
        this.set((RecordBeanField)ADDRES_FIELD, string);
    }

    @Override
    public UnicodeURL getWebsite() {
        return (UnicodeURL)this.get((RecordBeanField)WEBSITE_FIELD);
    }

    public void setWebsite(UnicodeURL unicodeURL) {
        this.set((RecordBeanField)WEBSITE_FIELD, unicodeURL);
    }

    @Override
    public String getEmail() {
        return (String)this.get((RecordBeanField)EMAIL_FIELD);
    }

    public void setEmail(String string) {
        this.set((RecordBeanField)EMAIL_FIELD, string);
    }

    @Override
    public BinaryFile getLogo() {
        return (BinaryFile)this.get((RecordBeanField)LOGO_FIELD);
    }

    public void setLogo(BinaryFile binaryFile) {
        this.set((RecordBeanField)LOGO_FIELD, binaryFile);
    }

    public void setDefaultSPSLogo() throws IOException, InterruptedException {
        Resource resource = ImageFactory.getResource((String)i[12]);
        this.set((RecordBeanField)LOGO_FIELD, new BinaryFile(i[11], IOUtils.readBytes((InputStream)resource.getInputStream())));
    }

    public boolean isFullyAndProperlyFilledCompanyInfo() {
        return !StringUtil.isEmpty((String)this.getName()) && !StringUtil.isEmpty((String)this.getEmail()) && StringUtil.isValidEmail((String)this.getEmail()) && this.getWebsite() != null && StringURLUtil.isValideHttpAddress((String)this.getWebsite().toUnicodeString()) && this.getLogo() != null;
    }

    public boolean isFullyAndProperlyFilledCustomerInfo() {
        return !StringUtil.isEmpty((String)this.getName()) && !this.DEFAULT_CUSTOMER_NAME.equals(this.getName()) && !StringUtil.isEmpty((String)this.getEmail()) && !this.DEFAULT_CUSTOMER_EMAIL.equals(this.getEmail()) && StringUtil.isValidEmail((String)this.getEmail()) && this.getWebsite() != null && !this.DEFAULT_CUSTOMER_WEBSITE.equals(this.getWebsite().toUnicodeString()) && StringURLUtil.isValideWildcardHttpAddress((String)this.getWebsite().toUnicodeString());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "*'<j\u000e'1\u0018t\t&f5\u007f\t(==n*$)8vA=-)n";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block30: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block29: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block29;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block30;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 73;
                                break;
                            }
                            case 1: {
                                n9 = 72;
                                break;
                            }
                            case 2: {
                                n9 = 81;
                                break;
                            }
                            case 3: {
                                n9 = 26;
                                break;
                            }
                            default: {
                                n9 = 111;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "*'<j\u000e'1\u0018t\t&f5\u007f\t(==n.-,#\u007f\u001c:f%\u007f\u0017=";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "*'<j\u000e'1\u0018t\t&f5\u007f\t(==n!(%44\u001b,0%";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "*'<j\u000e'1\u0018t\t&f5\u007f\t(==n8,*\"s\u001b,f%\u007f\u0017=";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\f%0s\u0003g<4b\u001b";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\u001e-3i\u0006=-\u007fn\n1<";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\u0007)<\u007fA=-)n";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\u0007)<\u007fA=-)n";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\f%0s\u0003g<4b\u001b";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\u001e-3i\u0006=-\u007fn\n1<";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "*=\"n\u0000$-#S\u0001/'\u007f~\n/)$v\u001b\b,5h\n:;\u007fn\n1<";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = ":->7\u001f&?4h\u001c<!%\u007fA9&6";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "f+>w\u0002&&\"5\u001c,'|j\u0000>-#i\u001a <44\u001f'/";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = ">-3i\u0006=-";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "')<\u007f";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = ",%0s\u0003";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "(,5h\n:;";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "%'6u";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        i = stringArray3;
        NAME_FIELD = new StringValueField(i[14], PersonInformation.class);
        ADDRES_FIELD = new StringValueField(i[16], PersonInformation.class);
        WEBSITE_FIELD = new URLValueField<PersonInformation>(i[13], PersonInformation.class);
        EMAIL_FIELD = new StringValueField(i[15], PersonInformation.class);
        LOGO_FIELD = new BinaryFileValueField<PersonInformation>(i[17], PersonInformation.class);
    }
}

