/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.scheduler.data;

import com.agilemind.commons.application.data.fields.ProjectFileValueField;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskResult;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskState;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.Identifier;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.data.RecordMap;
import com.agilemind.commons.data.field.ModifiableField;
import com.agilemind.commons.data.field.RecordBeanField;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ScheduledProjectTasksMap
extends RecordMap<ProjectLocationInfo, ScheduledTaskResult> {
    private static final ProjectFileValueField a;
    private static final ModifiableField b;
    private static final String[] k;

    public ScheduledProjectTasksMap(Record record) {
        super(record, (RecordBeanField)a, (RecordBeanField)b);
    }

    public ScheduledProjectTasksMap(Database database, Identifier identifier) {
        super(database, identifier, (RecordBeanField)a, (RecordBeanField)b);
    }

    public List<ProjectLocationInfo> getProjectFiles() {
        return this.entrySet().stream().map(Map.Entry::getKey).sorted((projectLocationInfo, projectLocationInfo2) -> projectLocationInfo.getProjectName().compareTo(projectLocationInfo2.getProjectName())).collect(Collectors.toList());
    }

    public void setProjectFiles(List<ProjectLocationInfo> list) {
        this.getProjectFiles().stream().filter(projectLocationInfo -> !list.contains(projectLocationInfo)).forEach(arg_0 -> ((ScheduledProjectTasksMap)this).remove(arg_0));
        list.stream().filter(projectLocationInfo -> !this.getProjectFiles().contains(projectLocationInfo)).forEach(projectLocationInfo -> {
            ScheduledTaskResult cfr_ignored_0 = (ScheduledTaskResult)((Object)((Object)this.put(projectLocationInfo, (Object)new ScheduledTaskResult((Record)this))));
        });
    }

    public ScheduledTaskState getState() {
        List list = this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        if (list.stream().allMatch(scheduledTaskResult -> scheduledTaskResult.getState() == ScheduledTaskState.SUCCESS)) {
            return ScheduledTaskState.SUCCESS;
        }
        if (list.stream().anyMatch(scheduledTaskResult -> scheduledTaskResult.getState() == ScheduledTaskState.RUNNING)) {
            return ScheduledTaskState.RUNNING;
        }
        if (list.stream().anyMatch(scheduledTaskResult -> scheduledTaskResult.getState() == ScheduledTaskState.STOPPED)) {
            return ScheduledTaskState.STOPPED;
        }
        if (list.stream().anyMatch(scheduledTaskResult -> scheduledTaskResult.getState() == ScheduledTaskState.FAILED)) {
            return ScheduledTaskState.FAILED;
        }
        return ScheduledTaskState.NEVER_RUN;
    }

    public void setStateForAll(ScheduledTaskState scheduledTaskState) {
        this.entrySet().forEach(entry -> ((ScheduledTaskResult)((Object)((Object)entry.getValue()))).setState(scheduledTaskState));
    }

    public void setState(ProjectLocationInfo projectLocationInfo, ScheduledTaskState scheduledTaskState) {
        ScheduledTaskResult scheduledTaskResult = (ScheduledTaskResult)((Object)this.get(projectLocationInfo));
        if (scheduledTaskResult != null) {
            scheduledTaskResult.setState(scheduledTaskState);
        }
    }

    public Date getLastFinishTime() {
        return this.entrySet().stream().map(entry -> ((ScheduledTaskResult)((Object)((Object)entry.getValue()))).getFinishTime()).filter(Objects::nonNull).sorted((date, date2) -> date2.compareTo((Date)date)).findFirst().orElse(null);
    }

    public void setFinishTimeForAll(Date date) {
        this.entrySet().forEach(entry -> ((ScheduledTaskResult)((Object)((Object)entry.getValue()))).setFinishTime(date));
    }

    public void setFinishTime(ProjectLocationInfo projectLocationInfo, Date date) {
        ScheduledTaskResult scheduledTaskResult = (ScheduledTaskResult)((Object)this.get(projectLocationInfo));
        if (scheduledTaskResult != null) {
            scheduledTaskResult.setFinishTime(date);
        }
    }

    public List<String> getLogFiles() {
        return this.entrySet().stream().map(Map.Entry::getValue).map(ScheduledTaskResult::getLogFileName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void setLogFile(ProjectLocationInfo projectLocationInfo, String string) {
        ScheduledTaskResult scheduledTaskResult = (ScheduledTaskResult)((Object)this.get(projectLocationInfo));
        if (scheduledTaskResult != null) {
            scheduledTaskResult.setLogFileName(string);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ".\u0012C\ra(\u001dN\fQ<\u0002@:`.\u0004G\u001c";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 93;
                                break;
                            }
                            case 1: {
                                n9 = 113;
                                break;
                            }
                            case 2: {
                                n9 = 43;
                                break;
                            }
                            case 3: {
                                n9 = 104;
                                break;
                            }
                            default: {
                                n9 = 5;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "-\u0003D\u0002`>\u0005g\u0007f<\u0005B\u0007k";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        k = stringArray3;
        a = new ProjectFileValueField<ScheduledProjectTasksMap>(k[1], ScheduledProjectTasksMap.class);
        b = new ModifiableField(k[0], ScheduledProjectTasksMap.class, ScheduledTaskResult.class);
    }
}

