/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.scheduler.util;

import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskFrequency;
import com.agilemind.commons.application.modules.scheduler.data.iterators.DailyIterator;
import com.agilemind.commons.application.modules.scheduler.data.iterators.MonthlyIterator;
import com.agilemind.commons.application.modules.scheduler.data.iterators.WeeklyIterator;
import com.agilemind.commons.application.modules.scheduler.util.SchedulerStringKey;
import com.agilemind.commons.mvc.controllers.Controller;
import java.util.Calendar;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class ScheduledTaskDateUtil {
    private ScheduledTaskDateUtil() {
    }

    public static Date getPlannedRunTime(IScheduledTaskSettings iScheduledTaskSettings) {
        return ScheduledTaskDateUtil.getNextRun(iScheduledTaskSettings, new Date());
    }

    public static Date getScheduledRunTime(IScheduledTaskSettings iScheduledTaskSettings) {
        IScheduledTaskSettings iScheduledTaskSettings2 = iScheduledTaskSettings;
        Date date = iScheduledTaskSettings.getFinishTime() == null ? iScheduledTaskSettings.getStartDate() : iScheduledTaskSettings.getFinishTime();
        return ScheduledTaskDateUtil.getNextRun(iScheduledTaskSettings2, date);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date getNextRun(IScheduledTaskSettings iScheduledTaskSettings, Date date) {
        Date date2;
        boolean bl2 = SchedulerStringKey.b;
        ScheduledTaskFrequency scheduledTaskFrequency = iScheduledTaskSettings.getFrequencyType();
        Date date3 = ScheduledTaskDateUtil.a(iScheduledTaskSettings);
        switch (scheduledTaskFrequency) {
            case ONCE: {
                date2 = iScheduledTaskSettings.getStartDate();
                if (!bl2) break;
                Controller.g = !Controller.g;
            }
            case DAILY: {
                date2 = new DailyIterator(date3, iScheduledTaskSettings.getFinishTime(), iScheduledTaskSettings.getSelectedCalendarFields().toArray(new Integer[iScheduledTaskSettings.getSelectedCalendarFields().size()]), iScheduledTaskSettings.getOffset(), iScheduledTaskSettings.isRunMissedOnStart()).getPlannedStartTime(date);
                if (!bl2) break;
            }
            case MONTHLY: {
                date2 = new MonthlyIterator(date3, iScheduledTaskSettings.getFinishTime(), iScheduledTaskSettings.getSelectedCalendarFields().toArray(new Integer[iScheduledTaskSettings.getSelectedCalendarFields().size()]), iScheduledTaskSettings.getOffset(), iScheduledTaskSettings.isRunMissedOnStart()).getPlannedStartTime(date);
                if (!bl2) break;
            }
            case WEEKLY: {
                date2 = new WeeklyIterator(date3, iScheduledTaskSettings.getFinishTime(), iScheduledTaskSettings.getSelectedCalendarFields().toArray(new Integer[iScheduledTaskSettings.getSelectedCalendarFields().size()]), iScheduledTaskSettings.getOffset(), iScheduledTaskSettings.isRunMissedOnStart()).getPlannedStartTime(date);
                if (!bl2) break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return date2;
    }

    @NotNull
    private static Date a(IScheduledTaskSettings iScheduledTaskSettings) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = calendar;
        Date date = iScheduledTaskSettings.getStartDate() == null ? new Date() : iScheduledTaskSettings.getStartDate();
        calendar2.setTime(date);
        return calendar.getTime();
    }
}

