/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.scheduler.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.commands.Command;
import com.agilemind.commons.application.modules.commands.SchedulerCommand;
import com.agilemind.commons.application.modules.license.LicenseType;
import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskFrequency;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskSettings;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskSettingsList;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskState;
import com.agilemind.commons.application.modules.scheduler.util.ScheduledTaskDateUtil;
import com.agilemind.commons.application.modules.scheduler.util.SchedulerStringKey;
import com.agilemind.commons.application.util.settings.LicenseTypeUtils;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.DateUtil;
import com.agilemind.commons.util.Util;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Scheduler {
    private static final Scheduler a;
    private Consumer<IScheduledTaskSettings> b;
    private boolean c;
    private Timer d;
    private static final String[] e;

    private Scheduler() {
    }

    public void setShowNotificationConsumer(Consumer<IScheduledTaskSettings> consumer) {
        this.b = consumer;
    }

    public static Scheduler getInstance() {
        return a;
    }

    public synchronized void init(TimerTask timerTask, TimerTask timerTask2) {
        if (this.d == null) {
            this.d = new Timer(e[0]);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int n2 = 60 - calendar.get(13);
            this.d.scheduleAtFixedRate(timerTask2, n2 * 1000, 60000L);
            int n3 = (90 - calendar.get(13)) % 60;
            this.d.scheduleAtFixedRate(timerTask, n3 * 1000, 60000L);
        }
    }

    public synchronized void processNotification(ApplicationControllerImpl applicationControllerImpl, Consumer<ScheduledTaskSettings> consumer) {
        ScheduledTaskSettingsList scheduledTaskSettingsList = applicationControllerImpl.getParameters().getScheduledTasksList();
        this.b(scheduledTaskSettingsList).forEach(consumer::accept);
    }

    public synchronized void processTasks(ApplicationControllerImpl applicationControllerImpl) {
        List<Command> list;
        if (this.c) {
            return;
        }
        ScheduledTaskSettingsList scheduledTaskSettingsList = applicationControllerImpl.getParameters().getScheduledTasksList();
        List<ScheduledTaskSettings> list2 = this.a(scheduledTaskSettingsList);
        if (!list2.isEmpty() && applicationControllerImpl.getCommandManager().canProcess() && !(list = this.a(applicationControllerImpl, list2)).isEmpty()) {
            applicationControllerImpl.addCommands(list);
        }
    }

    private List<ScheduledTaskSettings> a(ScheduledTaskSettingsList scheduledTaskSettingsList) {
        return scheduledTaskSettingsList.stream().sorted((scheduledTaskSettings, scheduledTaskSettings2) -> ScheduledTaskDateUtil.getScheduledRunTime(scheduledTaskSettings).compareTo(ScheduledTaskDateUtil.getScheduledRunTime(scheduledTaskSettings2))).filter(Scheduler::b).collect(Collectors.toList());
    }

    private List<ScheduledTaskSettings> b(ScheduledTaskSettingsList scheduledTaskSettingsList) {
        return scheduledTaskSettingsList.stream().sorted((scheduledTaskSettings, scheduledTaskSettings2) -> ScheduledTaskDateUtil.getScheduledRunTime(scheduledTaskSettings).compareTo(ScheduledTaskDateUtil.getScheduledRunTime(scheduledTaskSettings2))).filter(Scheduler::a).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Command> a(ApplicationControllerImpl applicationControllerImpl, List<ScheduledTaskSettings> list) {
        boolean bl2 = SchedulerStringKey.b;
        this.c = true;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        try {
            boolean bl3 = LicenseTypeUtils.isAllowed(applicationControllerImpl::getLicenseType, LicenseType.SCHEDULER, applicationControllerImpl);
            for (ScheduledTaskSettings scheduledTaskSettings : list) {
                block9: {
                    block8: {
                        if (!bl3 || !Scheduler.isAllowed(applicationControllerImpl, scheduledTaskSettings)) break block8;
                        scheduledTaskSettings.setStateForAll(ScheduledTaskState.RUNNING);
                        for (ProjectLocationInfo projectLocationInfo : scheduledTaskSettings.getProjectFiles()) {
                            linkedList.add(new SchedulerCommand(projectLocationInfo, scheduledTaskSettings, this.b));
                            if (!bl2) continue;
                        }
                        if (!bl2) break block9;
                    }
                    scheduledTaskSettings.setFinishTimeForAll(new Date());
                    scheduledTaskSettings.setStateForAll(ScheduledTaskState.FAILED);
                }
                if (!bl2) continue;
                break;
            }
        }
        finally {
            this.c = false;
        }
        return linkedList;
    }

    public static boolean isAllowed(Controller controller, ScheduledTaskSettings scheduledTaskSettings) {
        boolean bl2 = SchedulerStringKey.b;
        boolean bl3 = !scheduledTaskSettings.getCommand().equals(e[1]) && !scheduledTaskSettings.getCommand().equals(e[2]) && !scheduledTaskSettings.getCommand().equals(e[3]) || LicenseTypeUtils.isAllowed(() -> ((ApplicationControllerImpl)controller.getApplicationController()).getLicenseType(), LicenseType.PUBLISH_REPORT, controller);
        if (Controller.g) {
            SchedulerStringKey.b = !bl2;
        }
        return bl3;
    }

    private static boolean a(ScheduledTaskSettings scheduledTaskSettings) {
        return scheduledTaskSettings.isEnable() && scheduledTaskSettings.getState() != ScheduledTaskState.RUNNING && Scheduler.b((IScheduledTaskSettings)scheduledTaskSettings);
    }

    private static boolean b(ScheduledTaskSettings scheduledTaskSettings) {
        return scheduledTaskSettings.isEnable() && scheduledTaskSettings.getState() != ScheduledTaskState.RUNNING && Scheduler.a((IScheduledTaskSettings)scheduledTaskSettings);
    }

    private static boolean a(IScheduledTaskSettings iScheduledTaskSettings) {
        return (iScheduledTaskSettings.getFrequencyType() != ScheduledTaskFrequency.ONCE || iScheduledTaskSettings.getFinishTime() == null || iScheduledTaskSettings.getState() == ScheduledTaskState.NEVER_RUN) && DateUtil.compareDates((Date)new Date(), (Date)ScheduledTaskDateUtil.getPlannedRunTime(iScheduledTaskSettings), (int)12) >= 0;
    }

    private static boolean b(IScheduledTaskSettings iScheduledTaskSettings) {
        return iScheduledTaskSettings.isShowPreRunNotification() && (iScheduledTaskSettings.getFrequencyType() != ScheduledTaskFrequency.ONCE || iScheduledTaskSettings.getFinishTime() == null || iScheduledTaskSettings.getState() == ScheduledTaskState.NEVER_RUN) && Scheduler.c(iScheduledTaskSettings);
    }

    private static boolean c(IScheduledTaskSettings iScheduledTaskSettings) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ScheduledTaskDateUtil.getPlannedRunTime(iScheduledTaskSettings));
        calendar.set(14, 0);
        calendar.set(13, 0);
        long l2 = calendar.getTimeInMillis();
        return Util.isBigEndian((long)(l2 - 90000L), (long)System.currentTimeMillis(), (long)(l2 - 30000L));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0011Y2\u001a07V?\r\u000b6S7\u001a&";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 66;
                                break;
                            }
                            case 1: {
                                n9 = 58;
                                break;
                            }
                            case 2: {
                                n9 = 90;
                                break;
                            }
                            case 3: {
                                n9 = 127;
                                break;
                            }
                            default: {
                                n9 = 84;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "0_*\u0010&6";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "1S.\u001a\u0006'J5\r ";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "2[=\u001a\u0006'J5\r ";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        e = stringArray3;
        a = new Scheduler();
    }
}

