/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.storage.chooser.gui;

import com.agilemind.commons.application.modules.storage.chooser.gui.StorageEntityPresentation;
import com.agilemind.commons.application.modules.storage.chooser.gui.StorageEntityPresentationChooser;
import com.agilemind.commons.application.modules.storage.chooser.gui.StoragePresentation;
import com.agilemind.commons.application.modules.storage.chooser.gui.f;
import com.agilemind.commons.application.modules.storage.chooser.gui.s;
import com.agilemind.commons.application.modules.storage.chooser.gui.t;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.UIManager;

public abstract class StorageEntitySystemView {
    private StoragePresentation a;

    public static StorageEntitySystemView getFileSystemView(StoragePresentation storagePresentation) {
        return new s(storagePresentation);
    }

    protected StorageEntitySystemView(StoragePresentation storagePresentation) {
        this.a = storagePresentation;
        WeakReference<StorageEntitySystemView> weakReference = new WeakReference<StorageEntitySystemView>(this);
        UIManager.addPropertyChangeListener(new t(this, weakReference));
    }

    public boolean isRoot(StorageEntityPresentation storageEntityPresentation) {
        StorageEntityPresentation[] storageEntityPresentationArray;
        int n2 = StorageEntityPresentationChooser.w;
        if (storageEntityPresentation == null || !storageEntityPresentation.isAbsolute()) {
            return false;
        }
        for (StorageEntityPresentation storageEntityPresentation2 : storageEntityPresentationArray = this.getRoots()) {
            if (!storageEntityPresentation2.equals(storageEntityPresentation)) continue;
            return true;
        }
        return false;
    }

    public Boolean isTraversable(StorageEntityPresentation storageEntityPresentation) {
        return storageEntityPresentation.isDirectory();
    }

    public String getSystemDisplayName(StorageEntityPresentation storageEntityPresentation) {
        if (storageEntityPresentation == null) {
            return null;
        }
        return storageEntityPresentation.getName();
    }

    public boolean isParent(StorageEntityPresentation storageEntityPresentation, StorageEntityPresentation storageEntityPresentation2) {
        if (storageEntityPresentation == null || storageEntityPresentation2 == null) {
            return false;
        }
        return storageEntityPresentation.equals(storageEntityPresentation2.getParentFile());
    }

    public StorageEntityPresentation getChild(StorageEntityPresentation storageEntityPresentation, String string) {
        StorageEntityPresentation[] storageEntityPresentationArray;
        int n2 = StorageEntityPresentationChooser.w;
        for (StorageEntityPresentation storageEntityPresentation2 : storageEntityPresentationArray = this.getFiles(storageEntityPresentation, false)) {
            if (!storageEntityPresentation2.getName().equals(string)) continue;
            return storageEntityPresentation2;
        }
        return this.createFileObject(storageEntityPresentation, string);
    }

    public boolean isFileSystem(StorageEntityPresentation storageEntityPresentation) {
        return true;
    }

    public abstract StorageEntityPresentation createNewFolder(StorageEntityPresentation var1) throws IOException;

    public boolean isHiddenFile(StorageEntityPresentation storageEntityPresentation) {
        return false;
    }

    public boolean isFileSystemRoot(StorageEntityPresentation storageEntityPresentation) {
        return storageEntityPresentation.getParentFile() == null;
    }

    public abstract boolean isDrive(StorageEntityPresentation var1);

    public boolean isFloppyDrive(StorageEntityPresentation storageEntityPresentation) {
        return false;
    }

    public boolean isComputerNode(StorageEntityPresentation storageEntityPresentation) {
        return false;
    }

    public StorageEntityPresentation[] getRoots() {
        int n2 = StorageEntityPresentationChooser.w;
        String[] stringArray = this.a.getRootNames();
        StorageEntityPresentation[] storageEntityPresentationArray = new StorageEntityPresentation[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            storageEntityPresentationArray[i2] = this.createFileObject(stringArray[i2]);
            if (n2 == 0) continue;
        }
        return storageEntityPresentationArray;
    }

    public StorageEntityPresentation getHomeDirectory() {
        return this.createFileObject(this.a.getHomeDirectoryName());
    }

    public StorageEntityPresentation getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    public StorageEntityPresentation createFileObject(StorageEntityPresentation storageEntityPresentation, String string) {
        if (storageEntityPresentation == null) {
            return new StorageEntityPresentation(this.a, string);
        }
        return new StorageEntityPresentation(this.a, storageEntityPresentation, string);
    }

    public StorageEntityPresentation createFileObject(String string) {
        StorageEntityPresentation storageEntityPresentation = new StorageEntityPresentation(this.a, string);
        if (this.isFileSystemRoot(storageEntityPresentation)) {
            storageEntityPresentation = this.createFileSystemRoot(storageEntityPresentation);
        }
        return storageEntityPresentation;
    }

    public StorageEntityPresentation[] getFiles(StorageEntityPresentation storageEntityPresentation, boolean bl2) {
        int n2 = StorageEntityPresentationChooser.w;
        ArrayList<StorageEntityPresentation> arrayList = new ArrayList<StorageEntityPresentation>();
        StorageEntityPresentation[] storageEntityPresentationArray = storageEntityPresentation.listFiles();
        if (storageEntityPresentationArray == null) {
            return new StorageEntityPresentation[0];
        }
        for (StorageEntityPresentation storageEntityPresentation2 : storageEntityPresentationArray) {
            if (Thread.currentThread().isInterrupted() && n2 == 0) break;
            if (bl2 && this.isHiddenFile(storageEntityPresentation2)) continue;
            arrayList.add(storageEntityPresentation2);
            if (n2 == 0) continue;
        }
        return arrayList.toArray(new StorageEntityPresentation[arrayList.size()]);
    }

    public StorageEntityPresentation getParentDirectory(StorageEntityPresentation storageEntityPresentation) {
        if (storageEntityPresentation == null || !storageEntityPresentation.exists()) {
            return null;
        }
        StorageEntityPresentation storageEntityPresentation2 = storageEntityPresentation.getParentFile();
        if (storageEntityPresentation2 == null) {
            return null;
        }
        if (this.isFileSystem(storageEntityPresentation2)) {
            StorageEntityPresentation storageEntityPresentation3;
            StorageEntityPresentation storageEntityPresentation4 = storageEntityPresentation2;
            if (!(storageEntityPresentation4.exists() || (storageEntityPresentation3 = storageEntityPresentation2.getParentFile()) != null && this.isFileSystem(storageEntityPresentation3))) {
                storageEntityPresentation4 = this.createFileSystemRoot(storageEntityPresentation4);
            }
            return storageEntityPresentation4;
        }
        return storageEntityPresentation2;
    }

    protected StorageEntityPresentation createFileSystemRoot(StorageEntityPresentation storageEntityPresentation) {
        return new f(this.a, storageEntityPresentation);
    }
}

