/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.storage.dropbox;

import com.agilemind.commons.application.data.storage.account.api.StorageAccountInfo;
import com.agilemind.commons.application.modules.storage.dropbox.DropboxExceptionMapper;
import com.agilemind.commons.application.modules.storage.dropbox.data.DropboxAccountInfo;
import com.agilemind.commons.application.modules.storage.dropbox.data.DropboxFile;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxFileNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxFolderNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.StorageQuotaReachedException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.WrongAuthorizationException;
import com.agilemind.commons.application.modules.storage.project.ProjectStorage;
import com.agilemind.commons.mvc.controllers.Controller;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.DeleteErrorException;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.GetMetadataErrorException;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.files.WriteError;
import com.dropbox.core.v2.files.WriteMode;
import com.dropbox.core.v2.sharing.CreateSharedLinkWithSettingsErrorException;
import com.dropbox.core.v2.sharing.ListSharedLinksErrorException;
import com.dropbox.core.v2.sharing.ListSharedLinksResult;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.dropbox.core.v2.sharing.SharedLinkSettings;
import com.dropbox.core.v2.users.FullAccount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class DropboxProjectStorage
implements ProjectStorage<DropboxFile> {
    public static final String ROOT_FOLDER = "";
    private final StorageAccountInfo a;
    private static final String[] b;

    public DropboxProjectStorage(StorageAccountInfo storageAccountInfo) {
        this.a = storageAccountInfo;
    }

    private DbxClientV2 a(StorageAccountInfo storageAccountInfo) throws WrongAuthorizationException {
        if (storageAccountInfo == null) {
            throw new WrongAuthorizationException();
        }
        return DropboxProjectStorage.b(storageAccountInfo.getAccessToken());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileChanged(DropboxFile dropboxFile) throws IOException, InterruptedException {
        int n2 = DropboxExceptionMapper.c;
        try {
            Metadata metadata = this.a(this.a).files().getMetadata(dropboxFile.getPath());
            if (!(metadata instanceof FileMetadata)) {
                throw new IllegalArgumentException(b[2]);
            }
            FileMetadata fileMetadata = (FileMetadata)metadata;
            boolean bl2 = !fileMetadata.getRev().equals(dropboxFile.getRevision());
            if (!Controller.g) return bl2;
            DropboxExceptionMapper.c = ++n2;
            return bl2;
        }
        catch (GetMetadataErrorException getMetadataErrorException) {
            if (!getMetadataErrorException.errorValue.getPathValue().isNotFound()) throw this.a((DbxException)((Object)getMetadataErrorException));
            throw new DropboxFileNotFoundException(dropboxFile.getPath());
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    @Override
    public DropboxFile get(String string) throws IOException {
        try {
            Metadata metadata = this.a(this.a).files().getMetadata(string);
            return this.a(metadata);
        }
        catch (GetMetadataErrorException getMetadataErrorException) {
            if (getMetadataErrorException.errorValue.getPathValue().isNotFound()) {
                throw new FileNotFoundException(string);
            }
            throw this.a((DbxException)((Object)getMetadataErrorException));
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    @Override
    public List<DropboxFile> list() throws IOException {
        return this.list(ROOT_FOLDER);
    }

    @Override
    public List<DropboxFile> list(String string) throws IOException {
        try {
            return this.a(this.a).files().listFolder(string).getEntries().stream().map(this::a).collect(Collectors.toList());
        }
        catch (ListFolderErrorException listFolderErrorException) {
            if (listFolderErrorException.errorValue.getPathValue().isNotFound()) {
                throw new DropboxFolderNotFoundException(string);
            }
            throw this.a((DbxException)((Object)listFolderErrorException));
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DropboxFile downloadFile(String string, File file) throws IOException {
        int n2 = DropboxExceptionMapper.c;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                FileMetadata fileMetadata = (FileMetadata)this.a(this.a).files().download(string).download((OutputStream)fileOutputStream);
                DropboxFile dropboxFile = this.a(fileMetadata);
                return dropboxFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                block19: {
                    if (fileOutputStream != null) {
                        if (throwable != null) {
                            try {
                                fileOutputStream.close();
                                break block19;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                if (n2 == 0) break block19;
                            }
                        }
                        fileOutputStream.close();
                    }
                }
            }
        }
        catch (DownloadErrorException downloadErrorException) {
            if (!downloadErrorException.errorValue.getPathValue().isNotFound()) throw this.a((DbxException)((Object)downloadErrorException));
            throw new DropboxFileNotFoundException(string);
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DropboxFile uploadFile(String string, File file) throws IOException, InterruptedException {
        int n2 = DropboxExceptionMapper.c;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileMetadata fileMetadata = (FileMetadata)this.a(this.a).files().uploadBuilder(string).withMode(WriteMode.OVERWRITE).uploadAndFinish((InputStream)fileInputStream);
                DropboxFile dropboxFile = this.a(fileMetadata);
                return dropboxFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                block19: {
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                                break block19;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                if (n2 == 0) break block19;
                            }
                        }
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (UploadErrorException uploadErrorException) {
            if (uploadErrorException.errorValue.getPathValue().getReason() != WriteError.INSUFFICIENT_SPACE) throw this.a((DbxException)((Object)uploadErrorException));
            throw new StorageQuotaReachedException();
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    @Override
    public DropboxFile updateFile(DropboxFile dropboxFile, File file) throws IOException, InterruptedException {
        return this.uploadFile(dropboxFile.getPath(), file);
    }

    @Override
    public DropboxFile createFolder(String string) throws IOException {
        try {
            FolderMetadata folderMetadata = this.a(this.a).files().createFolder(string);
            return this.a(folderMetadata);
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    @Override
    public boolean delete(DropboxFile dropboxFile) throws IOException {
        try {
            this.a(this.a).files().delete(dropboxFile.getPath());
            return true;
        }
        catch (DeleteErrorException deleteErrorException) {
            if (deleteErrorException.errorValue.getPathLookupValue().isNotFound()) {
                throw new DropboxFileNotFoundException(dropboxFile.getPath());
            }
            throw this.a((DbxException)((Object)deleteErrorException));
        }
        catch (DbxException dbxException) {
            throw this.a(dbxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createSharedLink(String string) throws IOException {
        String string2;
        block10: {
            boolean bl2;
            int n2 = DropboxExceptionMapper.c;
            try {
                ListSharedLinksResult listSharedLinksResult = this.a(this.a).sharing().listSharedLinksBuilder().withPath(string).start();
                List list = listSharedLinksResult.getLinks();
                if (!list.isEmpty()) {
                    return ((SharedLinkMetadata)list.get(0)).getUrl();
                }
                SharedLinkSettings sharedLinkSettings = SharedLinkSettings.newBuilder().withRequestedVisibility(RequestedVisibility.PUBLIC).build();
                SharedLinkMetadata sharedLinkMetadata = this.a(this.a).sharing().createSharedLinkWithSettings(string, sharedLinkSettings);
                string2 = sharedLinkMetadata.getUrl();
                if (n2 == 0) break block10;
                bl2 = !Controller.g;
            }
            catch (CreateSharedLinkWithSettingsErrorException createSharedLinkWithSettingsErrorException) {
                if (createSharedLinkWithSettingsErrorException.errorValue.getPathValue().isNotFound()) {
                    throw new DropboxFileNotFoundException(string);
                }
                throw this.a((DbxException)((Object)createSharedLinkWithSettingsErrorException));
            }
            catch (ListSharedLinksErrorException listSharedLinksErrorException) {
                if (listSharedLinksErrorException.errorValue.getPathValue().isNotFound()) {
                    throw new DropboxFileNotFoundException(string);
                }
                throw this.a((DbxException)((Object)listSharedLinksErrorException));
            }
            catch (DbxException dbxException) {
                throw this.a(dbxException);
            }
            Controller.g = bl2;
        }
        return string2;
    }

    private DropboxFile a(Metadata metadata) {
        if (metadata instanceof FileMetadata) {
            return this.a((FileMetadata)metadata);
        }
        if (metadata instanceof FolderMetadata) {
            return this.a((FolderMetadata)metadata);
        }
        throw new IllegalArgumentException(b[0] + metadata.getClass().getSimpleName());
    }

    private DropboxFile a(FileMetadata fileMetadata) {
        return new DropboxFile(fileMetadata.getName(), fileMetadata.getPathDisplay(), fileMetadata.getRev(), fileMetadata.getClientModified().getTime(), fileMetadata.getSize());
    }

    private DropboxFile a(FolderMetadata folderMetadata) {
        return new DropboxFile(folderMetadata.getName(), folderMetadata.getPathDisplay());
    }

    private DropboxException a(DbxException dbxException) {
        if (dbxException instanceof InvalidAccessTokenException) {
            return new WrongAuthorizationException();
        }
        return new DropboxException(dbxException);
    }

    public static DropboxAccountInfo getDropboxAccount(String string) throws DbxException {
        DbxClientV2 dbxClientV2 = DropboxProjectStorage.b(string);
        FullAccount fullAccount = dbxClientV2.users().getCurrentAccount();
        return new DropboxAccountInfo(fullAccount.getName().getDisplayName(), fullAccount.getEmail());
    }

    private static DbxClientV2 b(String string) {
        return new DbxClientV2(DropboxProjectStorage.createRequestConfig(), string);
    }

    public static DbxRequestConfig createRequestConfig() {
        return DbxRequestConfig.newBuilder((String)b[1]).withUserLocaleFrom(Locale.getDefault()).withAutoRetryEnabled(3).build();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "npk\"WKqj#B_>u2SZzy#F\u001bja'B\u001b";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 59;
                                break;
                            }
                            case 1: {
                                n9 = 30;
                                break;
                            }
                            case 2: {
                                n9 = 24;
                                break;
                            }
                            case 3: {
                                n9 = 87;
                                break;
                            }
                            default: {
                                n9 = 39;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "hNKwdWw}9S";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "x\u007fvwDS{{<\u0007Xvy9@^m88IWg81HI>~>K^";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        b = stringArray3;
    }
}

