/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.storage.spscloud.project;

import com.agilemind.commons.application.data.storage.account.api.StorageAccountInfo;
import com.agilemind.commons.application.modules.storage.project.ProjectStorage;
import com.agilemind.commons.application.modules.storage.spscloud.account.NoAccountException;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.ProjectClient;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.ProjectMetaData;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.ProjectType;
import com.agilemind.commons.application.modules.storage.spscloud.project.data.SpsCloudFile;
import com.agilemind.commons.io.pagereader.PageReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class SpsCloudProjectStorage
implements ProjectStorage<SpsCloudFile> {
    private final ProjectClient a;
    private final StorageAccountInfo b;
    private final ProjectType c;
    private static final String d;

    public SpsCloudProjectStorage(PageReader pageReader, StorageAccountInfo storageAccountInfo, ProjectType projectType) {
        this.a = new ProjectClient(pageReader);
        this.b = storageAccountInfo;
        this.c = projectType;
    }

    private String c() throws NoAccountException {
        if (this.b == null) {
            throw new NoAccountException();
        }
        return this.b.getAccessToken();
    }

    @Override
    public boolean isFileChanged(SpsCloudFile spsCloudFile) throws IOException, InterruptedException {
        ProjectMetaData projectMetaData = this.a.getProjectMetadata(spsCloudFile.getUrl());
        if (projectMetaData == null) {
            return false;
        }
        boolean bl2 = projectMetaData.getLastModificationDate().getTime() != spsCloudFile.getLastModification();
        return bl2;
    }

    @Override
    public SpsCloudFile get(String string) throws IOException, InterruptedException {
        ProjectMetaData projectMetaData = this.a.getProjectMetadata(string);
        if (projectMetaData == null) {
            return null;
        }
        return this.a(projectMetaData);
    }

    @Override
    public List<SpsCloudFile> list() throws IOException, InterruptedException {
        return this.a.getProjectsMetadata(this.c(), this.c).stream().map(this::a).collect(Collectors.toList());
    }

    @Override
    public List<SpsCloudFile> list(String string) throws IOException, InterruptedException {
        return this.a.getProjectsMetadata(this.c(), this.c).stream().map(this::a).collect(Collectors.toList());
    }

    @Override
    public SpsCloudFile createFolder(String string) throws IOException {
        throw new UnsupportedOperationException(d);
    }

    @Override
    public SpsCloudFile uploadFile(String string, File file) throws IOException, InterruptedException {
        ProjectMetaData projectMetaData = this.a.uploadProject(this.c(), string, this.c, file);
        return this.a(projectMetaData);
    }

    @Override
    public SpsCloudFile updateFile(SpsCloudFile spsCloudFile, File file) throws IOException, InterruptedException {
        ProjectMetaData projectMetaData = this.a.updateProject(spsCloudFile.getUrl(), file);
        return this.a(projectMetaData);
    }

    @Override
    public SpsCloudFile downloadFile(String string, File file) throws IOException, InterruptedException {
        ProjectMetaData projectMetaData = this.a.downloadProject(string, file);
        return this.a(projectMetaData);
    }

    @Override
    public boolean delete(SpsCloudFile spsCloudFile) throws IOException, InterruptedException {
        this.a.removeProject(this.c(), spsCloudFile.getUrl());
        return true;
    }

    @Override
    public String createSharedLink(String string) throws IOException, InterruptedException {
        ProjectMetaData projectMetaData = this.a.getProjectMetadata(string);
        if (projectMetaData == null) {
            return null;
        }
        return projectMetaData.getUrl();
    }

    private SpsCloudFile a(ProjectMetaData projectMetaData) {
        return new SpsCloudFile(projectMetaData.getName(), projectMetaData.getUrl(), projectMetaData.getLastModificationDate().getTime(), projectMetaData.getCreationDate().getTime());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "dDT\fDS\u0005Y\u0010NFQ_BMHI^\u0007Y".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 39;
                            break;
                        }
                        case 1: {
                            n7 = 37;
                            break;
                        }
                        case 2: {
                            n7 = 58;
                            break;
                        }
                        case 3: {
                            n7 = 98;
                            break;
                        }
                        default: {
                            n7 = 43;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        d = new String(cArray).intern();
    }
}

