/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.storage.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.modules.storage.StorageType;
import com.agilemind.commons.application.modules.storage.dropbox.controllers.ConnectDropboxAccountPanelController;
import com.agilemind.commons.application.modules.storage.dropbox.data.DropboxAccount;
import com.agilemind.commons.application.modules.storage.spscloud.account.controllers.LogInAccountDialogController;
import com.agilemind.commons.application.modules.storage.spscloud.account.data.SpsCloudAccount;
import com.agilemind.commons.application.modules.storage.util.StorageTypeUtilGUI;
import com.agilemind.commons.mvc.controllers.Controller;

public class AccountAuthUtil {
    public static boolean showAuthIfNeeded(ApplicationControllerImpl applicationControllerImpl, StorageType storageType) {
        if (applicationControllerImpl.getParameters().haveAccount(storageType)) {
            return true;
        }
        return AccountAuthUtil.showAuth(applicationControllerImpl, storageType);
    }

    public static boolean showAuth(ApplicationControllerImpl applicationControllerImpl, StorageType storageType) {
        switch (storageType) {
            case LOCAL: {
                return true;
            }
            case SPS: {
                return AccountAuthUtil.showSpsCloudAuth(applicationControllerImpl);
            }
            case DROPBOX: {
                return AccountAuthUtil.showDropboxAuth(applicationControllerImpl);
            }
        }
        return false;
    }

    public static boolean showSpsCloudAuth(ApplicationControllerImpl applicationControllerImpl) {
        return AccountAuthUtil.showAndGetSpsCloudAuth(applicationControllerImpl) != null;
    }

    public static boolean showDropboxAuth(ApplicationControllerImpl applicationControllerImpl) {
        return AccountAuthUtil.showAndGetDropboxAuth(applicationControllerImpl) != null;
    }

    public static DropboxAccount showAndGetDropboxAuth(ApplicationControllerImpl applicationControllerImpl) {
        ConnectDropboxAccountPanelController.connectAccount(applicationControllerImpl);
        return applicationControllerImpl.getParameters().getDropboxAccount();
    }

    public static SpsCloudAccount showAndGetSpsCloudAuth(ApplicationControllerImpl applicationControllerImpl) {
        int n2 = StorageTypeUtilGUI.d;
        LogInAccountDialogController logInAccountDialogController = applicationControllerImpl.createDialog(LogInAccountDialogController.class);
        int n3 = logInAccountDialogController.show();
        if (n3 == 2) {
            return null;
        }
        SpsCloudAccount spsCloudAccount = applicationControllerImpl.getParameters().getSpsCloudAccount();
        if (n2 != 0) {
            Controller.g = !Controller.g;
        }
        return spsCloudAccount;
    }
}

