/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.widget.mapper;

import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityHistoryMap;
import com.agilemind.commons.application.modules.report.colorscheme.WidgetColorScheme;
import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.application.modules.widget.core.IWidgetReportSettings;
import com.agilemind.commons.application.modules.widget.core.ReportWidgetLocalizer;
import com.agilemind.commons.application.modules.widget.core.WidgetType;
import com.agilemind.commons.application.modules.widget.mapper.CommonWidgetFactory;
import com.agilemind.commons.application.modules.widget.service.project.BacklinkFactorsWidgetProjectService;
import com.agilemind.commons.application.modules.widget.service.project.CatalogListingsProjectService;
import com.agilemind.commons.application.modules.widget.service.project.DomainInfoProjectService;
import com.agilemind.commons.application.modules.widget.service.project.ExternalDomainFactorsProjectService;
import com.agilemind.commons.application.modules.widget.service.project.IndexingInSearchEnginesProjectService;
import com.agilemind.commons.application.modules.widget.service.project.SocialMediaPopularityProjectService;
import com.agilemind.commons.application.modules.widget.service.project.TrafficToWebsiteProjectService;
import com.agilemind.commons.application.modules.widget.widget.BacklinkFactorsWidget;
import com.agilemind.commons.application.modules.widget.widget.CatalogListingsWidget;
import com.agilemind.commons.application.modules.widget.widget.DomainInfoWidget;
import com.agilemind.commons.application.modules.widget.widget.ExternalDomainFactorsWidget;
import com.agilemind.commons.application.modules.widget.widget.IWidget;
import com.agilemind.commons.application.modules.widget.widget.IndexingInSearchEngineWidget;
import com.agilemind.commons.application.modules.widget.widget.SocialMediaPopularityWidget;
import com.agilemind.commons.application.modules.widget.widget.TrafficToWebsiteWidget;
import com.agilemind.commons.application.service.ProjectService;
import com.agilemind.commons.io.searchengine.searchengines.data.IGoogleAnalyticsSettings;
import com.agilemind.factors.SearchEngineFactorType;
import java.util.List;

public abstract class DomainWidgetFactory<PS extends ProjectService>
extends CommonWidgetFactory<PS> {
    private IPopularityHistoryMap d;
    private List<SearchEngineFactorType<? extends Comparable>> e;
    private IGoogleAnalyticsSettings f;

    public DomainWidgetFactory(PS PS, IPersonInformation iPersonInformation, IPersonInformation iPersonInformation2) {
        super(PS, iPersonInformation, iPersonInformation2);
        this.f = PS.getGoogleAnalyticsSettings();
        this.d = PS.getPopularityHistoryMap();
        this.e = PS.getUseDomainSearchEngineFactorList();
    }

    @Override
    public IWidget createWidget(IWidgetReportSettings iWidgetReportSettings, WidgetType widgetType) {
        ReportWidgetLocalizer reportWidgetLocalizer = this.getWidgetLocalizer(iWidgetReportSettings);
        WidgetColorScheme widgetColorScheme = iWidgetReportSettings.getColorSchema();
        switch (widgetType) {
            case EXTERNAL_DOMAIN_FACTORS: {
                ExternalDomainFactorsProjectService externalDomainFactorsProjectService = new ExternalDomainFactorsProjectService(this.d, this.e);
                return new ExternalDomainFactorsWidget(reportWidgetLocalizer, externalDomainFactorsProjectService);
            }
            case DOMAIN_INFO: {
                DomainInfoProjectService domainInfoProjectService = new DomainInfoProjectService(this.d, this.e);
                return new DomainInfoWidget(reportWidgetLocalizer, domainInfoProjectService);
            }
            case INDEXING_IN_SEARCH_ENGINES: {
                IndexingInSearchEnginesProjectService indexingInSearchEnginesProjectService = new IndexingInSearchEnginesProjectService(this.d, this.e);
                return new IndexingInSearchEngineWidget(reportWidgetLocalizer, indexingInSearchEnginesProjectService);
            }
            case CATALOG_LISTINGS: {
                CatalogListingsProjectService catalogListingsProjectService = new CatalogListingsProjectService(this.d, this.e);
                return new CatalogListingsWidget(reportWidgetLocalizer, catalogListingsProjectService);
            }
            case BACKLINK_FACTORS: {
                BacklinkFactorsWidgetProjectService backlinkFactorsWidgetProjectService = new BacklinkFactorsWidgetProjectService(this.d, this.e);
                return new BacklinkFactorsWidget(reportWidgetLocalizer, widgetColorScheme, backlinkFactorsWidgetProjectService);
            }
            case SOCIAL_MEDIA_POPULARITY: {
                SocialMediaPopularityProjectService socialMediaPopularityProjectService = new SocialMediaPopularityProjectService(this.f, this.projectService.getGASocialVisitsService(), this.d, this.e);
                return new SocialMediaPopularityWidget(reportWidgetLocalizer, socialMediaPopularityProjectService);
            }
            case TRAFFIC_TO_WEBSITE: {
                TrafficToWebsiteProjectService trafficToWebsiteProjectService = new TrafficToWebsiteProjectService(this.d, this.e, this.f);
                return new TrafficToWebsiteWidget(reportWidgetLocalizer, widgetColorScheme, trafficToWebsiteProjectService);
            }
        }
        return super.createWidget(iWidgetReportSettings, widgetType);
    }
}

