/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.widget.mapper;

import com.agilemind.commons.application.modules.report.colorscheme.WidgetColorScheme;
import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.application.modules.widget.core.IWidgetReportSettings;
import com.agilemind.commons.application.modules.widget.core.ReportWidgetLocalizer;
import com.agilemind.commons.application.modules.widget.core.WidgetType;
import com.agilemind.commons.application.modules.widget.mapper.CommonWidgetFactory;
import com.agilemind.commons.application.modules.widget.service.preview.BacklinkFactorsPreviewWidgetService;
import com.agilemind.commons.application.modules.widget.service.preview.CatalogListingsPreviewService;
import com.agilemind.commons.application.modules.widget.service.preview.DomainInfoPreviewService;
import com.agilemind.commons.application.modules.widget.service.preview.ExternalDomainFactorsPreviewService;
import com.agilemind.commons.application.modules.widget.service.preview.IndexingInSearchEnginesPreviewService;
import com.agilemind.commons.application.modules.widget.service.preview.SocialMediaPopularityPreviewService;
import com.agilemind.commons.application.modules.widget.service.preview.TrafficToWebsitePreviewService;
import com.agilemind.commons.application.modules.widget.widget.BacklinkFactorsWidget;
import com.agilemind.commons.application.modules.widget.widget.CatalogListingsWidget;
import com.agilemind.commons.application.modules.widget.widget.DomainInfoWidget;
import com.agilemind.commons.application.modules.widget.widget.ExternalDomainFactorsWidget;
import com.agilemind.commons.application.modules.widget.widget.IWidget;
import com.agilemind.commons.application.modules.widget.widget.IndexingInSearchEngineWidget;
import com.agilemind.commons.application.modules.widget.widget.SocialMediaPopularityWidget;
import com.agilemind.commons.application.modules.widget.widget.TrafficToWebsiteWidget;
import com.agilemind.commons.application.service.ProjectService;
import com.agilemind.commons.io.searchengine.searchengines.data.IGoogleAnalyticsSettings;

public abstract class DomainWidgetPreviewFactory<PS extends ProjectService>
extends CommonWidgetFactory<PS> {
    private IGoogleAnalyticsSettings d;

    public DomainWidgetPreviewFactory(PS PS, IPersonInformation iPersonInformation, IPersonInformation iPersonInformation2) {
        super(PS, iPersonInformation, iPersonInformation2);
        this.d = PS.getGoogleAnalyticsSettings();
    }

    @Override
    public IWidget createWidget(IWidgetReportSettings iWidgetReportSettings, WidgetType widgetType) {
        WidgetColorScheme widgetColorScheme = iWidgetReportSettings.getColorSchema();
        ReportWidgetLocalizer reportWidgetLocalizer = this.getWidgetLocalizer(iWidgetReportSettings);
        switch (widgetType) {
            case EXTERNAL_DOMAIN_FACTORS: {
                ExternalDomainFactorsPreviewService externalDomainFactorsPreviewService = new ExternalDomainFactorsPreviewService();
                return new ExternalDomainFactorsWidget(reportWidgetLocalizer, externalDomainFactorsPreviewService);
            }
            case DOMAIN_INFO: {
                return new DomainInfoWidget(reportWidgetLocalizer, new DomainInfoPreviewService());
            }
            case INDEXING_IN_SEARCH_ENGINES: {
                IndexingInSearchEnginesPreviewService indexingInSearchEnginesPreviewService = new IndexingInSearchEnginesPreviewService();
                return new IndexingInSearchEngineWidget(reportWidgetLocalizer, indexingInSearchEnginesPreviewService);
            }
            case CATALOG_LISTINGS: {
                CatalogListingsPreviewService catalogListingsPreviewService = new CatalogListingsPreviewService();
                return new CatalogListingsWidget(reportWidgetLocalizer, catalogListingsPreviewService);
            }
            case BACKLINK_FACTORS: {
                BacklinkFactorsPreviewWidgetService backlinkFactorsPreviewWidgetService = new BacklinkFactorsPreviewWidgetService();
                return new BacklinkFactorsWidget(reportWidgetLocalizer, widgetColorScheme, backlinkFactorsPreviewWidgetService);
            }
            case SOCIAL_MEDIA_POPULARITY: {
                SocialMediaPopularityPreviewService socialMediaPopularityPreviewService = new SocialMediaPopularityPreviewService(this.d);
                return new SocialMediaPopularityWidget(reportWidgetLocalizer, socialMediaPopularityPreviewService);
            }
            case TRAFFIC_TO_WEBSITE: {
                TrafficToWebsitePreviewService trafficToWebsitePreviewService = new TrafficToWebsitePreviewService();
                return new TrafficToWebsiteWidget(reportWidgetLocalizer, widgetColorScheme, trafficToWebsitePreviewService);
            }
        }
        return super.createWidget(iWidgetReportSettings, widgetType);
    }
}

