/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.widget.util;

import com.agilemind.commons.application.data.IScanResult;
import com.agilemind.commons.application.data.record.FactorStorage;
import com.agilemind.commons.application.data.type.TagsGetter;
import com.agilemind.commons.application.modules.linkinfo.data.AnchorType;
import com.agilemind.commons.application.modules.widget.util.c;
import com.agilemind.commons.application.modules.widget.util.d;
import com.agilemind.commons.application.modules.widget.util.e;
import com.agilemind.commons.application.modules.widget.util.extractor.Extractor;
import com.agilemind.commons.application.modules.widget.util.extractor.ExtractorUtils;
import com.agilemind.commons.application.modules.widget.util.extractor.FactorValueExtractor;
import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.KeywordsResult;
import com.agilemind.commons.application.modules.widget.util.to.Range;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.PRDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.ValueDistribution;
import com.agilemind.commons.io.searchengine.validator.ILinkInfo;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.localization.stringkey.Country;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.Pair;
import com.agilemind.commons.util.StringURLUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import com.agilemind.factors.IFactorParser;
import com.agilemind.factors.SearchEngineFactorType;
import com.agilemind.factors.SearchEngineFactorsList;
import com.agilemind.factors.data.IMozAuthorityResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecordAnalyzeUtil {
    public static final int PR_START = -1;
    public static final int PR_END = 10;
    public static final int NO_DATA = -1;
    public static final Range[] DEFAULT_DISTRIBUTION_RANGES_FROM_ONE;
    public static final Range[] DEFAULT_DISTRIBUTION_RANGES_FROM_ZERO;
    private static final Pattern a;
    private static final Pattern b;
    public static int d;
    private static final String[] e;

    public static <T extends TagsGetter> List<T> filterByTags(Iterable<T> iterable, List<String> list) {
        return Util.filter(iterable, (Predicate[])new Predicate[]{tagsGetter -> list.isEmpty() || StringUtil.containsAtLeastOne((Collection)list, tagsGetter.getTags())});
    }

    public static <R> int getUniqueDomainsCount(Collection<? extends R> collection, Extractor<UnicodeURL, R> extractor) {
        return RecordAnalyzeUtil.calcUniqueHomepagesCount(collection.stream().map(extractor::extract).collect(Collectors.toList()));
    }

    public static <R> int getHomepageLinkingDomainsCount(Collection<? extends R> collection, Extractor<UnicodeURL, R> extractor) {
        int n2 = d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (R r2 : collection) {
            UnicodeURL unicodeURL = extractor.extract(r2);
            if (unicodeURL != null && UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)unicodeURL)) {
                arrayList.add(unicodeURL);
            }
            if (n2 == 0) continue;
        }
        return RecordAnalyzeUtil.calcUniqueHomepagesCount(arrayList);
    }

    public static <R> int getUniqueIPsCount(Collection<? extends R> collection, Extractor<IP, R> extractor) {
        int n2 = d;
        if (collection.isEmpty()) {
            return 0;
        }
        boolean bl2 = false;
        HashSet<IP> hashSet = new HashSet<IP>();
        for (R r2 : collection) {
            IP iP = extractor.extract(r2);
            if (iP == null && n2 == 0) continue;
            bl2 = true;
            hashSet.add(iP);
            if (n2 == 0) continue;
        }
        return bl2 ? hashSet.size() : -1;
    }

    public static <R> int getUniqueCBlocksCount(Collection<? extends R> collection, Extractor<IP, R> extractor) {
        int n2 = d;
        if (collection.isEmpty()) {
            return 0;
        }
        boolean bl2 = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (R r2 : collection) {
            IP iP = extractor.extract(r2);
            if (iP == null && n2 == 0) continue;
            bl2 = true;
            StringBuilder stringBuilder = new StringBuilder();
            int[] nArray = iP.getDigits();
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                stringBuilder.append(nArray[i2]);
                if (n2 == 0) continue;
            }
            hashSet.add(stringBuilder.toString());
            if (n2 == 0) continue;
        }
        return bl2 ? hashSet.size() : -1;
    }

    public static <R> int getUniqueAnchorsCount(Collection<? extends R> collection, Extractor<IScanResult, R> extractor) {
        int n2 = d;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (R r2 : collection) {
            block4: {
                String string;
                block3: {
                    ILinkInfo iLinkInfo;
                    IScanResult iScanResult = extractor.extract(r2);
                    if (iScanResult == null && n2 == 0 || (iLinkInfo = iScanResult.getLinkInfo()) == null && n2 == 0) continue;
                    string = RecordAnalyzeUtil.a(iLinkInfo);
                    if (!iLinkInfo.isTextLink()) break block3;
                    hashSet.add(string);
                    if (n2 == 0) break block4;
                }
                hashSet2.add(string);
            }
            if (n2 == 0) continue;
        }
        return hashSet.size() + hashSet2.size();
    }

    private static String a(ILinkInfo iLinkInfo) {
        return StringUtil.removeBrakes((String)iLinkInfo.getName()).toLowerCase();
    }

    public static <R> int getUniqueKeywordsCount(Collection<R> collection, Extractor<String, R> extractor) {
        int n2 = d;
        HashSet<String> hashSet = new HashSet<String>();
        for (R r2 : collection) {
            String string = extractor.extract(r2);
            if (string != null) {
                Collection<String> collection2 = RecordAnalyzeUtil.b(string);
                hashSet.addAll(collection2);
            }
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    private static Collection<String> b(String string) {
        if ("".equals(string)) {
            return Collections.singletonList(string);
        }
        string = b.matcher(string).replaceAll("");
        return StringUtil.KeywordUtil.getUniqueKeywords((String)string.toLowerCase());
    }

    public static <R> List<AnchorAltTextResult> getPagesTopAnchorAltTexts(Collection<R> collection, Extractor<IScanResult, R> extractor, Extractor<UnicodeURL, R> extractor2, boolean bl2) {
        int n2 = d;
        ArrayList<AnchorAltTextResult> arrayList = new ArrayList<AnchorAltTextResult>();
        Map<Pair<String, AnchorType>, List<UnicodeURL>> map = RecordAnalyzeUtil.a(collection, extractor, extractor2, bl2);
        for (Map.Entry<Pair<String, AnchorType>, List<UnicodeURL>> entry : map.entrySet()) {
            String string = (String)entry.getKey().getA();
            AnchorType anchorType = (AnchorType)((Object)entry.getKey().getB());
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)collection.size(), (double)n3);
            arrayList.add(new AnchorAltTextResult(string, anchorType, n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new c(null));
        return arrayList;
    }

    public static <R> List<AnchorAltTextResult> getDomainsTopAnchorAltTexts(Collection<R> collection, Extractor<IScanResult, R> extractor, Extractor<UnicodeURL, R> extractor2, boolean bl2) {
        int n2 = d;
        ArrayList<AnchorAltTextResult> arrayList = new ArrayList<AnchorAltTextResult>();
        Map<Pair<String, AnchorType>, List<UnicodeURL>> map = RecordAnalyzeUtil.a(collection, extractor, extractor2, bl2);
        int n3 = RecordAnalyzeUtil.getUniqueDomainsCount(collection, extractor2);
        for (Map.Entry<Pair<String, AnchorType>, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = RecordAnalyzeUtil.calcUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            arrayList.add(new AnchorAltTextResult((String)entry.getKey().getA(), (AnchorType)((Object)entry.getKey().getB()), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new c(null));
        return arrayList;
    }

    private static <R> Map<Pair<String, AnchorType>, List<UnicodeURL>> a(Collection<R> collection, Extractor<IScanResult, R> extractor, Extractor<UnicodeURL, R> extractor2, boolean bl2) {
        int n2 = d;
        HashMap<Pair<String, AnchorType>, List<UnicodeURL>> hashMap = new HashMap<Pair<String, AnchorType>, List<UnicodeURL>>();
        for (R r2 : collection) {
            ILinkInfo iLinkInfo;
            IScanResult iScanResult = extractor.extract(r2);
            if (iScanResult == null && n2 == 0 || (iLinkInfo = iScanResult.getLinkInfo()) == null && n2 == 0) continue;
            AnchorType anchorType = iLinkInfo.isTextLink() ? AnchorType.TEXT_LINK : AnchorType.IMAGE_LINK;
            String string = RecordAnalyzeUtil.a(iLinkInfo);
            Pair pair = Pair.create((Object)string, (Object)((Object)(bl2 ? anchorType : null)));
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(pair);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put((Pair<String, AnchorType>)pair, arrayList);
            }
            UnicodeURL unicodeURL = extractor2.extract(r2);
            arrayList.add(unicodeURL);
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static <R> List<KeywordsResult> getPagesTopKeywords(Collection<R> collection, Extractor<String, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = RecordAnalyzeUtil.a(collection, extractor, extractor2);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)collection.size(), (double)n3);
            arrayList.add(new KeywordsResult(entry.getKey(), n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new e(null));
        return arrayList;
    }

    public static <R> List<KeywordsResult> getDomainsTopKeywords(Collection<R> collection, Extractor<String, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = RecordAnalyzeUtil.a(collection, extractor, extractor2);
        int n3 = RecordAnalyzeUtil.getUniqueDomainsCount(collection, extractor2);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = RecordAnalyzeUtil.calcUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            arrayList.add(new KeywordsResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new e(null));
        return arrayList;
    }

    private static <R> Map<String, List<UnicodeURL>> a(Collection<R> collection, Extractor<String, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (R r2 : collection) {
            String string = extractor.extract(r2);
            if (string == null && n2 == 0) continue;
            Collection<String> collection2 = RecordAnalyzeUtil.b(string);
            for (String string2 : collection2) {
                ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<UnicodeURL>();
                    hashMap.put(string2, arrayList);
                }
                UnicodeURL unicodeURL = extractor2.extract(r2);
                arrayList.add(unicodeURL);
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static <R> int getUniqueAnchorUrlsCount(Collection<R> collection, Extractor<UnicodeURL, R> extractor) {
        int n2 = d;
        HashSet<String> hashSet = new HashSet<String>();
        for (R r2 : collection) {
            UnicodeURL unicodeURL = extractor.extract(r2);
            if (unicodeURL != null) {
                hashSet.add(RecordAnalyzeUtil.a(unicodeURL).toLowerCase());
            }
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    private static String a(UnicodeURL unicodeURL) {
        return StringURLUtil.removeTrailingSlash((String)StringURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)unicodeURL)));
    }

    public static <R> List<AnchorUrlResult> getPagesTopAnchorUrls(Collection<R> collection, Extractor<UnicodeURL, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = RecordAnalyzeUtil.b(collection, extractor, extractor2);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent100((double)collection.size(), (double)n3);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, (anchorUrlResult, anchorUrlResult2) -> anchorUrlResult2.getCount() - anchorUrlResult.getCount());
        return arrayList;
    }

    public static <R> List<AnchorUrlResult> getDomainsTopAnchorUrls(Collection<R> collection, Extractor<UnicodeURL, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = RecordAnalyzeUtil.b(collection, extractor, extractor2);
        int n3 = RecordAnalyzeUtil.getUniqueDomainsCount(collection, extractor2);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = RecordAnalyzeUtil.calcUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, (anchorUrlResult, anchorUrlResult2) -> anchorUrlResult2.getCount() - anchorUrlResult.getCount());
        return arrayList;
    }

    private static <R> Map<UnicodeURL, List<UnicodeURL>> b(Collection<R> collection, Extractor<UnicodeURL, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        TreeMap<UnicodeURL, List<UnicodeURL>> treeMap = new TreeMap<UnicodeURL, List<UnicodeURL>>((unicodeURL, unicodeURL2) -> RecordAnalyzeUtil.a(unicodeURL).compareToIgnoreCase(RecordAnalyzeUtil.a(unicodeURL2)));
        for (R r2 : collection) {
            UnicodeURL unicodeURL3 = extractor.extract(r2);
            if (unicodeURL3 == null && n2 == 0) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)treeMap.get(unicodeURL3);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                treeMap.put(unicodeURL3, arrayList);
            }
            UnicodeURL unicodeURL4 = extractor2.extract(r2);
            arrayList.add(unicodeURL4);
            if (n2 == 0) continue;
        }
        return treeMap;
    }

    public static double getBacklinksPercent(int n2) {
        if (n2 == 0) {
            return 0.0;
        }
        if (n2 >= 1 && n2 < 100) {
            return 5.0;
        }
        if (n2 >= 100 && n2 < 5000) {
            return RecordAnalyzeUtil.a(n2, 5, 30, 100, 5000);
        }
        if (n2 >= 5000 && n2 < 50000) {
            return RecordAnalyzeUtil.a(n2, 30, 50, 5000, 50000);
        }
        if (n2 >= 50000 && n2 < 100000) {
            return RecordAnalyzeUtil.a(n2, 50, 70, 50000, 100000);
        }
        if (n2 >= 100000 && n2 < 1000000) {
            return RecordAnalyzeUtil.a(n2, 70, 100, 100000, 1000000);
        }
        return 100.0;
    }

    private static double a(int n2, int n3, int n4, int n5, int n6) {
        return n3 + (n2 - n5) * (n4 - n3) / (n6 - n5);
    }

    public static <R> DofollowNofollowDistribution calcDofollowNofollowDistribution(Collection<? extends R> collection, Extractor<IScanResult, R> extractor) {
        int n2 = d;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (R r2 : collection) {
            block6: {
                block8: {
                    ScanStatus scanStatus;
                    block7: {
                        block5: {
                            IScanResult iScanResult = extractor.extract(r2);
                            assert (iScanResult != null);
                            scanStatus = iScanResult.getScanStatus();
                            if (scanStatus != ScanStatus.SCAN_STATUS_UNKNOWN) break block5;
                            ++n5;
                            if (n2 == 0) break block6;
                        }
                        if (!scanStatus.isOkStatus()) break block7;
                        ++n3;
                        if (n2 == 0) break block6;
                    }
                    if (scanStatus != ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW && scanStatus != ScanStatus.SCAN_STATUS_NOINDEX_ROBOTS) break block8;
                    ++n4;
                    if (n2 == 0) break block6;
                }
                ++n5;
            }
            if (n2 == 0) continue;
        }
        double d2 = MathUtil.getPercent((double)collection.size(), (double)n3);
        double d3 = MathUtil.getPercent((double)collection.size(), (double)n4);
        double d4 = MathUtil.getPercent((double)collection.size(), (double)n5);
        return new DofollowNofollowDistribution(n3, d2, n4, d3, n5, d4);
    }

    public static <R> HomepageLinksDistribution calcHomepageLinksDistribution(Collection<? extends R> collection, Extractor<UnicodeURL, R> extractor) {
        int n2 = RecordAnalyzeUtil.calcUniqueDomainsCount(collection, extractor);
        int n3 = RecordAnalyzeUtil.calcHomepageLinkingDomainsCount(collection, extractor, false);
        int n4 = RecordAnalyzeUtil.calcHomepageLinkingDomainsCount(collection, extractor, true);
        return new HomepageLinksDistribution(n2, n3, n4);
    }

    public static <R> int calcHomepageLinkingDomainsCount(Collection<? extends R> collection, Extractor<UnicodeURL, R> extractor, boolean bl2) {
        int n2 = d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (R r2 : collection) {
            UnicodeURL unicodeURL = extractor.extract(r2);
            if (unicodeURL != null && bl2 != UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)unicodeURL)) {
                arrayList.add(unicodeURL);
            }
            if (n2 == 0) continue;
        }
        return RecordAnalyzeUtil.calcUniqueHomepagesCount(arrayList);
    }

    public static <R> List<CountryResult> calcCountryDistributions(List<? extends R> list, Extractor<Country, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        ArrayList<CountryResult> arrayList = new ArrayList<CountryResult>();
        Map<Country, List<UnicodeURL>> map = RecordAnalyzeUtil.a(list, extractor, extractor2);
        int n3 = RecordAnalyzeUtil.calcUniqueDomainsCount(list, extractor2);
        for (Map.Entry<Country, List<UnicodeURL>> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getKey() == Country.UNKNOWN && n2 == 0) continue;
            int n4 = RecordAnalyzeUtil.calcUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new CountryResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, (countryResult, countryResult2) -> countryResult2.getDomainsCount() - countryResult.getDomainsCount());
        return arrayList;
    }

    private static <R> Map<Country, List<UnicodeURL>> a(List<? extends R> list, Extractor<Country, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        return ExtractorUtils.groupByAndCollect(list, extractor, extractor2);
    }

    public static <R> List<TLDResult> calcTldDistribution(List<? extends R> list, Extractor<UnicodeURL, R> extractor) {
        int n2 = d;
        ArrayList<TLDResult> arrayList = new ArrayList<TLDResult>();
        Map<String, List<UnicodeURL>> map = RecordAnalyzeUtil.a(list, extractor);
        map.remove(null);
        int n3 = RecordAnalyzeUtil.calcUniqueDomainsCount(list, extractor);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = RecordAnalyzeUtil.calcUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent100((double)n3, (double)n4);
            arrayList.add(new TLDResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, (tLDResult, tLDResult2) -> tLDResult2.getDomainsCount() - tLDResult.getDomainsCount());
        return arrayList;
    }

    private static <R> Map<String, List<UnicodeURL>> a(List<? extends R> list, Extractor<UnicodeURL, R> extractor) {
        Extractor<String, UnicodeURL> extractor2 = unicodeURL -> {
            if (unicodeURL == null) {
                return null;
            }
            if (a.matcher(unicodeURL.getUnicodeHost()).find()) {
                return IFactorParser.NA_DATA;
            }
            return UnicodeURLUtil.getTld((UnicodeURL)unicodeURL);
        };
        return ExtractorUtils.groupByAndCollect(list, ExtractorUtils.concat(extractor, extractor2), extractor);
    }

    public static <R> List<PRDistribution> calcGooglePrDistributions(List<? extends R> list, Extractor<Integer, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        int n2 = d;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = RecordAnalyzeUtil.c(list, extractor, extractor2);
        if (map.isEmpty() || map.size() == 1 && map.containsKey(null)) {
            return arrayList;
        }
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (n2 == 0) continue;
            }
            double d2 = MathUtil.getPercent100((double)list.size(), (double)list2.size());
            arrayList.add(new PRDistribution(i2, list2.size(), d2));
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    private static <R> Map<Integer, List<UnicodeURL>> c(Collection<? extends R> collection, Extractor<Integer, R> extractor, Extractor<UnicodeURL, R> extractor2) {
        return ExtractorUtils.groupByAndCollect(collection, extractor, extractor2);
    }

    public static String generatePrText(int n2) {
        assert (n2 <= 10 && n2 >= -1) : e[1] + n2 + e[0];
        if (n2 == -1) {
            return e[2];
        }
        return e[3] + n2;
    }

    public static <R extends FactorStorage> List<ValueDistribution> calcMozPageAuthorityDistribution(List<? extends R> list, Extractor<UnicodeURL, R> extractor) {
        return RecordAnalyzeUtil.a(list, extractor, (IMozAuthorityResult iMozAuthorityResult2) -> Optional.ofNullable(iMozAuthorityResult2).map(iMozAuthorityResult -> (int)Math.round(iMozAuthorityResult.getPageAuthority())).orElse(null), (SearchEngineFactorType<IMozAuthorityResult>)SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE);
    }

    public static <R extends FactorStorage> List<ValueDistribution> calcMozDomainAuthorityDistribution(List<? extends R> list, Extractor<UnicodeURL, R> extractor) {
        return RecordAnalyzeUtil.a(list, extractor, (IMozAuthorityResult iMozAuthorityResult2) -> Optional.ofNullable(iMozAuthorityResult2).map(iMozAuthorityResult -> (int)Math.round(iMozAuthorityResult.getDomainAuthority())).orElse(null), (SearchEngineFactorType<IMozAuthorityResult>)SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE);
    }

    private static <R extends FactorStorage> List<ValueDistribution> a(List<? extends R> list, Extractor<UnicodeURL, R> extractor, Extractor<Integer, IMozAuthorityResult> extractor2, SearchEngineFactorType<IMozAuthorityResult> searchEngineFactorType) {
        Extractor extractor3 = ExtractorUtils.concat(new FactorValueExtractor(searchEngineFactorType), extractor2);
        d d2 = new d(DEFAULT_DISTRIBUTION_RANGES_FROM_ONE, null);
        Map<UnicodeURL, Integer> map = list.stream().filter(factorStorage -> extractor.extract(factorStorage) != null && extractor3.extract(factorStorage) != null).collect(Collectors.toMap(extractor::extract, extractor3::extract, (n2, n3) -> n2));
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        int n4 = map.size();
        Map<Range, Integer> map2 = map.entrySet().stream().collect(Collectors.groupingBy(entry -> d2.map((Integer)entry.getValue()), Collectors.collectingAndThen(Collectors.toSet(), Collection::size)));
        ArrayList arrayList = Lists.newArrayList((Object[])DEFAULT_DISTRIBUTION_RANGES_FROM_ONE);
        arrayList.removeAll(map2.keySet());
        return Stream.concat(map2.entrySet().stream(), arrayList.stream().collect(Collectors.toMap(Function.identity(), range -> 0)).entrySet().stream()).sorted((entry, entry2) -> ((Range)entry.getKey()).compareTo((Range)entry2.getKey())).map(entry -> new ValueDistribution((Range)entry.getKey(), (Integer)entry.getValue(), MathUtil.getPercent100((double)n4, (double)((Integer)entry.getValue()).intValue()))).collect(Collectors.toList());
    }

    public static <R extends FactorStorage> List<ValueDistribution> calcBlexRankDomainAuthorityDistribution(List<? extends R> list, SearchEngineFactorType<Integer> searchEngineFactorType) {
        FactorValueExtractor factorValueExtractor = new FactorValueExtractor(searchEngineFactorType);
        Extractor extractor = ExtractorUtils.concat(factorValueExtractor, n2 -> Optional.ofNullable(n2).orElse(-1));
        d d2 = new d(DEFAULT_DISTRIBUTION_RANGES_FROM_ZERO, null);
        com.agilemind.commons.application.modules.widget.util.d.access$300(d2, true);
        Map<Range, Long> map = list.stream().filter(factorStorage -> {
            Integer n2 = (Integer)extractor.extract(factorStorage);
            return n2 != null && n2 != -1;
        }).collect(Collectors.groupingBy(factorStorage -> d2.map((Integer)extractor.extract(factorStorage)), Collectors.counting()));
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        Integer n3 = map.values().stream().mapToInt(Long::intValue).sum();
        List list2 = Arrays.stream(DEFAULT_DISTRIBUTION_RANGES_FROM_ZERO).collect(Collectors.toList());
        list2.removeAll(map.keySet());
        return Stream.concat(map.entrySet().stream(), list2.stream().collect(Collectors.toMap(Function.identity(), range -> 0L)).entrySet().stream()).sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> new ValueDistribution((Range)entry.getKey(), ((Long)entry.getValue()).intValue(), MathUtil.getPercent100((double)n3.intValue(), (double)((Long)entry.getValue()).longValue()))).collect(Collectors.toList());
    }

    public static <R> int calcUniqueDomainsCount(Collection<? extends R> collection, Extractor<UnicodeURL, R> extractor) {
        int n2 = d;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (R r2 : collection) {
            UnicodeURL unicodeURL = extractor.extract(r2);
            if (unicodeURL != null) {
                arrayList.add(unicodeURL);
            }
            if (n2 == 0) continue;
        }
        return RecordAnalyzeUtil.calcUniqueHomepagesCount(arrayList);
    }

    public static int calcUniqueHomepagesCount(List<UnicodeURL> list) {
        return (int)list.stream().filter(Objects::nonNull).map(unicodeURL -> unicodeURL.getUnicodeHost().toLowerCase()).distinct().count();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "SZ\u0013kg2(\nbtmdXWPWM(C\"ttFkg~m\n'>XZ9TVIZ2Z";
        int n4 = -1;
        block20: while (true) {
            char[] cArray;
            block29: {
                int n5;
                int n6;
                char[] cArray2;
                block28: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block28;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 8;
                                break;
                            }
                            case 1: {
                                n9 = 8;
                                break;
                            }
                            case 2: {
                                n9 = 102;
                                break;
                            }
                            case 3: {
                                n9 = 7;
                                break;
                            }
                            default: {
                                n9 = 2;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "dm\u0010bn(5F";
                    n4 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "XZF*";
                    n4 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "XZF";
                    n4 = 2;
                    continue block20;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        e = stringArray3;
        DEFAULT_DISTRIBUTION_RANGES_FROM_ONE = new Range[]{new Range(1, 10), new Range(11, 20), new Range(21, 30), new Range(31, 40), new Range(41, 50), new Range(51, 60), new Range(61, 70), new Range(71, 80), new Range(81, 90), new Range(91, 100)};
        DEFAULT_DISTRIBUTION_RANGES_FROM_ZERO = new Range[]{new Range(0, 10), new Range(11, 20), new Range(21, 30), new Range(31, 40), new Range(41, 50), new Range(51, 60), new Range(61, 70), new Range(71, 80), new Range(81, 90), new Range(91, 100)};
        String string4 = "V N\\29UY[fTlY{0S8K3_Tl\u001a57S8K2_!TH.y;uN\\29UY[fTlY{0S8K3_Tl\u001a57S8K2_!,";
        int n10 = -1;
        block23: while (true) {
            char[] cArray;
            block31: {
                int n11;
                int n12;
                char[] cArray6;
                block30: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block30;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block31;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 8;
                                break;
                            }
                            case 1: {
                                n15 = 8;
                                break;
                            }
                            case 2: {
                                n15 = 102;
                                break;
                            }
                            case 3: {
                                n15 = 7;
                                break;
                            }
                            default: {
                                n15 = 2;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            string = new String(cArray).intern();
            switch (n10) {
                default: {
                    a = Pattern.compile(string);
                    string4 = "S)Y+_";
                    n10 = 0;
                    continue block23;
                }
                case 0: 
            }
            break;
        }
        b = Pattern.compile(string);
    }
}

