/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.service;

import com.agilemind.commons.application.data.WebProject;
import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.captcha.notif.CaptchaNotificationFactory;
import com.agilemind.commons.application.modules.export.data.ExportData;
import com.agilemind.commons.application.modules.export.data.Exporter;
import com.agilemind.commons.application.modules.export.data.providers.ExportSupportedInfoProvider;
import com.agilemind.commons.application.modules.factors.util.DomainAnalyzeResult;
import com.agilemind.commons.application.modules.factors.util.UpdateProjectDomainFactorsCompositeOperation;
import com.agilemind.commons.application.modules.projectmanager.ProjectId;
import com.agilemind.commons.application.modules.report.controllers.PublishReportOperation;
import com.agilemind.commons.application.modules.report.controllers.PublishReportSchedulerOperation;
import com.agilemind.commons.application.modules.report.controllers.ReportApplicationControllerImpl;
import com.agilemind.commons.application.modules.report.controllers.StorageAccountRequester;
import com.agilemind.commons.application.modules.report.data.IReportTemplate;
import com.agilemind.commons.application.modules.report.data.ReportApplicationData;
import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.application.modules.report.props.data.PersonInformation;
import com.agilemind.commons.application.modules.report.props.data.PublishingProfileData;
import com.agilemind.commons.application.modules.report.props.data.PublishingProfilesList;
import com.agilemind.commons.application.modules.report.props.data.ReportTransportType;
import com.agilemind.commons.application.modules.report.util.AdvRootTagReportGenerator;
import com.agilemind.commons.application.modules.report.util.AdvTemplateStringKey;
import com.agilemind.commons.application.modules.report.util.ReportGenerator;
import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.modules.storage.report.ReportStorageFactory;
import com.agilemind.commons.application.modules.variables.converter.CommonVariableGetterMap;
import com.agilemind.commons.application.modules.variables.converter.IVariableGetterMap;
import com.agilemind.commons.application.modules.variables.converter.SpsVariableGetterMap;
import com.agilemind.commons.application.service.AbstractTaskServiceImpl;
import com.agilemind.commons.application.service.ApplicationParametersService;
import com.agilemind.commons.application.service.CommonTaskService;
import com.agilemind.commons.application.service.ExportService;
import com.agilemind.commons.application.service.ProjectService;
import com.agilemind.commons.application.service.ProjectServiceImpl;
import com.agilemind.commons.application.service.TaskManagerSchedulerOperation;
import com.agilemind.commons.application.taskmanager.data.CommonTaskType;
import com.agilemind.commons.application.taskmanager.data.PublishTaskInfo;
import com.agilemind.commons.application.tasks.ExportOperation;
import com.agilemind.commons.application.tasks.ExportParams;
import com.agilemind.commons.application.util.EntitiesGetter;
import com.agilemind.commons.application.util.LocalizedException;
import com.agilemind.commons.application.views.MessageDialogProvider;
import com.agilemind.commons.gui.locale.keysets.BundleOptionPaneStringKeySet;
import com.agilemind.commons.gui.locale.keysets.OptionPaneStringKeySet;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.searchengine.searchengines.data.ISearchEngineSettings;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.modules.concurrent.util.operations.OperationState;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.function.SupplierEx;
import com.agilemind.commons.util.os.Platform;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class CommonTaskServiceImpl<P extends WebProject>
extends AbstractTaskServiceImpl<P>
implements CommonTaskService {
    private static final String[] g;

    public CommonTaskServiceImpl(ReportApplicationControllerImpl<P> reportApplicationControllerImpl) {
        super(reportApplicationControllerImpl);
    }

    @Override
    public void addDomainStrengthTask(ProjectService projectService) {
        UpdateProjectDomainFactorsCompositeOperation updateProjectDomainFactorsCompositeOperation2 = this.a(projectService);
        this.createWithNormalTaskInfo(CommonTaskType.DOMAIN_STRENGTH, projectService.getProjectInfo(), updateProjectDomainFactorsCompositeOperation2).setResultConsumer(updateProjectDomainFactorsCompositeOperation -> this.a(projectService, updateProjectDomainFactorsCompositeOperation.getResult())).setViewAction(updateProjectDomainFactorsCompositeOperation -> () -> this.applicationController.activateProjectControllerWithPath(projectService.getProjectId()).activate(this.applicationController.getDomainStrengthModuleClass())).setDefaultRunAgainAction().run(this);
    }

    @Override
    public void addExportSchedulerTask(ProjectLocationInfo projectLocationInfo, IScheduledTaskSettings iScheduledTaskSettings, ExportParams exportParams) {
        Function<WebProject, ExportOperation> function = webProject -> {
            ExportSupportedInfoProvider exportSupportedInfoProvider = (ExportSupportedInfoProvider)((Object)this.applicationController);
            Exporter exporter = exportSupportedInfoProvider.getExporter();
            ExportData exportData = exportSupportedInfoProvider.createExportData(webProject, EntitiesGetter.all());
            ExportService exportService = this.getExportService();
            PersonInformation personInformation = webProject.getReportProjectData().getCustomerInformation();
            return new ExportOperation(personInformation, exporter, exportData, exportService, exportParams);
        };
        this.createScheduled(CommonTaskType.EXPORT, projectLocationInfo, iScheduledTaskSettings, function).setViewAction(exportOperation -> () -> this.a(exportOperation.getTargetFile())).setDefaultRunAgainAction().run(this);
    }

    @Override
    public void addDomainStrengthScheduledTask(ProjectLocationInfo projectLocationInfo, IScheduledTaskSettings iScheduledTaskSettings) {
        Function<WebProject, UpdateProjectDomainFactorsCompositeOperation> function = webProject -> {
            ProjectServiceImpl projectServiceImpl = new ProjectServiceImpl((WebProject)webProject);
            return this.a(projectServiceImpl);
        };
        this.createScheduled(CommonTaskType.DOMAIN_STRENGTH, projectLocationInfo, iScheduledTaskSettings, function).addStartDefaultTypedLock().setOperationResultConsumer(webProject -> {
            ProjectServiceImpl projectServiceImpl = new ProjectServiceImpl((WebProject)webProject);
            return updateProjectDomainFactorsCompositeOperation -> this.a(projectServiceImpl, updateProjectDomainFactorsCompositeOperation.getResult());
        }).setViewAction(updateProjectDomainFactorsCompositeOperation -> () -> this.applicationController.activateProjectControllerWithPath(new ProjectId(projectLocationInfo.getLocation())).activate(this.applicationController.getDomainStrengthModuleClass())).setDefaultRunAgainAction().run(this);
    }

    @NotNull
    private UpdateProjectDomainFactorsCompositeOperation a(ProjectService projectService) {
        ISearchEngineSettings iSearchEngineSettings = this.createSearchEngineSettings(projectService);
        SearchEngineManager searchEngineManager = this.createNotificationSearchEngineManager(CaptchaNotificationFactory.getInstance(), projectService.getProjectId());
        return new UpdateProjectDomainFactorsCompositeOperation(projectService, iSearchEngineSettings, searchEngineManager, this.applicationController.getConnectionSettings());
    }

    private void a(ProjectService projectService, DomainAnalyzeResult domainAnalyzeResult) {
        ThreadSafeUtil.runInDispatchThread(() -> projectService.updateDomain(domainAnalyzeResult));
    }

    @Override
    public void addPublishReportScheduledTaskService(ProjectLocationInfo projectLocationInfo, IScheduledTaskSettings iScheduledTaskSettings, IReportTemplate iReportTemplate, List<String> list) {
        ReportApplicationData reportApplicationData = this.applicationController.getReportApplicationData();
        PublishingProfilesList publishingProfilesList = reportApplicationData.getPublishingProfilesList();
        Function<WebProject, PublishReportSchedulerOperation> function = webProject -> {
            ProjectService projectService = this.applicationController.createProjectService(webProject);
            AdvRootTagReportGenerator advRootTagReportGenerator = this.b(this.applicationController, projectService);
            SupplierEx supplierEx = () -> {
                if (iReportTemplate == null) {
                    throw new LocalizedException((StringKey)new AdvTemplateStringKey(g[1]));
                }
                ReportGenerator reportGenerator = iReportTemplate.isWidgetReportTemplate() ? this.a(this.applicationController, projectService) : advRootTagReportGenerator;
                return reportGenerator;
            };
            ReportStorageFactory reportStorageFactory = this.applicationController.getReportStorageFactory();
            return new PublishReportSchedulerOperation(projectService, this.applicationController.getStorageExceptionMapperFactory(), (SupplierEx<ReportGenerator, LocalizedException>)supplierEx, advRootTagReportGenerator, list, publishingProfilesList, iReportTemplate, reportStorageFactory, StorageAccountRequester.EMPTY_REQUESTER, this.getCustomerInformation(projectService), this.applicationController.getCompanyInformation(), this.createVariableGetterMap(projectService, iReportTemplate));
        };
        this.publishSchedule(projectLocationInfo, iScheduledTaskSettings, list, function);
    }

    protected void publishSchedule(ProjectLocationInfo projectLocationInfo, IScheduledTaskSettings iScheduledTaskSettings, List<String> list, Function<P, PublishReportSchedulerOperation> function) {
        AbstractTaskServiceImpl.ServiceSchedulerTaskRunner<P, PublishReportSchedulerOperation> serviceSchedulerTaskRunner = this.createScheduled(CommonTaskType.PUBLISH, projectLocationInfo, iScheduledTaskSettings, function);
        serviceSchedulerTaskRunner.setViewAction(publishReportSchedulerOperation -> {
            if (list.size() == 1) {
                return publishReportSchedulerOperation.getPublishedURI().stream().filter(Objects::nonNull).findFirst().map(this::a).orElse(null);
            }
            return null;
        }).setRunAgainAction(() -> {
            this.applicationController.getNotificationManager().addNotification(this.applicationController.getTaskNotificationFactory().createSchedulerNotification(iScheduledTaskSettings));
            serviceSchedulerTaskRunner.run(this);
        }).run(this);
    }

    @Override
    public void addPublishReportTaskService(ProjectService projectService, Function<IReportTemplate, ReportGenerator> function, IReportTemplate iReportTemplate, PublishingProfileData publishingProfileData, Runnable runnable) {
        boolean bl2 = TaskManagerSchedulerOperation.d;
        AdvRootTagReportGenerator advRootTagReportGenerator = this.b(this.applicationController, projectService);
        ReportStorageFactory reportStorageFactory = this.applicationController.getReportStorageFactory();
        PublishReportOperation publishReportOperation2 = new PublishReportOperation(projectService, this.applicationController.getStorageExceptionMapperFactory(), (SupplierEx<ReportGenerator, LocalizedException>)((SupplierEx)() -> (ReportGenerator)function.apply(iReportTemplate)), advRootTagReportGenerator, iReportTemplate, reportStorageFactory, StorageAccountRequester.EMPTY_REQUESTER, this.getCustomerInformation(projectService), this.applicationController.getCompanyInformation(), this.createVariableGetterMap(projectService, iReportTemplate), publishingProfileData);
        boolean bl3 = publishingProfileData.getPublishingProfile().getReportTransport().getReportTransportType() == ReportTransportType.MAIL_TRANSPORT_TYPE;
        this.create(new PublishTaskInfo(iReportTemplate.getName(), publishingProfileData.getPublishingProfileName()), projectService.getProjectInfo(), publishReportOperation2).setViewAction(publishReportOperation -> bl3 && publishReportOperation.getOperationState() == OperationState.OK ? null : this.a(publishReportOperation.getTargetURI(), runnable)).run(this);
        if (bl2) {
            Controller.g = !Controller.g;
        }
    }

    private Runnable a(URI uRI, Runnable runnable) {
        return uRI != null ? this.a(uRI) : runnable;
    }

    @NotNull
    private Runnable a(URI uRI) {
        return () -> {
            block5: {
                block4: {
                    if (!uRI.getScheme().equals(g[2])) break block4;
                    this.a(new File(uRI));
                    if (!TaskManagerSchedulerOperation.d) break block5;
                }
                try {
                    Platform.openURL((String)URLDecoder.decode(uRI.toString(), g[3]));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        };
    }

    private void a(File file) {
        block3: {
            block2: {
                if (!file.exists()) break block2;
                Platform.openFolderAndSelectFile((File)file);
                if (!TaskManagerSchedulerOperation.d) break block3;
            }
            MessageDialogProvider.showErrorMessageDialog(this.applicationController, (OptionPaneStringKeySet)new BundleOptionPaneStringKeySet((StringKey)new CommonsStringKey(g[0])));
        }
    }

    protected IPersonInformation getCustomerInformation(ProjectService projectService) {
        return projectService.getCustomerInformation();
    }

    private ReportGenerator a(ReportApplicationControllerImpl reportApplicationControllerImpl, ProjectService projectService) {
        return reportApplicationControllerImpl.getWidgetReportGenerator(projectService, false);
    }

    private AdvRootTagReportGenerator b(ReportApplicationControllerImpl reportApplicationControllerImpl, ProjectService projectService) {
        return (AdvRootTagReportGenerator)reportApplicationControllerImpl.getReportGenerator(projectService);
    }

    protected IVariableGetterMap createVariableGetterMap(ProjectService projectService, IReportTemplate iReportTemplate) {
        SpsVariableGetterMap spsVariableGetterMap = new SpsVariableGetterMap();
        this.appendValueGetterMap(projectService, spsVariableGetterMap, iReportTemplate);
        return spsVariableGetterMap;
    }

    protected <T extends ProjectService> void appendValueGetterMap(T t2, CommonVariableGetterMap commonVariableGetterMap, IReportTemplate iReportTemplate) {
        ApplicationParametersService applicationParametersService = this.applicationController.getParametersService();
        commonVariableGetterMap.setCompanyInformation(applicationParametersService.getCompanyInformation());
        commonVariableGetterMap.setProjectService(t2);
        commonVariableGetterMap.setCustomerInformation(t2.getCustomerInformation());
        commonVariableGetterMap.setReportTemplate(iReportTemplate);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "puLY(viLv\bk`[g\u001b}i@D\u0006vkN\u0019\u000bgfLG\u001avjG\u0019(viLy\u0001kCFB\u0000{";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 31;
                                break;
                            }
                            case 1: {
                                n9 = 5;
                                break;
                            }
                            case 2: {
                                n9 = 41;
                                break;
                            }
                            case 3: {
                                n9 = 55;
                                break;
                            }
                            default: {
                                n9 = 110;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "z}JR\u001eklFY@opK[\u0007lm\u0007T\u000fqqo^\u0000{WLG\u0001mq}R\u0003oiHC\u000b1qLO\u001a";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "ylER";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "JQo\u001aV";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        g = stringArray3;
    }
}

