/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.service;

import com.agilemind.commons.application.data.IProjectMetaData;
import com.agilemind.commons.application.data.WebProject;
import com.agilemind.commons.application.modules.datagroup.data.DataGroup;
import com.agilemind.commons.application.modules.datagroup.data.DataGroupSettingsRepository;
import com.agilemind.commons.application.modules.datagroup.data.ProjectDataGroupSettingsRepository;
import com.agilemind.commons.application.modules.factors.util.DomainAnalyzeResult;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistory;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.api.IPopularityHistoryMap;
import com.agilemind.commons.application.modules.projectmanager.ProjectId;
import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.application.service.GASocialVisitsService;
import com.agilemind.commons.application.service.PopularityHistoryService;
import com.agilemind.commons.application.service.PopularityHistoryServiceImpl;
import com.agilemind.commons.application.service.ProjectService;
import com.agilemind.commons.application.service.c;
import com.agilemind.commons.application.taskmanager.data.IProjectInfo;
import com.agilemind.commons.application.taskmanager.data.ProjectInfo;
import com.agilemind.commons.io.searchengine.searchengines.data.IGoogleAnalyticsSettings;
import com.agilemind.commons.io.searchengine.searchengines.data.ISearchEnginesAPIKeys;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.factors.SearchEngineFactorType;
import java.util.Date;
import java.util.List;

public class ProjectServiceImpl
implements ProjectService {
    private final WebProject a;

    public ProjectServiceImpl(WebProject webProject) {
        this.a = webProject;
    }

    @Override
    public ProjectId getProjectId() {
        return this.a.getProjectId();
    }

    @Override
    public UnicodeURL getProjectUrl() {
        return this.a.getProjectUrl();
    }

    @Override
    public boolean isIgnoreWWW() {
        return this.a.isIgnoreWWW();
    }

    @Override
    public Date getEntranceDate() {
        return this.a.getEntranceDate();
    }

    @Override
    public List<SearchEngineType> getUseSearchEngineList() {
        return this.a.getUseSearchEngineList().getList();
    }

    @Override
    public GASocialVisitsService getGASocialVisitsService() {
        return new c(this.a.getGaSocialVisitsMap());
    }

    @Override
    public IGoogleAnalyticsSettings getGoogleAnalyticsSettings() {
        return this.a.getGoogleAnalyticsSettings();
    }

    @Override
    public ISearchEnginesAPIKeys getSearchEnginesSettings() {
        return this.a.getSearchEnginesSettings();
    }

    @Override
    public PopularityHistoryService getPopularityHistoryService() {
        return new PopularityHistoryServiceImpl(this.a.getPopularityHistoryMap());
    }

    @Override
    public <T extends DataGroup> DataGroupSettingsRepository<T> getDataGroupSettingsRepository() {
        return new ProjectDataGroupSettingsRepository(this.a);
    }

    @Override
    public final IProjectInfo getProjectInfo() {
        return new ProjectInfo(this.a.getProjectId(), this.a.getProjectName());
    }

    @Override
    public List<SearchEngineFactorType<? extends Comparable>> getUseDomainSearchEngineFactorList() {
        return this.a.getUseDomainSearchEngineFactorList().getList();
    }

    @Override
    public void updateDomain(DomainAnalyzeResult domainAnalyzeResult) {
        this.a.setDomainThumbnail(domainAnalyzeResult.getThumbnail());
        PopularityHistoryMap popularityHistoryMap = this.a.getPopularityHistoryMap();
        domainAnalyzeResult.getFactorsValues().forEach((searchEngineFactorType, factorValue) -> {
            PopularityHistory popularityHistory = popularityHistoryMap.getPopularityHistory(searchEngineFactorType);
            popularityHistory.addFactorValue(factorValue.getCheckDate(), searchEngineFactorType, factorValue.getValue());
        });
    }

    @Override
    public IPersonInformation getCustomerInformation() {
        return this.a.getReportProjectData().getCustomerInformation();
    }

    @Override
    public IProjectMetaData getMetadata() {
        return this.a.getMetadata();
    }

    @Override
    public Long getCurrentReportTemplateId() {
        return this.a.getReportProjectData().getCurrentReportTemplateId();
    }

    @Override
    public final String getProjectName() {
        return this.a.getProjectName();
    }

    @Override
    public BinaryFile getDomainThumbnail() {
        return this.a.getDomainThumbnail();
    }

    @Override
    public IPopularityHistoryMap getPopularityHistoryMap() {
        return this.a.getPopularityHistoryMap();
    }

    @Override
    public WebProject getProject() {
        return this.a;
    }
}

