/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.service;

import com.agilemind.commons.application.gui.util.ProjectLocationInfo;
import com.agilemind.commons.application.modules.scheduler.data.IScheduledTaskSettings;
import com.agilemind.commons.application.modules.scheduler.data.ScheduledTaskState;
import com.agilemind.commons.application.service.ScheduledTasksService;
import com.agilemind.commons.application.taskmanager.data.TypedTask;
import com.agilemind.commons.modules.taskmanager.TaskId;
import com.agilemind.commons.modules.taskmanager.TaskManager;
import com.agilemind.commons.modules.taskmanager.listener.TaskRemovedListener;
import com.agilemind.commons.util.ThreadSafeUtil;
import java.util.Date;
import java.util.List;

public class ScheduledTaskRemovedListener
implements TaskRemovedListener<TypedTask> {
    private final TaskManager<TypedTask> a;
    private final TaskId b;
    private final ScheduledTasksService c;
    private final IScheduledTaskSettings d;
    private final ProjectLocationInfo e;

    public ScheduledTaskRemovedListener(TaskManager<TypedTask> taskManager, TaskId taskId, ScheduledTasksService scheduledTasksService, IScheduledTaskSettings iScheduledTaskSettings, ProjectLocationInfo projectLocationInfo) {
        this.a = taskManager;
        this.b = taskId;
        this.c = scheduledTasksService;
        this.d = iScheduledTaskSettings;
        this.e = projectLocationInfo;
    }

    public void taskRemoved(List<TypedTask> list) {
        list.stream().filter(typedTask -> typedTask.id().equals((Object)this.b)).findFirst().ifPresent(typedTask -> {
            if (!typedTask.getOperation().getOperationState().isLastState()) {
                ThreadSafeUtil.runInDispatchThread(() -> {
                    this.c.setFinishTime(this.d.getId(), this.e, new Date());
                    this.c.setState(this.d.getId(), this.e, ScheduledTaskState.STOPPED);
                });
            }
            this.a.removeTaskRemovedListener((TaskRemovedListener)this);
        });
    }
}

